<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header">    
        <?php        
        if ( is_single() ) :
            if ( true == get_theme_mod( 'udetor_courses_detail_show_page_title', true ) ) :
                the_title( '<h1 class="entry-title single-coures-title">', '</h1>' );    
            endif; 
        else :        
            if (has_post_thumbnail()): ?>
                <div class="entry-thumb">
                    <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark">
                        <?php the_post_thumbnail('udetor-blog-thumb'); ?>
                    </a>
                </div>
            <?php endif;
        endif; ?>
    </header><!-- .entry-header -->

    <div class="entry-course">
        <?php
        if ( is_archive() ) :
            the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
            <?php if (get_post_meta(get_the_ID(),'_courses_date_start', true) || get_post_meta(get_the_ID(),'_nbt_time_start', true) || get_post_meta(get_the_ID(),'_nbt_time_end', true)) : ?>
                <div class="education-course-info">
                    <?php if (get_post_meta(get_the_ID(),'_courses_date_start', true)): ?>
                        <span class="education-course-date">
                            <span class="nbticon nbticon-calendar"></span>
                            <?php echo date(get_option('date_format'),strtotime(get_post_meta(get_the_ID(),'_courses_date_start', true))); ?>
                        </span>
                    <?php endif; ?>
                    <?php if (get_post_meta(get_the_ID(),'_nbt_time_start', true) || get_post_meta(get_the_ID(),'_nbt_time_end', true)) : ?>
                        <span class="education-course-time">
                            <span class="nbticon nbticon-schedule-button"></span>
                            <?php
                            if (get_post_meta(get_the_ID(),'_nbt_time_start', true)):
                                printf(esc_html__('%s','udetor'), get_post_meta(get_the_ID(),'_nbt_time_start', true));
                            endif;
                            if (get_post_meta(get_the_ID(),'_nbt_time_start', true) || get_post_meta(get_the_ID(),'_nbt_time_end', true)):
                                echo esc_html__(' - ', 'udetor');
                            endif;
                            if (get_post_meta(get_the_ID(),'_nbt_time_end', true)):
                                printf(esc_html__('%s','udetor'), get_post_meta(get_the_ID(),'_nbt_time_end', true));
                            endif;
                            ?>
                        </span>
					<?php endif; ?>
                </div>
            <?php endif; ?>
        <?php else :
            the_content();
           
        endif;
        wp_link_pages(array(
                    'link_before'      => '<span>',
                    'link_after'       => '</span>',
                    'pagelink'         => '%',                            
                    'before' => '<div class="page-links blog-pagination">',
                    'after' => '</div>',
                    'nextpagelink' => esc_html__('&rarr;', 'udetor'),
                    'previouspagelink' => esc_html__('&larr;', 'udetor'),
                    )
            );
        ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->