<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
$grid_columns= get_theme_mod('udetor_blog_list_grid_columns');

$class_wap_article='';
$colunms_post= get_query_var('colunms_post');

if(isset($colunms_post) && $colunms_post !=''){
	switch ($colunms_post){
		case '1': $class_wap_article= 'col-md-12'; break;
		case '2': $class_wap_article= 'col-md-6'; break;
		case '3': $class_wap_article= 'col-md-6 col-sm-6 col-lg-4'; break;
		case '4': $class_wap_article= 'col-md-6 col-sm-6 col-lg-3'; break;
		default : $class_wap_article= 'col-md-6 col-sm-6 col-lg-4';
	}
}else{
	switch ($grid_columns){
		case '1': $class_wap_article= 'col-md-12'; break;
		case '2': $class_wap_article= 'col-md-6'; break;
		case '3': $class_wap_article= 'col-md-6 col-sm-6 col-lg-4'; break;
		case '4': $class_wap_article= 'col-md-6 col-sm-6 col-lg-3'; break;
		default : $class_wap_article= 'col-md-6 col-sm-6 col-lg-4';
	}
	
}
?>
<div class="blog-item <?php echo esc_html($class_wap_article); ?>">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>		
		<div class="entry-content">
			<?php
			if( has_post_thumbnail( ) ) {
	           	echo '<div class="post-thumbnail">';
	           	if($grid_columns=='1'){
	           		echo '<a href="' . esc_url( get_permalink() ) . '">';
	           		the_post_thumbnail('udetor-singlepost-thumb');
	           		echo '</a>';
	           	}else{
	           		echo '<a href="' . esc_url( get_permalink() ) . '">';
	           		the_post_thumbnail('udetor-blog-thumb');
	           		echo '</a>';
	           	}
	           	?>
				<ul class="post-meta">
					<li class="meta-reading-time">
					<?php
						if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			            echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
			            comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );			            
			            }
					?>
					</li>
					<?php if(function_exists('the_views')) { 
	                echo '<li class="meta-views">';
	                    echo '<i class="fa fa-eye"></i>';
	                    the_views(); 	                    
	                echo '</li>';
		            }
		            ?>
				</ul>
	           	<?php

	            echo '</div>';
	        }
	        ?>
	        <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
		        <?php
		        if ( 'post' === get_post_type() ) : ?>
					<div class="entry-meta post-meta heading3">
						<?php Udetor_Template_Tags::udetor_posted_meta(); ?>
					</div>
				<?php
				endif;
				if ( is_single() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;
				
				if ( has_excerpt() ){
					$udetor_blog_list_excerpt_length = get_theme_mod('udetor_blog_list_excerpt_length','15');
					
		            echo '<div class="entry-excerpt heading3">';
		            	echo wp_trim_words( get_the_excerpt(), $udetor_blog_list_excerpt_length, '...' );
		            echo '</div>';
		        }
				?>
				<a href="<?php the_permalink(); ?>" class="read-more secondary_btn"><span><?php echo esc_html__( 'Read more','udetor' ); ?></span></a>
	        	
	        </div>
	       
		</div>
	</article><!-- #post-## -->
</div>

