<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
$grid_columns= get_theme_mod('udetor_search_page_grid_col', '4');

switch ($grid_columns){
		case '1': $class_wap_article= 'col-md-12'; break;
		case '2': $class_wap_article= 'col-md-6'; break;
		case '3': $class_wap_article= 'col-md-6 col-sm-6 col-lg-4'; break;
		case '4': $class_wap_article= 'col-md-6 col-sm-6 col-lg-3'; break;
		default : $class_wap_article= 'col-md-6 col-sm-6 col-lg-4';
}
?>
<div class="blog-item <?php echo esc_html($class_wap_article); ?>">
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>	
	<div class="entry-content">
		<?php
			if( has_post_thumbnail( ) ) {
	           	echo '<div class="post-thumbnail">';
	           	if($grid_columns=='1'){
	           		echo '<a href="' . esc_url( get_permalink() ) . '">';
	           		the_post_thumbnail('udetor-singlepost-thumb');
	           		echo '</a>';
	           	}else{
	           		echo '<a href="' . esc_url( get_permalink() ) . '">';
	           		the_post_thumbnail('udetor-blog-thumb');
	           		echo '</a>';
	           	}
	            echo '</div>';
	        }
	    ?>
        <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
        <?php
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		$post_type_s = get_post_type( get_the_ID());
		
		$post_type_o = get_post_type_object(  $post_type_s );
		if($post_type_o->label){
			echo '<div class="searcg-pt"><span>'.$post_type_o->label.'</span></div>';
		}

		if ( 'post' === get_post_type() ) : ?>
			<div class="entry-meta">
				<?php Udetor_Template_Tags::udetor_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php
		endif; 
		
        if ( has_excerpt() ){
					$udetor_blog_list_excerpt_length = get_theme_mod('udetor_blog_list_excerpt_length','15');
					
		            echo '<div class="entry-excerpt heading3">';
		            	echo wp_trim_words( get_the_excerpt(), $udetor_blog_list_excerpt_length, '...' );
		            echo '</div>';
		}
		?>
		<a href="<?php the_permalink(); ?>" class="read-more secondary_btn"><span><?php echo esc_html__( 'Read more','udetor' ); ?></span></a>        	
        </div>       
	</div>
</article><!-- #post-## -->
</div>
