<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
$udetor_sidebars_pages_below_title = get_theme_mod('udetor_sidebars_pages_below_title');
$udetor_sidebars_pages_above_title = get_theme_mod('udetor_sidebars_pages_above_title');
$udetor_sidebars_pages_below_content = get_theme_mod('udetor_sidebars_pages_below_content');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<?php
			the_content();

			wp_link_pages(array(
                    'link_before'      => '<span>',
                    'link_after'       => '</span>',
                    'pagelink'         => '%',                            
                    'before' => '<div class="page-links blog-pagination">',
                    'after' => '</div>',
                    'nextpagelink' => esc_html__('&rarr;', 'udetor'),
                    'previouspagelink' => esc_html__('&larr;', 'udetor'),
                    )
            );
		?>
	</div><!-- .entry-content -->

	<?php
		if( !is_front_page()  && is_active_sidebar($udetor_sidebars_pages_below_content)): 
        	dynamic_sidebar($udetor_sidebars_pages_below_content);
        	
        endif;
		?>
</article><!-- #post-## -->
