<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php 
    if ( is_single() ) {        
    ?>
    <div class="row">
        <div class="col-lg-9">
            <div class="entry-header education-event-header mgb15">
                <?php the_title( '<h2 class="entry-title single-event-title">', '</h2>' ); ?>
                <div class="education-event<?php echo has_post_thumbnail() ? '-thumb' : ''; ?>-time">
                            <?php if (has_post_thumbnail()): ?>
                                <div class="entry-thumb text-center">
                                    <?php the_post_thumbnail(); ?>
                                </div>
                            <?php endif;?>
                            <div class="education-event-time-countdown">
                                <?php  
                                    $datetime = espresso_event_date_obj($post->ID);                                    
                                    $start_date = $datetime->start_date('Y/m/d');                                    
                                ?>
                                <div data-countdown="<?php printf(esc_html__('%s', 'udetor'), $start_date); ?>" class="education-time-countdown">
                                    <div class="education-days"><span></span><?php echo esc_html__('Days','udetor');?></div>
                                    <div class="education-hours"><span></span><?php echo esc_html__('Hours','udetor');?></div>
                                    <div class="education-mins"><span></span><?php echo esc_html__('Mins','udetor');?></div>
                                    <div class="education-secs"><span></span><?php echo esc_html__('Secs','udetor');?></div>
                                </div>
                            </div>
                </div>
            </div>
            <?php
            if(true== get_theme_mod( 'udetor_event_details_show_social_sharing', true )){
                echo '<div class="social-share-icon">';
                echo '<span class="social-label">'. esc_html__( 'Share:', 'udetor' ) .'</span>';
                if ( is_plugin_active( 'netbase-toolkit/app.php' ) ) {
                    echo do_shortcode( '[udetor_social_share]' );
                }
                echo '</div>';
            }            

            echo '<h2 class="udetor-detail-title detail-page-title">'. esc_html__( 'Pay for Ticket', 'udetor' ).'</h2>';
            espresso_get_template_part( 'content', 'espresso_events-tickets' );
            ?>
            <div class="entry-content education-event-content">
                <?php       
                echo '<h2 class="udetor-detail-title detail-page-title">'. esc_html__( 'Event Description', 'udetor' ).'</h2>';                         
                    espresso_get_template_part( 'content', 'espresso_events-details' );
                ?>
            </div>
            <?php
            $people = get_post_meta(  $post->ID, 'udetor_event_people', true);
            if($people){    
                $attr = array();      
                $attr[] = '"items": "4"';
                $attr[] = '"tablet": "3"';
                $attr[] = '"nav": "false"';
                $attr[] = '"dots": "false"';
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';      
                echo '<div class="event-meta-participant">';
                echo '<h2 class="udetor-detail-title detail-page-title">'. esc_html__( 'Guests Participant', 'udetor' ).'</h2>';
                echo '<ul class="udetor-carousel owl-carousel owl-loaded owl-drag" '.$data_owlcarousel.'>';
                foreach ($people as $usrid){
                $author_obj = get_user_by('id', $usrid);
                echo '<li>';
                    echo '<img src="'.esc_url( get_avatar_url( $usrid ) ).' " />';
                    echo '<h3 class="people-name">'.$author_obj->display_name.'</h3>';  
                    $job_profile = get_the_author_meta( 'job_profile', $usrid);
                    if ( $job_profile && $job_profile != '' ) {                            
                        echo '<h4 class="author-job">' . esc_html( $job_profile ) . '</h4>';                            
                    }                  
                echo '</li>';
                }

                echo '</ul>';
                echo '</div>';
            }
            ?>
        </div>
        <div class="col-lg-3 sidebar-detail-event">
            <?php 
            $cei_title = get_theme_mod( 'udetor_event_detail_info_title', '' );
            if(isset($cei_title) && $cei_title !=''){
                echo '<div class="sidebar-title">'. esc_html( $cei_title ).'</div>';
            }else{
                echo '<div class="sidebar-title">'. esc_html__( 'Event infomation', 'udetor' ).'</div>';    
            }
            
            echo Udetor_Content::udetor_espresso_event_dates_detail( $post->ID );                           
            espresso_get_template_part( 'content', 'espresso_events-venues' );
            ?>
            
        </div>
    </div>

    <?php
        
        
    }else{
        ?>  
        <div class="row">
            <?php if (has_post_thumbnail()){ ?>
                <div class="col-md-4 archive-entry-thumb aethumb">                    
                    <?php
                    echo '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">'; 
                    the_post_thumbnail('udetor-course-thumb'); 
                    echo '</a>';
                    ?>
                    
                </div>
                <div class="col-md-8">
            <?php 
            }else{
                echo '<div class="col-md-12">';    
            } 
            ?>
            <?php 
            echo Udetor_Content::udetor_espresso_list_of_event_dates( $post->ID );               
            the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); 
            if ( is_archive() && has_excerpt() ) :
                echo '<p class="lst-event-des">';
                espresso_get_template_part( 'content', 'espresso_events-venues' );                       
                printf(esc_html__('%s', 'udetor'), wp_trim_words(get_the_excerpt(), 35, '...'));
                echo '</p>';
            endif;
            ?>
                
            </div>
        </div>
        
        <?php
    }
    
    
    
    ?>    
</article><!-- #post-## -->
