<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
$udetor_sidebars_blog_above = get_theme_mod('udetor_sidebars_blog_above');
$udetor_sidebars_blog_below = get_theme_mod('udetor_sidebars_blog_below');

get_header(); ?>
<div class="udetor-page-title">
    <div class="entry-header container">
	    <div class="col-md-12">
	    <?php 
	    if ( true != get_theme_mod( 'udetor_blog_list_hidden_page_title', false ) ) : ?>
	        <h1 class="entry-title"><?php single_term_title(); ?></h1>
	    <?php endif; ?>   
	        <?php 
			if ( true != get_theme_mod( 'udetor_blog_list_hidden_breadcrumb', false ) ) :
				Udetor_Core::get_udetor_template('breadcrumbs'); 
			endif;
			?>
		</div>
    </div>  
    
</div>
	<div id="content" class="container site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">		
		<?php
		if(is_active_sidebar($udetor_sidebars_blog_above)): 
        	dynamic_sidebar($udetor_sidebars_blog_above);
        	
        endif;
		
		if ( have_posts() ) : 
			/* Start the Loop */
			global $post, $wp_query;

			if ( is_category() ) {
				$total = get_queried_object();
				$total = $total->count;
			} elseif ( !empty( $_REQUEST['s'] ) ) {
				$total = $wp_query->found_posts;
			} else {
				$total = wp_count_posts( 'post' );
				$total = $total->publish;
			}

			if ( $total == 0 ) {
				echo '<p class="message message-error">' . esc_html__( 'There are no available posts!', 'udetor' ) . '</p>';
				return;
			} elseif ( $total == 1 ) {
				$index = esc_html__( 'Showing only one result', 'udetor' );
			} else {
				$courses_per_page = absint( get_option( 'posts_per_page' ) );
				$paged            = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;

				$from = 1 + ( $paged - 1 ) * $courses_per_page;
				$to   = ( $paged * $courses_per_page > $total ) ? $total : $paged * $courses_per_page;

				if ( $from == $to ) {
					$index = sprintf(
						esc_html__( 'Showing last post of %s results', 'udetor' ),
						$total
					);
				} else {
					$index = sprintf(
						esc_html__( 'Showing %s-%s of %s results', 'udetor' ),
						$from,
						$to,
						$total
					);
				}
			}			
			?>
			<div class="switch-layout-container">
				<div class="switch-layout udetor-switch">
					<a href="#" class="list switchToGrid  switch-active"><i class="fa fa-th-large"></i></a>
					<a href="#" class="grid switchToList"><i class="fa fa-list-ul"></i></a>
				</div>
				<div class="post-index"><?php echo esc_html( $index ); ?></div>
				<div class="searching">					
					<form role="search" method="get" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					    <div>
					        <label class="screen-reader-text" for="s"><?php esc_html_e( 'Search for:','udetor' ); ?></label>
					        <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="Search for blog" />
					        <span class="input-group-btn">
					        	<input type="submit" id="searchsubmit" value="<?php echo esc_html_e( 'Search ', 'udetor' ); ?>" />	
					        </span>
					        
					    </div>
					</form>
				</div>
			</div>
			<div id="udetor-blog-archive" class="udetor-layout-grid">
				<div class="container">
					<div class="row">
					<?php
					while ( have_posts() ) : the_post();

					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */

					get_template_part( 'template-parts/content', get_post_format() );

					endwhile;?>
					</div>
				</div>
			</div>
			<?php			
			if ( true == get_theme_mod( 'udetor_blog_list_show_post_nav', true ) ) :  
				Udetor_Helper::udetor_paging_nav();
			endif;

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		 
		if(is_active_sidebar($udetor_sidebars_blog_below)): 
        	dynamic_sidebar($udetor_sidebars_blog_below);
        	
        endif;
		?>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
	get_sidebar();
}
get_footer();
