<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Udetor
 */
$udetor_sidebars_blog_detail_above = get_theme_mod('udetor_sidebars_blog_detail_above');
$udetor_sidebars_blog_detail_below = get_theme_mod('udetor_sidebars_blog_detail_below');
$udetor_sidebars_blog_detail_below_comment = get_theme_mod('udetor_sidebars_blog_detail_below_comment');
$udetor_courses_lesson_subheading = get_theme_mod('udetor_courses_lesson_subheading','' );
get_header(); ?>

<?php
if(get_post_type()=='espresso_events'){ ?>

    <div class="single-blog-title udetor-page-title events-pagetitle">
        <div class="entry-header container">
            
                <div class="col-md-12">
                    <h1 class="entry-title"><?php echo esc_html__('Event','udetor'  ); ?></h1>
                    <?php Udetor_Core::get_udetor_template('breadcrumbs');  ?>
                </div>
            
        </div>  
        
    </div>
<?php
}else{
?>
    <div class="single-blog-title udetor-page-title">
        <div class="entry-header container">            
                <div class="col-md-12">
                    <h1 class="entry-title"><?php the_title(); ?></h1>
                    <?php if($udetor_courses_lesson_subheading !='' && get_post_type() == 'sfwd-lessons' || get_post_type() == 'sfwd-topic' || get_post_type() == 'sfwd-quiz') : 
                        echo '<div class="ld-subheading">'. esc_html($udetor_courses_lesson_subheading) .'</div>';
                    endif;  

                    if ( 'post' == get_post_type() ) : 
                        echo '<div class="entry-meta">';
                             Udetor_Helper::udetor_meta_posted_on(); 
                        echo '</div>';
                    endif; 
                    ?>
                </div>            
        </div>
    </div>
    <?php
}
?>
<div id="content" class="container site-content <?php if(get_post_type()=='espresso_events'){ esc_html_e( 'no-sidebar', 'udetor' ); }else{ echo esc_html(Udetor_Helper::udetor_get_layout_class()); }  ?>">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">        
        <?php
        if(is_active_sidebar($udetor_sidebars_blog_detail_above)): 
            dynamic_sidebar($udetor_sidebars_blog_detail_above);
            
        endif;
        
		while ( have_posts() ) : the_post(); 
            if (get_post_type()=='espresso_events'):
                get_template_part( 'template-parts/content', 'event' );
            else:
    	?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <?php
                        if( has_post_thumbnail( ) ) {
                            echo '<div class="single-post-thumbnail mgb30 text-center">';
                                    the_post_thumbnail();
                            echo '</div>';
                        }
                    ?> 
                    <div class="post-wrap">                     
                        <?php if ( true == get_theme_mod( 'udetor_blog_single_show_social_sharing', false ) ) : 
                            echo '<div class="post-social social-share-icon">';
                           
                    
                            if ( is_plugin_active( 'netbase-toolkit/app.php' ) ) {
                                echo do_shortcode( '[udetor_social_share]' );
                            }
                    
                            echo '</div>';
                        endif; ?>
                        
                        <section class="post-entry post-main <?php if ( true == get_theme_mod( 'udetor_blog_single_show_social_sharing', false ) ) { echo 'flex-box-40'; } ?>">                            
                            <?php the_content(); ?>
                            <?php 
                            wp_link_pages(array(
                                'link_before'      => '<span>',
                                'link_after'       => '</span>',
                                'pagelink'         => '%',                            
                                'before' => '<div class="blog-pagination">',
                                'after' => '</div>',
                                'nextpagelink' => esc_html__('&rarr;', 'udetor'),
                                'previouspagelink' => esc_html__('&larr;', 'udetor'),
                                )
                            ); ?>
                            <?php if(has_tag()): ?>
                                <div class="post-footer-tag">
                                <?php the_tags(esc_html__('Tagged with:', 'udetor') . ' ', ' ', '<br />'); ?>  
                                </div> 
                            <?php endif; ?>
                           
                        </section>
                    </div>    
                           
                </article>
                <?php if(get_the_author_meta('description')!=''): ?>
                <div class="nbauthor-bio">
                    <div class="line-avatar">
                        <?php echo get_avatar( get_the_author_meta('email'), '82' ); ?>
                        <div class="info">
                            <span class="author-name"><?php the_author_link(); ?></span>

                            <?php 
                            $job_profile_author = get_the_author_meta( 'job_profile' );
                            
                            if ( $job_profile_author && $job_profile_author != '' ) {                            
                                echo '<span class="author-job">' . esc_html( $job_profile_author ) . '</span>';                            
                            }
                            ?>
                            
                        </div>
                    </div>
                    <div class="author-info">
                        <div class="author-description"><?php the_author_meta('description'); ?></div>
                        
                        <ul class="icons">
                            <?php
                                $google_profile = get_the_author_meta( 'google_profile' );
                                if ( $google_profile && $google_profile != '' ) {
                                    echo '<li class="google"><a href="' . esc_url($google_profile) . '" rel="author"><i class="fa fa-google-plus" aria-hidden="true"></i></a></li>';
                                }

                                $twitter_profile = get_the_author_meta( 'twitter_profile' );
                                if ( $twitter_profile && $twitter_profile != '' ) {
                                    echo '<li class="twitter"><a href="' . esc_url($twitter_profile) . '"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>';
                                }
                                $facebook_profile = get_the_author_meta( 'facebook_profile' );
                                if ( $facebook_profile && $facebook_profile != '' ) {
                                    echo '<li class="facebook"><a href="' . esc_url($facebook_profile) . '"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>';
                                }
                                $linkedin_profile = get_the_author_meta( 'linkedin_profile' );
                                if ( $linkedin_profile && $linkedin_profile != '' ) {
                                    echo '<li class="linkedin"><a href="' . esc_url($linkedin_profile) . '"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>';
                                }
                                $pinterest_profile = get_the_author_meta('pinterest_profile');
                                if ( $pinterest_profile && $pinterest_profile != '' ) {
                                    echo '<li class="linkedin"><a href="' . esc_url($pinterest_profile) . '"><i class="fa fa-pinterest-p" aria-hidden="true"></i></a></li>';
                                }
                                $instagram_profile = get_the_author_meta('instagram_profile');
                                if ( $instagram_profile && $instagram_profile != '' ) {
                                    echo '<li class="linkedin"><a href="' . esc_url($instagram_profile) . '"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>';
                                }
                                ?>
                            </ul>
                    </div>
                </div>
                <?php endif; ?>

                <?php            
                if ( true == get_theme_mod( 'udetor_blog_single_show_post_nav', true ) ) : 
    			    $prev_post = get_previous_post();
                    $next_post = get_next_post();                 
                ?>
                <?php if ( !empty( $prev_post ) || !empty( $next_post ) ): ?>
                        <div class="entry-navigation-post">
                            <?php
                            if ( !empty( $prev_post ) ):
                                $thumbnail_prev = wp_get_attachment_image_src(get_post_thumbnail_id($prev_post->ID), 'udetor-blog-thumb');
                            ?>
                                <div class="prev-post <?php if(!$thumbnail_prev){ echo 'bgcc'; } ?>">
                                    <?php if(isset($thumbnail_prev) && $thumbnail_prev){
                                    echo '<div class="wap-fi">';                                
                                        echo '<img src="'.esc_url($thumbnail_prev[0]).'" alt="post">';
                                    echo '</div>';
                                    } ?>
                                    
                                    <div class="wap-npp">
                                        <div class="wapc-npp">
                                            <p class="heading"><?php echo esc_html__( 'Previous post', 'udetor' ); ?></p>
                                            <h5 class="title">
                                                <a href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php echo esc_html( $prev_post->post_title ); ?></a>
                                            </h5>
                                            <div class="date">
                                                <?php echo get_the_date( get_option( 'date_format' ) ); ?>
                                            </div>
                                        </div>
                                        
                                    </div>                                
                                </div>
                            <?php endif; ?>

                            <?php
                            if ( !empty( $next_post ) ):
                                $thumbnail_next = wp_get_attachment_image_src(get_post_thumbnail_id($next_post->ID), 'udetor-blog-thumb');
                            
                                ?>
                                <div class="next-post <?php if(!$thumbnail_next){ echo 'bgcc'; } ?>" >
                                <?php if(isset($thumbnail_next) && $thumbnail_next){
                                    echo '<div class="wap-fi">';                                
                                        echo '<img src="'.esc_url($thumbnail_next[0]).'" alt="post">';
                                    echo '</div>';
                                    } ?>
                                    
                                    <div class="wap-npp">
                                        <div class="wapc-npp">
                                        <p class="heading"><?php echo esc_html__( 'Next post', 'udetor' ); ?></p>
                                        <h5 class="title">
                                            <a href="<?php echo get_permalink( $next_post->ID ); ?>"><?php echo esc_html( $next_post->post_title ); ?></a>
                                        </h5>
                                        <div class="date">
                                            <?php echo get_the_date( 'j F, Y', $next_post->ID ); ?>
                                        </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            <?php endif; ?>
                        </div>

                    <?php endif;

                endif;
                ?>

                <?php 
                if ( true == get_theme_mod( 'udetor_blog_single_show_related_posts', true ) ) : 
                    Udetor_Content::udetor_get_related_post($post->ID) ; 
                endif;
                ?>

                <?php
    			// If comments are open or we have at least one comment, load up the comment template.
                if ( true == get_theme_mod( 'udetor_blog_single_show_comment_area', true ) ) : 
        			if ( comments_open() || get_comments_number() ) :
        				comments_template();

                        if(is_active_sidebar($udetor_sidebars_blog_detail_below_comment)): 
                            dynamic_sidebar($udetor_sidebars_blog_detail_below_comment);
                    
                        endif;
        			endif;
                endif;
            endif;
		endwhile; // End of the loop.
		?>		

        <?php
            if(is_active_sidebar($udetor_sidebars_blog_detail_below)): 
                dynamic_sidebar($udetor_sidebars_blog_detail_below);
                
            endif;
        ?>
        
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
if(get_post_type()!='espresso_events'){
    if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
        get_sidebar();
    }
}
get_footer();
