<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Udetor
 */

get_header(); 
?>
<div class="header-page">
    <div class="container">
        <div class="row">
            <div class="info-header-page">
            <?php 
            $categories = get_the_terms( get_the_ID(), 'course_category' );
            
            if($categories && count($categories)>0){
                echo '<div class="cat-single font-h1">';
                foreach( $categories as $term ) {                    
                    echo  '<span class="udetor-term-name">'.esc_html($term->name).'</span>';

                }                   
                echo '</div>';
            } 
            if ( true == get_theme_mod( 'udetor_courses_detail_show_breadcrumb', true ) ) :                
                echo Udetor_Helper::udetor_learn_dash_breadcrumbs();
            endif;
            ?>
            </div>
        </div>  
    </div>
</div>
<div id="content" class="container site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
    <div id="primary" class="content-area">
        <div class="container education-single-<?php echo get_post_type(); ?>">
            <div class="row">
                <main id="main" class="site-main">
                    <?php
                    while ( have_posts() ) :
                        the_post();
                        get_template_part( 'template-parts/courses/content-type', get_post_type() );
                        the_post_navigation();
                    endwhile; // End of the loop.
                    ?>
                </main><!-- #main -->                
            </div>
        </div>
        
    </div><!-- #primary -->
<?php
if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
    get_sidebar();
}

if ( true == get_theme_mod( 'udetor_courses_detail_other_show_related', true ) ) : 
    echo '<div class="col-md-12 col-xs-12 clear pdb90">';
        Udetor_Content::udetor_get_related($post->ID,'sfwd-courses') ; 
    echo '</div>';
endif;

get_footer();
