<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */

get_header(); 
$udetor_sidebars_pages_above_title = get_theme_mod('udetor_sidebars_pages_above_title');
$udetor_sidebars_pages_below_title = get_theme_mod('udetor_sidebars_pages_below_title');

$custom_page_title_position =  esc_html( get_post_meta(  $post->ID, 'custom_page_title_position', true) );
$custom_page_title_hidden = '';
$custom_breadcrumbs_page_hidden ='';
$custom_page_title_hidden = get_post_meta($post->ID,'custom_page_title_hidden', true);
$custom_breadcrumbs_page_hidden = get_post_meta($post->ID,'custom_breadcrumbs_page_hidden', true);

$class_title_position ='';
if(isset($custom_page_title_position) && $custom_page_title_position !=''){
	switch ($custom_page_title_position){
		case 'default': $class_title_position= 'edue-text-default'; break;
		case 'center': $class_title_position= 'text-center'; break;
		case 'left': $class_title_position= 'text-left'; break;
		case 'right': $class_title_position= 'text-right'; break;
		
		default : $class_title_position= 'edue-text-default';
	}
}
?>

<?php if (!is_page( 'home-academy' ) && !is_page( 'home-online-learning' ) && !is_page( 'udetor-home-standard' ) && !is_front_page() && !is_home() && true == get_theme_mod( 'udetor_show_page_title', true ) &&  $custom_page_title_hidden!='1') : ?>
<div class="udetor-page-title <?php if ( true == get_theme_mod( 'udetor_page_title_full', true ) ) { echo 'full'; } ?>">
    <div class="container <?php echo esc_attr($class_title_position) ;?>">
        
        <?php
        if(is_active_sidebar($udetor_sidebars_pages_above_title)): 
        	dynamic_sidebar($udetor_sidebars_pages_above_title);
        endif;
        ?>    
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
        
        <?php 	
        if($custom_breadcrumbs_page_hidden !='1'){
        	Udetor_Core::get_udetor_template('breadcrumbs'); 		
        }		
		
		if(is_active_sidebar($udetor_sidebars_pages_below_title)): 
        	dynamic_sidebar($udetor_sidebars_pages_below_title);
        	
        endif;
		?>
        
    </div>  
    
</div>
<?php endif; ?>
	<div id="content" class="container site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">	

			<?php
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/content', 'page' );

				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile; // End of the loop.
			?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
	get_sidebar();		
}

get_footer();
