<?php
/**
 * Displays a course
 *
 * Available Variables:
 * $course_id       : (int) ID of the course
 * $course      : (object) Post object of the course
 * $course_settings : (array) Settings specific to current course
 * 
 * $courses_options : Options/Settings as configured on Course Options page
 * $lessons_options : Options/Settings as configured on Lessons Options page
 * $quizzes_options : Options/Settings as configured on Quiz Options page
 * 
 * $user_id         : Current User ID
 * $logged_in       : User is logged in
 * $current_user    : (object) Currently logged in user object
 * 
 * $course_status   : Course Status
 * $has_access  : User has access to course or is enrolled.
 * $materials       : Course Materials
 * $has_course_content      : Course has course content
 * $lessons         : Lessons Array
 * $quizzes         : Quizzes Array
 * $lesson_progression_enabled  : (true/false)
 * $has_topics      : (true/false) 
 * $lesson_topics   : (array) lessons topics 
 * 
 * @since 2.1.0
 * 
 * @package Udetor
 */

$udetor_layout_tab_extra = get_theme_mod('udetor_courses_detail_layout_tab_extra');
if($udetor_layout_tab_extra){
    if($udetor_layout_tab_extra =='vertical'){
        $class_extra_title= 'col-lg-3 col-md-12 col-sm-12 col-xs-12';
        $class_extra_content= 'col-lg-9 col-md-12 col-sm-12 col-xs-12';    
    }elseif($udetor_layout_tab_extra =='horizontal'){
        $class_extra_title= 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
        $class_extra_content= 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
    }
    
}else{
    $class_extra_title= 'col-lg-3 col-md-3 col-sm-3 col-xs-3';
    $class_extra_content= 'col-lg-9 col-md-9 col-sm-9 col-xs-9'; 
}
$course_data = get_post_meta($post->ID, '_sfwd-courses', true);
$learndash_certificate_details = Udetor_Content::udetor_get_certificate_detail($course_data['sfwd-courses_certificate']);

$startTimeStamp = get_post_meta($post->ID, '_courses_date_start', true);
$endTimeStamp = get_post_meta($post->ID, '_courses_date_end', true);

if (!empty($course_certficate_link)) : ?>
    <div id="learndash_course_certificate">
        <a href='<?php echo esc_url($course_certficate_link); ?>' class="btn-blue" target="_blank"><?php echo apply_filters('ld_certificate_link_label', esc_html__('PRINT YOUR CERTIFICATE', 'udetor'), $user_id, $post->ID); ?></a>
    </div>
    <br />
<?php endif; ?>
<?php
if ( is_single() ) :
?>
    <div class="course-single-meta course-detail-item">
        <?php if ( $has_course_content && true == get_theme_mod( 'udetor_courses_detail_extra_show_instructor', true )) : ?>
        <div class="meta-item">
            <?php 
            if(get_the_author()){
                $byline = sprintf(
                        _x( '%s', 'post author', 'udetor' ),
                        '<span class="author vcard">' . esc_html( get_the_author() ) . '</span>'
                    );
                    echo '<div class="course-single-label">' . esc_html__( 'Instructor', 'udetor' ) . '</div>';
                    echo '<div class="lst-author">'.get_avatar( get_the_author_meta('email'), '51' ).''. $byline .'';
                        $job_profile = get_the_author_meta( 'job_profile' );
                        if ( $job_profile && $job_profile != '' ) {
                            echo '<div class="job_profile">' . esc_html($job_profile) . '</div>';
                        } 
                    echo '</div>';
                }
            ?>                    
        </div>
        <?php endif; ?>
        <div class="meta-item">
            <?php
            $metaterms = get_the_terms( get_the_ID(), 'course_category' );            
            if($metaterms && count($metaterms)>0){
                echo '<div class="course-single-label">' . esc_html__( 'Category', 'udetor' ) . '</div>';
                echo '<div class="cat-single font-h1">';
                foreach( $metaterms as $terms ) {
                    $meta_term_link = get_term_link( $terms );                     
                    echo '<a href="' . esc_url( $meta_term_link ) . '">' . esc_html($terms->name) . '</a>';
                }                   
                echo '</div>';
            }      
            ?>
        </div>
        <div class="meta-item">
            <?php 
                $comments_count = wp_count_comments(get_the_ID());
                echo '<div class="course-single-label">' . esc_html__( 'Review', 'udetor' ) . '('.$comments_count->approved.')</div>';
                echo Udetor_Helper::udetor_reviews_star(get_the_ID());
            ?>                    
        </div>  
    </div>
    <div class="course-single-payment course-detail-item">
            <?php            
            if ($course_data['sfwd-courses_course_price_type']=='free' || !$course_data['sfwd-courses_course_price']){
                    echo ('<div class="nbt-date-price">');
                    echo ('<span>' . esc_html__('Free','udetor') . '</span>');
                    echo ("</div>");
                } else {
                    
                    $currency = null;
                    
                    if(is_null($currency)){
                        $currency = 'USD';
                    }
                    $price = $course_data['sfwd-courses_course_price'];
                    if(is_numeric($price)){
                        if($currency == "USD"){
                            $price = '$' . $price;
                        } else {
                            $price .= ' ' . $currency;
                        }
                    }
                    if ($course_data['sfwd-courses_course_price']) {
                        echo ('<div class="nbt-date-price">');
                        echo ('<span>' . esc_html($price) . '</span>');
                        echo ("</div>");
                    }
                }

            ?>
            <?php if ( $logged_in ) : ?>
                <div id="learndash_course_status">
                    <b><?php printf(esc_html_x('%s Status:', 'Course Status Label', 'udetor'), LearnDash_Custom_Label::get_label('course')); ?></b> <?php printf(esc_html__('%s', 'udetor'), $course_status);  ?>
                </div>
                <?php if (!empty($course_certficate_link)) : ?>
                    <div id="learndash_course_certificate">
                        <a href='<?php echo esc_url($course_certficate_link); ?>' class="btn-blue" target="_blank"><?php echo apply_filters('ld_certificate_link_label', esc_html__('PRINT YOUR CERTIFICATE', 'udetor'), $user_id, $post->ID); ?></a>
                    </div>
                    <br />
                <?php endif; ?>
            <?php endif; ?>
            <?php if ( ! $has_access ) : ?>
                <?php echo learndash_payment_buttons( $post ); ?>
            <?php endif; ?>
            </div>
            <?php
            if (has_post_thumbnail()): ?>
                <div class="course-single-thumb course-detail-item">
                    <?php the_post_thumbnail(); ?>
                    
                </div>
            <?php endif; ?>
<?php endif; ?>
<?php if ( true == get_theme_mod( 'udetor_courses_detail_show_features', true ) ) :  ?>
    
    <div class="course-features course-detail-item">
        <h2 class="udetor-detail-title"><?php echo esc_html__('Course Features', 'udetor'); ?></h2>
        <div class="row">
            <div class="col-md-12 pd0">
                <ul class="course-features-item">
                    <?php if($lessons): ?>
                        <li>
                        <?php echo  wp_kses(__(' <i class="fa fa-file-text-o"></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Lessons', 'udetor' ); ?></span><span class="udetor-value"><?php echo count($lessons).' '.esc_html__('lessons', 'udetor');?></span>
                        </li>
                    <?php endif; ?>
                    <?php if($quizzes): ?>
                        <li>
                        <?php echo  wp_kses(__(' <i class="fa fa-trophy"></i></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Quizzes', 'udetor' ); ?></span><span class="udetor-value"><?php echo count($quizzes).' '.esc_html__('quizz', 'udetor');?></span>
                        </li>
                    <?php endif; ?>
                    <li>
                        <?php echo  wp_kses(__(' <i class="fa fa-certificate"></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Certificate', 'udetor' ); ?></span><span class="udetor-value"><?php if($learndash_certificate_details){echo 'Yes';}else{echo 'No';} ?></span>
                    </li>
                    <?php $level = get_post_meta($post->ID, 'course_skill_lever',false); 
                    if(!empty($level[0])){ ?>                           
                        <li>
                        <?php echo  wp_kses(__(' <i class="fa fa-asterisk"></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Level', 'udetor' ); ?></span><span class="udetor-value"><?php print($level[0]);?></span>
                        </li>

                    <?php
                    }            
                    ?>                                      
                    <li>                        
                        <?php echo  wp_kses(__(' <i class="fa fa-users"></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Students', 'udetor' ); ?></span><span class="udetor-value"><?php echo get_post_meta($post->ID, 'maximum_students', true); ?></span>
                    </li>
                    <li>
                        <?php echo  wp_kses(__(' <i class="fa fa-language"></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Language', 'udetor' ); ?></span><span class="udetor-value"><?php echo get_post_meta($post->ID, '_courses_lang',true); ?></span>
                    </li>
                    <li>
                        <?php echo  wp_kses(__(' <i class="fa fa-clock-o"></i> ', 'udetor'), array('i' => array('class' => array())));?>
                        <span class="udetor-label"><?php esc_html_e( 'Duration', 'udetor' ); ?></span><span class="udetor-value"><?php echo Udetor_Helper::udetor_duration_course($post->ID); ?></span>
                    </li>
                </ul>
                
            </div>
            
        </div>
    </div>
<?php endif; ?>

<div class="learndash_course_tabs <?php if($udetor_layout_tab_extra){ echo esc_html($udetor_layout_tab_extra);} ?> course-detail-item">
        <div class="row">
            <?php if($udetor_layout_tab_extra !='full-content'): ?>
                <div class="<?php echo esc_html($class_extra_title); ?> udetor-tab-menu">              
                    <?php 
                    if ( true == get_theme_mod( 'udetor_courses_detail_extra_show_des', true ) ) : 
                    ?>
                        <a href="#" class="active">
                            <?php 
                            echo  wp_kses(__(' <i class="fa fa-pencil"></i> ', 'udetor'), array('i' => array('class' => array())));
                            echo '<span class="ldc-tab-label">'.esc_html__('Description', 'udetor').'</span>'; 
                            ?>
                        </a>
                    <?php endif; ?>
                    
                    <?php if ( $has_course_content && true == get_theme_mod( 'udetor_courses_detail_extra_show_curriculum', true )) : ?>
                      <a href="#">
                        <?php 
                        echo  wp_kses(__(' <i class="fa fa-folder-open"></i> ', 'udetor'), array('i' => array('class' => array())));
                        echo '<span class="ldc-tab-label">'.esc_html__('Curricilum', 'udetor').'</span>'; ?>
                      </a>
                    <?php endif; ?>
                    
                    <?php  //if( function_exists('get_field') && get_field('advisor') ): ?>
                    <!-- <a href="#"> -->
                       <?php 
                       /*echo  wp_kses(__(' <i class="fa fa-suitcase"></i> ', 'udetor'), array('i' => array('class' => array())));
                       echo '<span class="ldc-tab-label">'.esc_html__('Advisor', 'udetor').'</span>';*/ ?>
                    <!-- </a> -->
                    <?php //endif; ?>

                    <?php if ( true == get_theme_mod( 'udetor_courses_detail_extra_show_reviews', true ) ) : ?>
                    <a href="#">
                      <?php 
                      echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                      echo '<span class="ldc-tab-label">'.esc_html__('Comment', 'udetor').'</span>'; ?>
                    </a>
                    <?php endif; ?>                
                  
                </div>
            <?php endif; ?>
            <div class="<?php if(isset($class_extra_content)){ echo esc_html($class_extra_content); }  ?>  udetor-tab">
                <?php if ( true == get_theme_mod( 'udetor_courses_detail_extra_show_des', true ) ) : ?>
                    <?php if($udetor_layout_tab_extra =='full-content'){ ?>
                    <p class="accordion">
                        <?php 
                        echo  wp_kses(__(' <i class="fa fa-pencil"></i> ', 'udetor'), array('i' => array('class' => array())));
                        echo '<span class="ldc-tab-label">'.esc_html__('Description', 'udetor').'</span>'; 
                        ?>
                    </p>
                    <?php } ?>
                    <div class="udetor-tab-content des-course">
                        <?php 
                        $videotype = get_post_meta($post->ID, 'promotion_video_type', true);
                        $width =500;
                        $videoid = get_post_meta($post->ID, 'promotion_video', true);
                        if($videoid){
                            echo '<div class="video-promotion" style="width: 100%;">';
                            if($videotype == 'vimeo'){
                                echo '<iframe src="//player.vimeo.com/video/' . $videoid . '?rel=0' . ( $autoplay ? '&autoplay=1' : '' ) . '" width="' . esc_attr( $width ) . '" height="' . intval( $width / 1.777 ) . '" frameborder="0"></iframe>';
                            }elseif($videotype == 'youtube'){
                                
                                echo '<iframe width="' . esc_attr( $width ) . '" height="' . intval( $width / 1.777 ) . '" src="https://www.youtube.com/embed/' . $videoid . '" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>';
                            }
                            
                            echo '</div>';
                        }
                        
                        $goals_prerequisites = get_post_meta($post->ID, 'goals_prerequisites', true);
                        $goals_target_student = get_post_meta($post->ID, 'goals_target_student', true);
                        $goals_will_learn = get_post_meta($post->ID, 'goals_will_learn', true);
                        if($goals_prerequisites !='' || $goals_target_student !='' || $goals_will_learn !=''){  
                            
                            echo '<div class="content-goals">';
                            echo '<p>'.$goals_prerequisites.'</p>';
                            echo '<p>'.$goals_target_student.'</p>';
                            echo '<p>'.$goals_will_learn.'</p>';
                            echo '</div>';
                        }
                        ?>
                        
                        <?php printf(esc_html__('%s', 'udetor'),  $content); ?>
                        <?php 
                        if ( true == get_theme_mod( 'udetor_courses_detail_show_social_share', true ) ) :
                            echo '<div class="single-course-social">';
                                if ( is_plugin_active( 'netbase-toolkit/app.php' ) ) {
                                echo do_shortcode( '[udetor_social_share]' );
                                }
                            echo '</div>';
                        endif;
                        ?>
                        
                    </div>
                <?php endif; ?>
                
                <?php if ( $has_course_content && true == get_theme_mod( 'udetor_courses_detail_extra_show_curriculum', true )) : ?>
                    <?php if($udetor_layout_tab_extra =='full-content'){ ?>
                    <p class="accordion">
                        <?php 
                        echo  wp_kses(__(' <i class="fa fa-folder-open"></i> ', 'udetor'), array('i' => array('class' => array())));
                        echo '<span class="ldc-tab-label">'.esc_html__('Curricilum', 'udetor').'</span>'; 
                        ?>
                    </p>
                    <?php } ?>
                <div class="udetor-tab-content">
                <?php 
                $show_course_content = true;
                if ( !$has_access ) :
                    if ( $course_meta['sfwd-courses_course_disable_content_table'] == 'on' ) :
                        $show_course_content = false;
                    endif;
                endif;                      
                if ( $show_course_content ) :
                ?>
                    <div id="learndash_course_content">
                        <h4 id="learndash_course_content_title"><?php printf( esc_html_x( '%s Content', 'Course Content Label', 'udetor' ), LearnDash_Custom_Label::get_label( 'course' ) ); ?></h4>
                        <?php
                        /**
                         * Display lesson list
                         */ 
                        ?>
                        <?php if ( ! empty( $lessons ) ) : ?>
                            <?php if ( $has_topics ) : ?>
                                <?php 
                                wp_localize_script( 'udetor-main-script', 'sfwd_courses', array(
                                    'course_id' => esc_attr($course_id)
                                ) );
                                wp_enqueue_script( 'udetor-main-script' );

                                ?>
                                <div class="expand_collapse">
                                    <a id="education_<?php echo esc_attr($course_id); ?>_expand" href="#"><?php echo esc_html__( 'Expand All / ', 'udetor' ); ?></a>
                                    <a id="education_<?php echo esc_attr($course_id); ?>_collapse" href="#"><?php echo esc_html__( 'Collapse All', 'udetor' ); ?></a>
                                </div>
                            <?php endif; ?>
                            <div id="learndash_lessons">
                                <div id="lesson_heading">
                                  <span><?php echo LearnDash_Custom_Label::get_label( 'lessons' ) ?></span>
                                  <span class="right"><?php echo esc_html__( 'Time', 'udetor' ); ?></span>
                                </div>
                                <div id="lessons_list">
                                    <?php foreach ( $lessons as $lesson ) : ?>
                                        <?php $topics = $lesson_topics[ $lesson['post']->ID ]; ?>
                                        <div class='post-<?php echo esc_attr( $lesson['post']->ID ); ?> <?php echo esc_attr( $lesson['sample'] ); ?>'>
                                            <div class="list-count">
                                                <?php if ( ! empty( $topics ) ) : ?>
                                                <span class="plus">+</span>
                                                <span class="minus">-</span>
                                                <?php endif; ?>
                                                
                                            </div>
                                            <div class="ulesson">
                                                <a class='<?php echo esc_attr( $lesson['status'] ); ?> font-h1' href='<?php echo esc_attr( $lesson['permalink'] ); ?>'><?php 
                                                printf(esc_html('%s. %s', 'udetor'), $lesson['sno'], $lesson['post']->post_title); ?></a>
                                                <?php
                                                /**
                                                 * Not available message for drip feeding lessons
                                                 */
                                                ?>
                                                <?php if ( ! empty( $lesson['lesson_access_from'] ) && function_exists(learndash_adjust_date_time_display) ) : ?>
                                                    <small class="notavailable_message">
                                                        <?php echo sprintf( esc_html__( 'Available on: %s ', 'udetor' ), learndash_adjust_date_time_display( $lesson['lesson_access_from'] ) ); ?>
                                                    </small>
                                                <?php endif; ?>
                                                <?php
                                                /**
                                                 * Lesson Topics
                                                 */
                                                ?>
                                                
                                                <?php if ( ! empty( $topics ) ) : ?>
                                                    <div id='learndash_topic_dots-<?php echo esc_attr( $lesson['post']->ID ); ?>' class="learndash_topic_dots type-list">
                                                        <ul>
                                                            <?php $odd_class = ''; $j = 0  ?>
                                                            <?php foreach ( $topics as $key => $topic ) : $j++; ?>
                                                                <?php $odd_class = empty( $odd_class ) ? 'nth-of-type-odd' : ''; ?>
                                                                <?php $completed_class = empty( $topic->completed ) ? 'topic-notcompleted':'topic-completed'; ?>                                                
                                                                <li class='<?php echo esc_attr( $odd_class ); ?>'>
                                                                    <div class="topic_title"><span><i class="fa fa-file-text-o"></i><?php echo sprintf( esc_html__( 'Lecture %1$d. %2$d:', 'udetor' ), $lesson['sno'],
                                                                $j) ?></span>
                                                                    </div>
                                                                    <div class="topic_item">
                                                                        <a class='<?php echo esc_attr( $completed_class ); ?>' href='<?php echo esc_attr( get_permalink( $topic->ID ) ); ?>' title='<?php echo esc_attr( $topic->post_title ); ?>'>
                                                                            <span><?php printf(esc_html('%s', 'udetor'), $topic->post_title); ?></span>
                                                                            

                                                                        </a>
                                                                    </div>
                                                                    <?php $meta = get_post_meta( $topic->ID, '_' . $topic->post_type ); 
                                                                          
                                                                            if ( $meta[0][ $topic->post_type . '_forced_lesson_time' ] ) : 
                                                                                $time = $meta[0][ $topic->post_type . '_forced_lesson_time' ];
                                                                            echo '<div class="topic_time">';
                                                                                echo gmdate( 'H : i : s', Udetor_Helper::udetor_time_second( $time ) );
                                                                            echo '</div>';                                                                        
                                                                            endif;
                                                                            ?>
                                                                </li>
                                                            <?php endforeach; ?>
                                                        </ul>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        <?php endif; ?>
                        <?php
                        /**
                         * Display quiz list
                         */
                        ?>
                        <?php if ( ! empty( $quizzes ) ) : ?>
                            <div id="learndash_quizzes">
                                <div id="quiz_heading">
                                    <span><?php echo LearnDash_Custom_Label::get_label( 'quizzes' ) ?></span><span class="right"><?php esc_html_e( 'Status', 'udetor' ); ?></span>
                                </div>
                                <div id="quiz_list">
                                    <?php foreach( $quizzes as $quiz ) : ?>
                                        <div id='post-<?php echo esc_attr( $quiz['post']->ID ); ?>' class='<?php echo esc_attr( $quiz['sample'] ); ?>'>
                                            <div class="list-count"><?php printf(esc_html__('%s', 'udetor'), $quiz['sno']); ?></div>
                                            <h4>
                                                <a class='<?php echo esc_attr( $quiz['status'] ); ?>' href='<?php echo esc_attr( $quiz['permalink'] ); ?>'><?php printf(esc_html__('%s', 'udetor'),  $quiz['post']->post_title); ?></a>
                                            </h4>
                                        </div>                      
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                    
                </div>
              <?php endif; ?>
    
                <?php  //if( function_exists('get_field') && get_field('advisor') ): ?>
                    <?php //if($udetor_layout_tab_extra =='full-content'){ ?>
                    <!-- <p class="accordion"> -->
                        <?php 
                        /*echo  wp_kses(__(' <i class="fa fa-suitcase"></i> ', 'udetor'), array('i' => array('class' => array())));
                        echo esc_html__('Advisor', 'udetor');*/
                        ?>
                    <!-- </p> -->
                    <?php //} ?>
                <!-- <div class="udetor-tab-content"> -->
                      <?php //the_field('advisor'); ?>
                    
                <!-- </div> -->
                <?php //endif; ?>

                <?php 
                if (  true == get_theme_mod( 'udetor_courses_detail_extra_show_reviews', true ) ) : ?>
                    <?php if($udetor_layout_tab_extra =='full-content'){ ?>
                    <p class="accordion">
                        <?php 
                        echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                        echo esc_html__('Comment', 'udetor');
                        ?>
                    </p>
                    <?php } ?>
                    <div class="udetor-tab-content review-course"> 
                        <?php   
                        if ( is_plugin_active( 'netbase-toolkit/app.php' ) ) {
                           echo do_shortcode('[udetor_comment_star_rating_bar]' );
                        }
                        comments_template();  
                        
                        ?>
                        
                    </div>
                <?php endif; ?>
                
            </div>
        </div>
  </div>
<?php if($learndash_certificate_details): ?>
    <div class="course-certificate course-detail-item">
        <h2 class="udetor-detail-title"><?php echo esc_html__('CERTIFICATES', 'udetor'); ?></h2>
        <?php print( $learndash_certificate_details ); ?>
    </div>
<?php endif; ?>

<?php if ( isset( $materials ) && $materials !='' ) : ?>
    <div id="learndash_course_materials" class="course-detail-item">
        <h2 class="udetor-detail-title"><?php echo esc_html__('Course Materials', 'udetor'); ?></h2>        
        <p><?php printf(esc_html('%s', 'udetor'), $materials); ?></p>
    </div>
<?php endif; ?>
