<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */

get_header(); 
?>
	<div id="content" class="container site-content <?php if(Udetor_Helper::udetor_get_layout_class()!=''){ echo esc_html(Udetor_Helper::udetor_get_layout_class()); }else {echo 'right-sidebar'; } ?>">
	<div id="primary" class="content-area" data-section="udetor_layout">
        <?php
        if ( is_customize_preview() ) {
            echo '<div class="udetor_highlight_mask"><a class="udetor_customize_section btn btn-primary" href="#" data-section="udetor_layout">Customizer Content</a></div>';
        }
        ?>
		<main id="main" class="site-main" role="main">

		<?php
		if ( have_posts() ) :

			if ( is_home() && ! is_front_page() ) : ?>
				<header>
					<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
				</header>

			<?php
			endif;		

			/* Start the Loop */
			while ( have_posts() ) : the_post();

				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */				
				?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<header>
						<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(esc_html__('Permanent Link to %s', 'udetor'), the_title_attribute('echo=0')); ?>"><?php the_title(); ?></a></h2>
					</header>
					<?php if ( 'post' == get_post_type() ) : ?>
	                    <div class="entry-meta udetor-posted-on-meta">
	                        <?php Udetor_Template_Tags::udetor_posted_on_meta(); ?>
	                	</div>
	                <?php endif; ?>
					<section class="post-entry">
							<?php if ( has_post_thumbnail()) : ?>
								<div class="nbt-entry-thumb">
									<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
									<?php the_post_thumbnail(); ?>
									</a>
								</div>
							<?php endif; ?>
							<?php the_content(); ?>
							<?php 
	                        wp_link_pages(array(
	                            'link_before'      => '<span>',
	                            'link_after'       => '</span>',
	                            'pagelink'         => '%',                            
	                            'before' => '<div class="blog-pagination">',
	                            'after' => '</div>',
	                            'nextpagelink' => esc_html__('&rarr;', 'udetor'),
	                            'previouspagelink' => esc_html__('&larr;', 'udetor'),
	                            )
	                        ); ?>
					</section> 
				</article>

				<?php

			endwhile;

			Udetor_Helper::udetor_paging_nav();

		else :
			get_template_part( 'template-parts/content', 'none' );

		endif; ?>		

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_sidebar();

get_footer();
