<?php
class Udetor_Ajax_Search_Widget extends WP_Widget {

	/**
	 * Register the Widget with WordPrss
	 */
	function __construct() {
		parent::__construct(
			'udetor_ajaxsearch_widget',
			__( 'Udetor - Ajax Search', 'udetor' ),
			array( 'description' => __( 'Udetor - Ajax Search', 'udetor' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 */
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );

		$placeholder    = empty( $instance['placeholder'] ) ? __( 'Search for...', 'udetor' ) : esc_attr( $instance['placeholder'] );

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		?>
		<div class="udetor-search-awap">
			<form role="search" method="get" class="search-form" action="<?php echo  esc_url( home_url( '/' ) ); ?>">
                <label>
                    <input type="search" class="search-field" placeholder="<?php echo $placeholder; ?>" value="<?php echo get_search_query() ?>" name="s" 
                    title="<?php echo $placeholder; ?>" />
                </label>
                <input type="submit" class="search-submit" value="<?php echo  esc_attr_x( 'Search', 'submit button' ); ?>" />
            </form>
        </div>			
		<?php
		echo $args['after_widget'];
	}

	/**
	 * Back-end widget form.
	 *
	 */
	public function form( $instance ) {
		$widget_title       = isset( $instance['title'] ) ? $instance['title'] : '';
		$widget_placeholder = isset( $instance['placeholder'] ) ? $instance['placeholder'] : __( 'Search for...', 'udetor' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $widget_title ); ?>">
		</p>	
		<p>
			<label for="<?php echo $this->get_field_id( 'placeholder' ); ?>"><?php _e( 'Placholder:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'placeholder' ); ?>" name="<?php echo $this->get_field_name( 'placeholder' ); ?>" type="placeholder" value="<?php echo esc_attr( $widget_placeholder ); ?>">
		</p>
		
	<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title']          = ( ! empty( $new_instance['title'] ) )         ? strip_tags( $new_instance['title'] ) : '';		
		$instance['placeholder']    = ( ! empty( $new_instance['placeholder'] ) )   ? strip_tags( $new_instance['placeholder'] ) : '';		

		return $instance;
	}

}

function udetor_ajax_search_register_widget() {
	register_widget( 'Udetor_Ajax_Search_Widget' );
}
add_action( 'widgets_init', 'udetor_ajax_search_register_widget' );
