(function ($) {
    "use strict";
    
    $.extend(String, {
        format: function () {
            if (arguments.length == 0) return null;
            var args;
            if (arguments.length == 1) args = arguments[0];
            else args = arguments;

            var result = args[0];
            for (var i = 1; i < args.length; i++) {
                var re = new RegExp("\\{" + (i - 1) + "\\}", "gm");
                result = result.replace(re, args[i]);
            }
            return result;
        },       

    });

    window.$ = $;

    $.extend(window, {
        cawp: {
            init: function () {
                this.version = "1.3";
                this.browser = {};                

            },
            
        }
    });

    cawp.init();
    
    $.extend(cawp, {

        page: {

            init: function () {
                var self = this;                

                $(document).ready(function () {
                    "use strict";
                    self.load();
                });             

            },
           
            load: function () {
                this.initSearch();

            },
            
            initSearch: function () {

                var $el = $(".udetor-search-awap");
                var self = this;
                var isActive = false;

                if (typeof this.ajaxSearch == "function") this.ajaxSearch({ element: $el });

                function showSearch() {
                    $el.parent().css("width", $el.parent().width());
                    
                    $el.addClass("active");
                    $("input", $el).animate({ width: $el.width() }, 200, function () {
                        $("input", $el).focus();
                        if ($(".dropdown-menu li", $el).length > 0) $(".autocomplete", $el).addClass("open").show();
                    });
                }

                function hideSearch() {
                    $(".autocomplete", $el).removeClass("open").hide();
                    
                }

                $(".search-button", $el).off("click").on("click", function () {
                    showSearch();
                    
                    return false;
                });

                $("input", $el).keypress(function (event) {
                    if (event.which == 13) {
                        event.preventDefault();
                        $("form", $el).submit();
                    }
                });

                $(document.body).on("click", function (event) {
                    var o = $(event.target);
                    setTimeout(function () {
                        if (!(o.is($el) || o.parents("#" + $el.attr("id")).length)) {
                             $(".autocomplete", $el).removeClass("open").hide();
                        }
                    }, 200);

                });
            },
                        
            scrollTo: function (target, options) {

                if (typeof options == "function") options = { onAfter: options };
                var settings = $.extend({}, { duration: 1000, easing: 'easeInOutExpo' }, options);
                $(window).scrollTo(target, settings);
            }

        }

    });

    cawp.page.init();  

    function loadResults(ajaxURL, el) {
        var getUrl = window.location;
        var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];

        var autocomplete = $(".autocomplete", el);


        if (!autocomplete.length) {
            createAutoComplete(el);
        }

        var data = { action: "ajax_search", search_keyword: $("input", el).val() };

        if (data.search_keyword.length == 0) {
            autocomplete.hide().removeClass("open");
            $(".dropdown-menu, .search-more", autocomplete).html("");
            return;
        }

        autocomplete.show().addClass("open");
        $(".search-more", autocomplete).removeClass("selected").html("<p class=\"search-loading\"><span class=\"post-loader\"></span></p>");

        $.post(ajaxURL, data, function (response) {

            $(".dropdown-menu", autocomplete).html("");

            var results = $.parseJSON(response);

            if (results && results.length > 0) {
                results.sort(function (a, b) {
                    var x = a['title'];
                    var y = b['title'];
                    return ((x < y) ? -1 : ((x > y) ? 1 : 0));
                });
                $.each(results, function () {
                    var list = $(String.format("<li><h5>{0}</h5></li>", this.title));
                    list.append(getListItems(this.name, this.items));
                    $(".dropdown-menu", autocomplete).append(list);
                });

            }
            if (results.length == 0) $(".search-more", autocomplete).addClass("selected");
            $(".search-more", autocomplete).html(String.format("<a href=\"{0}?s={1}\">See more results for \"{1}\"</a>", baseUrl, $("input", el).val()));

            if (typeof cawp.page.updateLink == "function") cawp.page.updateLink($("li", autocomplete.not(".product-list")));

            if ($(el).hasClass("active")) {
                autocomplete.show().addClass("open");
                $(".dropdown-menu", autocomplete).focus();
            }
            var h = $(window).height() - $(".search-more", autocomplete).outerHeight() - $(".dropdown-menu", autocomplete).offset().top;
            $(".dropdown-menu", autocomplete).css("max-height", h);
        });
    }

    function createAutoComplete(el) {
        $("<div class=\"autocomplete\"><ul class=\"dropdown-menu\"></ul><div class=\"search-more\"></div></div>").appendTo(el);
    }

    function getListItems(name, items) {
        var list = $("<ul></ul>").attr("class", String.format("{0}-list", name.toLowerCase()));
        $.each(items, function () {
            var image = "";
            if (this.post_image) image = String.format("<span class=\"thumb\"><img src=\"{1}\" alt=\"{2}\"></span>", this.post_link, this.post_image, this.post_title);

            var postdate ="";
            if (this.post_date) postdate = String.format("<span class=\"ca-datetime\">{0}</span>", this.post_date);
                
            var author = "";
            if (this.post_author) author = String.format("<span class=\"ca-meta\">{0}</span>", this.post_author);
            if(image !=""){
                list.append($(String.format("<li><a href=\"{1}\">{0}<div class=\"ca-wa-item\"><strong>{2}</strong><span class=\"ca-des\">{4}</span><div class=\"post-meta\">{3}{5}</div></div></a></li>", image, this.post_link, this.post_title, author, this.post_excerpt, postdate)));     
            }else{
                list.append($(String.format("<li><a href=\"{1}\">{0}<div><strong>{2}</strong><span class=\"ca-des\">{4}</span><div class=\"post-meta\">{3}{5}</div></div></a></li>", image, this.post_link, this.post_title, author, this.post_excerpt, postdate)));
            }
            
        });
        return list;
    }

    $.extend(cawp.page, {

        ajaxSearch: function (options) {

            var settings = {
                delay: 500,
                element: ".udetor-search-awap"
            };

            if (typeof ajax_search_settings != "undefined") $.extend(settings, ajax_search_settings);

            settings = $.extend(true, settings, options);

            if (!settings.ajaxURL) return;

            return $(".udetor-search-awap").each(function () {

                var ajaxTimer = null;
                var el = this;

                createAutoComplete(el);
                $("input", el).attr("autocomplete", "off");
                $("input", el).keyup(function (event) {
                    if (event.keyCode != "38" && event.keyCode != "40" && event.keyCode != "13" && event.keyCode != "27" && event.keyCode != "39" && event.keyCode != "37") {

                        if (ajaxTimer != null) {
                            clearTimeout(ajaxTimer);
                        }
                        ajaxTimer = setTimeout(function () { loadResults(settings.ajaxURL, el); }, settings.delay);
                    }
                });
                $('input',el).on("click", function (event) {
                    
                    if($("input", el).val() !=''){
                        if (ajaxTimer != null) {
                            clearTimeout(ajaxTimer);
                        }
                        ajaxTimer = setTimeout(function () { loadResults(settings.ajaxURL, el); }, settings.delay);

                    }
                    
                });
            });
        }
    });
})(jQuery);