<?php
// exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Widget support

include_once( dirname( __FILE__ ) . '/includes/class-widget.php' );

/*if( get_theme_mod( 'udetor_ajaxsearch_tempsform', 'no' ) =='yes'){
	add_filter( 'get_search_form' , 'ca_ajaxsearch_custom_searchform' );

	
	function ca_ajaxsearch_custom_searchform( $form ) {
		$form = '<div class="udetor-search-awap"><form role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '">
                <label>
                    <span class="screen-reader-text">' . _x( 'Search for:', 'label' ) . '</span>
                    <input type="search" class="search-field" placeholder="' . esc_attr_x( 'Search &hellip;', 'placeholder' ) . '" value="' . get_search_query() . '" name="s" />
                </label>
                <input type="submit" class="search-submit" value="'. esc_attr_x( 'Search', 'submit button' ) .'" />
            </form></div>';
		
		return $form;
		
	}	
}*/


function ca_ajaxsearch_enqueue_scripts(){
	/* Ajax Search */
	wp_register_script('ajax-search', trailingslashit(get_parent_theme_file_uri()) . 'inc/modules/ajax-search/assets/js/ajax-search.js', null, '1.5.5', true);
    wp_enqueue_script('ajax-search');
    wp_localize_script( 'ajax-search', 'ajax_search_settings', array('ajaxURL'=> admin_url( 'admin-ajax.php' )));
	wp_register_style( 'search-css', trailingslashit(get_parent_theme_file_uri()) . 'inc/modules/ajax-search/assets/css/search_style.css' );
    wp_enqueue_style( 'search-css' );
}
add_action('wp_enqueue_scripts', 'ca_ajaxsearch_enqueue_scripts');

if ( ! class_exists( 'Udetor_Ajax_Search' ) ) {

class Udetor_Ajax_Search{
    
    public function __construct(){
        add_action('wp_ajax_ajax_search', array($this, 'get_search_results'));
        add_action('wp_ajax_nopriv_ajax_search', array($this, 'get_search_results'));
    }

    public function get_search_results()
	{            
        ob_clean();
		$results = array();
		
		$keyword = apply_filters('ajax_search_keyword', $_POST['search_keyword']);

		if(!empty($keyword))
		{
			$search = $this->get_search_objects(false);
			foreach($search as $key => $object)
			{
				$posts_result = $this->posts($keyword, $object['name']);
				if(sizeof($posts_result) > 0) {
					$results[] = array(
                        'items' => $posts_result, 
                        'title' => $object['label'],
                        'name'  => $object['name']
                        );
				}
			}
			echo json_encode($results);
		}
        exit;
	}
    public function get_search_objects($all = false)
	{
        $search_post_type = get_theme_mod( 'udetor_ajaxsearch_posttype', array( 'sfwd-courses', 'post' ) );
		$search = array();
		if ( ! empty( $search_post_type ) ) :
			 foreach ( $search_post_type as $checked_value ) :
			 	$obj = get_post_type_object( $checked_value );
			 	$search[] = array(
						'name' => $checked_value, 
						'label' => 	$obj->labels->name,
					);

			 endforeach;
		endif;
		/*$post_types = $this->get_post_types();

		foreach($post_types as $post_type)
		{		
				$show =( ! empty( $search_post_type ) );
				if($all || $show){
					$search[] = array(
						'name' => $post_type->name, 
						'label' => 	$post_type->label
					);
				}
				
		}*/
		return $search;
	}
    public function get_post_types()
	{
		$post_types = get_post_types(array('_builtin' => false, 'exclude_from_search' => false), 'objects');
		$post_types['post'] = get_post_type_object('post');
		$post_types['page'] = get_post_type_object('page');
		unset($post_types['wpsc-product-file']);
		return $post_types;
	}

    public function posts($keyword, $post_type='post')
	{
		global $wpdb;
				
		$limit = get_theme_mod( 'udetor_ajaxsearch_suggestionitem', '5' );
		
        $posts = array();
        $search_order = 'post_title';
        $vcontent = get_theme_mod( 'udetor_ajaxsearch_searchcontent', true );
        $search_content = ( $vcontent ) ? true : false;
              		
		$order_results = (  $search_order != '' ? " ORDER BY ".$search_order : "");		
        
        $results = array();
		$query = "
			SELECT 
				$wpdb->posts.ID 
			FROM 
				$wpdb->posts
			WHERE 
				(post_title LIKE '%%%s%%' ".($search_content ? "or post_content LIKE '%%%s%%')":")")." 
				AND post_status='publish' 
				AND post_type='".$post_type."' 
				$order_results 
			LIMIT 0, %d";

		$query = ($search_content ? $wpdb->prepare($query, $keyword, $keyword, $limit) : $wpdb->prepare($query, $keyword, $limit));

		$results = $wpdb->get_results( $query );

		if(sizeof($results) > 0 && is_array($results) && !is_wp_error($results))
		{
			foreach($results as $result)
			{
				$pst = $this->post_object($result->ID);
				if($pst){
					$posts[] = $pst; 
				}
			}
		}
		return $posts;
	}

    public function post_object($id) {
		global $post;
		/*$excerpt_numb = get_theme_mod( 'udetor_ajaxsearch_numbexcerpt', '35' );*/
		/*$date_format = get_option( 'date_format' );	*/
		
        $post = get_post($id);		
        if($post != null){
        	
			$post_object = new stdclass();
			$post_object->ID = $post->ID;
            $post_object->post_title = get_the_title($post->ID);

            /*if (get_theme_mod( 'udetor_ajaxsearch_showexcerpts', 'yes' ) =='yes' && has_excerpt() ){								
				$post_object->post_excerpt = wp_trim_words( get_the_excerpt(), $excerpt_numb, '...' ); 
									
			}else{*/
				$post_object->post_excerpt = "";	
			/*}*/            
            
			$post_thumbnail_id = get_post_thumbnail_id( $post->ID);
			if( get_theme_mod( 'udetor_ajaxsearch_showimg', 'yes' ) =='yes'){
				if( $post_thumbnail_id > 0)
				{
					$thumb = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail');
					$post_object->post_image =  esc_url( (trim($thumb[0]) == "" ? "" : $thumb[0]) );
				}
			}
			$post_object->post_link = esc_url( get_permalink($post->ID) );
			if( get_theme_mod( 'udetor_ajaxsearch_showmeta', 'yes' ) =='yes'){
				$post_object->post_author = get_the_author_meta('display_name', $post->post_author);				
				$post_object->post_date =  get_the_date();
			}
			return $post_object;
		}
		return false;
	}

}

$ajax_s = new Udetor_Ajax_Search();
}