<?php
if ( ! class_exists( 'Merlin' ) ) {
	return;
}

/**
 * Set directory locations, text strings, and other settings for Merlin WP.
 */
$wizard = new Merlin(
	// Configure Merlin with custom settings.
	$config = array(
		'directory'                => '', // Location where the 'merlin' directory is placed.
		'merlin_url'               => 'merlin', // Customize the page URL where Merlin WP loads.
		'child_action_btn_url'     => 'https://codex.wordpress.org/Child_Themes',  // The URL for the 'child-action-link'.
		'help_mode'                => false, // Set to true to turn on the little wizard helper.
		'dev_mode'                 => true, // Set to true if you're testing or developing.
		'branding'                 => true, // Set to false to remove Merlin WP's branding.
	),
	// Text strings.
	$strings = array(
		'admin-menu'               => esc_html__( 'Theme Setup' , 'udetor' ),
		'title%s%s%s%s' 		       => esc_html__( '%s%s Themes &lsaquo; Theme Setup: %s%s' , 'udetor' ),

		'return-to-dashboard'      => esc_html__( 'Return to the dashboard' , 'udetor' ),

		'btn-skip'                 => esc_html__( 'Skip' , 'udetor' ),
		'btn-next'                 => esc_html__( 'Next' , 'udetor' ),
		'btn-start'                => esc_html__( 'Start' , 'udetor' ),
		'btn-no'                   => esc_html__( 'Cancel' , 'udetor' ),
		'btn-plugins-install'      => esc_html__( 'Install' , 'udetor' ),
		'btn-child-install'        => esc_html__( 'Install' , 'udetor' ),
		'btn-content-install'      => esc_html__( 'Install' , 'udetor' ),
		'btn-import'               => esc_html__( 'Import' , 'udetor' ),

		'welcome-header%s'         => esc_html__( 'Welcome to %s' , 'udetor' ),
		'welcome-header-success%s' => esc_html__( 'Hi. Welcome back' , 'udetor' ),
		'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.' , 'udetor' ),
		'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.' , 'udetor' ),

		'child-header'             => esc_html__( 'Install Child Theme' , 'udetor' ),
		'child-header-success'     => esc_html__( 'You\'re good to go!' , 'udetor' ),
		'child'                    => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.' , 'udetor' ),
		'child-success%s'          => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.' , 'udetor' ),
		'child-action-link'        => esc_html__( 'Learn about child themes' , 'udetor' ),
		'child-json-success%s'     => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.' , 'udetor' ),
		'child-json-already%s'     => esc_html__( 'Awesome. Your child theme has been created and is now activated.' , 'udetor' ),

		'plugins-header'           => esc_html__( 'Install %d plugins' , 'udetor' ),
		'plugins-header-success'   => esc_html__( 'You\'re up to speed!' , 'udetor' ),
		'plugins'                  => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.' , 'udetor' ),
		'plugins-success%s'        => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.' , 'udetor' ),
		'plugins-action-link'      => esc_html__( 'Advanced' , 'udetor' ),

		'import-header-1'            => esc_html__( 'Choose your own theme' , 'udetor' ),
		'import-1'                   => esc_html__( 'See %d+ home layouts' , 'udetor' ),
		'import-header-2'            => esc_html__( 'Choose Your Theme' , 'udetor' ),
		'import-2'                   => esc_html__( 'There are many unique and sophisticated theme are available on Udetor that you can choose the one is suitable for your use' , 'udetor' ),
		'import-header-3'            => esc_html__( 'Import data' , 'udetor' ),
		'import-3'                   => esc_html__( 'You will get the demo data of the theme which you chose and you can customize it if you want' , 'udetor' ),
		'import-header-4'            => esc_html__( 'Importing...' , 'udetor' ),
		'import-4'                   => esc_html__( 'Please be patient. It will be ended soon.
			Do not quit or shut down your browser' , 'udetor' ),
		'process-4'                => esc_html__( 'Importing Udetor data' , 'udetor' ),

		'import-header'            => esc_html__( 'Import Content' , 'udetor' ),
		'import'                   => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.' , 'udetor' ),
		'import-action-link'       => esc_html__( 'Advanced' , 'udetor' ),

		'ready-header'             => esc_html__( 'Import Successfully!!!' , 'udetor' ),
		'ready%s'                  => esc_html__( 'Your site has been set up successfully. Enjoy your new site by %s' , 'udetor' ),
		'ready-action-link'        => esc_html__( 'Extras' , 'udetor' ),
		'ready-big-button'         => esc_html__( 'View your site' , 'udetor' ),

		'ready-link-1'             => wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__( 'Explore WordPress', 'udetor' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'ready-link-2'             => wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'http://cmsmart.net', esc_html__( 'Get Theme Support', 'udetor' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'ready-link-3'             => wp_kses( sprintf( '<a href="'.admin_url( 'customize.php' ).'" target="_blank">%s</a>', esc_html__( 'Start Customizing', 'udetor' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
	),
$plugins = array(
	array(
        'name'              => 'Buddypress',
        'slug'              => 'buddypress', 
        'required'          => true,
        'version'  => '',                
    ),
	array(
        'name'              => 'Advanced Custom Fields',
        'slug'              => 'advanced-custom-fields', 
        'required'          => true,
        'version'          => '',
    ),
	array(
        'name'              => esc_html__('Event Espresso Decaf', 'udetor'),
        'slug'              => 'event-espresso-decaf', 
        'required'          => true,
        'version'          => '',
    ),
	array(
        'name'              => esc_html__('WP Postviews', 'udetor'),
        'slug'              => 'wp-postviews', 
        'required'          => false,
        'version'          => '',         
    ),
	array(
		'name' => 'Contact Form 7',
		'slug' => 'contact-form-7',
		'required' => false,
		'version' => '',
	),

	array(
		'name' => 'Woocommerce',
		'slug' => 'woocommerce',
		'thumb' => get_template_directory_uri() . '/assets/images/plugins/woocommerce.png',
		'required' => true,
		'version' => '',
	),

	array(
        'name'              => esc_html__('YITH WooCommerce Wishlist', 'udetor'),
        'slug'              => 'yith-woocommerce-wishlist',
        'required'          => false,
        'version' => '',
    ),
		
	array(
		'name' => 'MailChimp for WordPress',
		'slug' => 'mailchimp-for-wp',
		'required' => false,
		'version' => '',
	),

	array(
		'name' => 'Slider Revolution',
		'slug' => 'revslider',
		'required' => true,
		'version' => '',
		'source' => get_parent_theme_file_path() . '/inc/plugins/revslider.zip',
	),
	
	array(
		'name' => 'Visual Composer',
		'slug' => 'js_composer',
		'required' => true,
		'version' => '',
		'source' => get_parent_theme_file_path() . '/inc/plugins/js_composer.zip',
	),

	array(
        'name'                  => 'Sfwd LMS',
        'slug'                  => 'sfwd-lms', 
        'source'                => get_parent_theme_file_path() . '/inc/plugins/sfwd-lms.zip', 
        'required'              => true, 
        'version'               => '', 
    ),

    array(
        'name'                  => 'Timetable',
        'slug'                  => 'timetable', 
        'source'                => get_parent_theme_file_path() . '/inc/plugins/timetable.zip', 
        'required'              => true, 
        'version'               => '', 
    ),
	
	/*array(
		'name' => 'Netbase Toolkit',
		'slug' => 'netbase-toolkit',
		'required' => true,
		'version' => '',
		'source' => get_parent_theme_file_path() . '/inc/plugins/netbase-toolkit.zip',
	),*/
	array(
        'name'                  => esc_html__('Netbase Simplemodal Login', 'udetor'), 
        'slug'                  => 'netbase-simplemodal-login', 
        'source'                => get_parent_theme_file_path() . '/inc/plugins/netbase-simplemodal-login.zip', 
        'required'              => true,                 
        'version' => '',           
    ),
	array(
                'name'                  => esc_html__('Learndash Propanel', 'udetor'), 
                'slug'                  => 'learndash-propanel', 
                'source'                => get_parent_theme_file_path() . '/inc/plugins/learndash-propanel.zip', 
                'required'              => false,                 
                  'version' => '',              
            ),
	array(
        'name'                  => esc_html__('Sfwd lms Fcc Learndash', 'udetor'), 
        'slug'                  => 'fcc-learndash', 
        'source'                => get_parent_theme_file_path() . '/inc/plugins/fcc-learndash.zip', 
        'required'              => false,             
        'version' => '', 
    ),
	
)
);

function udetor_local_import_files() {
	return array(
		array(
			'import_file_name'             => 'Standard',
			/*'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-business/wp-content/themes/printcart-child.zip',*/

			'local_import_file_data'            => get_parent_theme_file_path( 'inc/import-files/home1/demo-content.xml' ),
			/*'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/maxmegamenu/settings.txt',
			),*/
			/*'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/solutions_core_settings.txt',*/
			'local_import_widget_file'     => get_parent_theme_file_path( 'inc/import-files/home1/widgets.wie' ),
			'local_import_customizer_file' => get_parent_theme_file_path( 'inc/import-files/home1/udetor-customizer.dat' ),
			'local_import_rev_slider_file' => get_parent_theme_file_path( 'inc/import-files/sliders/edue-home1.zip' ), 
			'local_import_rev_slider_file2' => get_parent_theme_file_path( 'inc/import-files/sliders/edusite-slider-2.zip' ), 
			'local_import_rev_slider_file3' => get_parent_theme_file_path( 'inc/import-files/sliders/slider3.zip' ), 
			
			'import_preview_image_url'     => 'http://demo9.cmsmart.net/edusite_1/wp-content/uploads/2018/05/screenshot-home1.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'udetor' ),
			
			'preview_url'                  => 'http://demo9.cmsmart.net/edusite_1',
			'title_home_page'                  => 'Home Standard',
			/*'menu_settings'                  => array(
				'primary' => 'Main Menu'
			),*/
			'term_meta_key'                     => '',
			/*'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/widget/widget_nav_menu.txt',
			),*/
			/*'product_variation' => array(
				'price_matrix' => 'agency-books',
				'color_swatches' => 'pro-card-visit-a1'
			),
			'nbdesigner' => 'yes',*/
		),
		array(
			'import_file_name'             => 'One Intructor',
			/*'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-parallax/wp-content/themes/printcart-child.zip',*/

			'local_import_file_data'            => get_parent_theme_file_path( 'inc/import-files/home5/demo-content.xml' ),
			/*'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/solutions_core_settings.txt',*/
			'local_import_widget_file'     => get_parent_theme_file_path( 'inc/import-files/home5/widgets.wie' ),
			'local_import_customizer_file' => get_parent_theme_file_path( 'inc/import-files/home5/udetor-customizer.dat' ),
			'local_import_rev_slider_file' => get_parent_theme_file_path( 'inc/import-files/sliders/Slider2-v1.1.0.zip' ), 

			'import_preview_image_url'     => 'http://demo9.cmsmart.net/edusite_1/wp-content/uploads/2018/05/screenshot-home5.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'udetor' ),
			'preview_url'                  => 'http://demo9.cmsmart.net/edusite_5',
			'title_home_page'                  => 'Home One Intructor',
			/*'menu_settings'                  => array(
				'primary' => 'Main menu'
			),
			'term_meta_key'                     => '',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/widget/widget_nav_menu.txt',
				'no_title' => true,
			),
			'product_variation' => array(
				'price_matrix' => 'marketing-postcards-2018a-lorem-ipsum-2',
				'color_swatches' => 'marketing-postcards-2018a-relinquet-2'
			),
			'nbdesigner' => 'yes',*/
		),
		array(
			'import_file_name'             => 'One Course',			
			'local_import_file_data'            => get_parent_theme_file_path( 'inc/import-files/home4/demo-content.xml' ),
			'local_import_widget_file'     => get_parent_theme_file_path( 'inc/import-files/home4/widgets.wie' ),
			'local_import_customizer_file' => get_parent_theme_file_path( 'inc/import-files/home4/udetor-customizer.dat' ),
			'local_import_rev_slider_file' => get_parent_theme_file_path( 'inc/import-files/sliders/Slider1-v1.1.0.zip' ), 			
			'import_preview_image_url'     => 'http://demo9.cmsmart.net/edusite_1/wp-content/uploads/2018/05/screenshot-home4.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'udetor' ),
			'preview_url'                  => 'http://demo9.cmsmart.net/edusite_4',
			'title_home_page'                  => 'Home One Course',			
		),

		array(
			'import_file_name'             => 'Language Center',			
			'local_import_file_data'            => get_parent_theme_file_path( 'inc/import-files/home6/demo-content.xml' ),
			'local_import_widget_file'     => get_parent_theme_file_path( 'inc/import-files/home6/widgets.wie' ),
			'local_import_customizer_file' => get_parent_theme_file_path( 'inc/import-files/home6/udetor-customizer.dat' ),
			'local_import_rev_slider_file' => get_parent_theme_file_path( 'inc/import-files/sliders/Slider-v1.2.0.zip' ), 			
			'import_preview_image_url'     => 'http://demo9.cmsmart.net/edusite_1/wp-content/uploads/2018/05/screenshot-home6.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'udetor' ),
			'preview_url'                  => 'http://demo9.cmsmart.net/edusite_6',
			'title_home_page'                  => 'Home 6',			
		),

		array(
			'import_file_name'             => 'kindergarten',			
			'local_import_file_data'            => get_parent_theme_file_path( 'inc/import-files/kindergarten/demo-content.xml' ),
			'local_import_widget_file'     => get_parent_theme_file_path( 'inc/import-files/kindergarten/widgets.wie' ),
			'local_import_customizer_file' => get_parent_theme_file_path( 'inc/import-files/kindergarten/udetor-kinder.dat' ),
			'local_import_rev_slider_file' => get_parent_theme_file_path( 'inc/import-files/sliders/Slider-Kindergarten.zip' ), 			
			'import_preview_image_url'     => 'http://demo9.cmsmart.net/edusite_1/wp-content/uploads/2018/10/screenshot-home-kindergarten.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'udetor' ),
			'preview_url'                  => 'http://demo9.cmsmart.net/edusite_6/home-kindergarten',
			'title_home_page'                  => 'Home Kindergarten',			
		),

		array(
			'import_file_name'             => 'fitness',			
			'local_import_file_data'            => get_parent_theme_file_path( 'inc/import-files/fitness/demo-content.xml' ),
			'local_import_widget_file'     => get_parent_theme_file_path( 'inc/import-files/fitness/widgets.wie' ),
			'local_import_customizer_file' => get_parent_theme_file_path( 'inc/import-files/fitness/udetor-customizer.dat' ),
			'local_import_rev_slider_file' => get_parent_theme_file_path( 'inc/import-files/sliders/slider-fitness.zip' ), 			
			'import_preview_image_url'     => 'http://demo9.cmsmart.net/edusite_1/wp-content/uploads/2018/11/screenshot-home-fitness.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'udetor' ),
			'preview_url'                  => 'http://demo9.cmsmart.net/fitness',
			'title_home_page'                  => 'Home Fitness',			
		),
		
	);
}
add_filter( 'merlin_import_files', 'udetor_local_import_files' );