<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Udetor
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php	
	$custom_change_page_header = $custom_page_header_trans = $hclass ='';	
	if ( is_page()){
		$custom_change_page_header = get_post_meta($post->ID,'custom_change_page_header', true);
		$custom_page_header_trans = get_post_meta($post->ID,'custom_page_header_trans', true);
		if($custom_page_header_trans !='' && $custom_page_header_trans == '1'){
			$hclass = 'h-trans ';
		}
	}
	global $woocommerce;
	if ( $woocommerce && is_shop() || $woocommerce && is_product() || $woocommerce && is_product_category() || $woocommerce && is_product_tag() || $woocommerce && is_account_page() || $woocommerce && is_cart() || $woocommerce && is_checkout()){
		
		if ( true == get_theme_mod( 'udetor_woo_general_header_trans', true ) ) :
			$hclass = 'h-trans ';
		endif;
	}
	if(get_post_type()=='espresso_events'){ 
		if ( true == get_theme_mod( 'udetor_event_header_trans', false ) ) :
			$hclass = 'h-trans ';
		endif;
	}
	
	$global_header = get_theme_mod('udetor_global_header'); 
	$hid = $hname ='';
	if($custom_change_page_header !='' && $custom_change_page_header == '1'){
		$hid = esc_html( get_post_meta(  $post->ID, 'custom_page_header', true) );
	}elseif($global_header){
		$hid = $global_header;
	}
	if($hid != ''){
		$hname = get_post_field( 'post_name', $hid);	
	}	
	
	$udetor_header_default_logo = get_theme_mod( 'udetor_header_default_logo', '' );
		// Render page loader
		echo wp_kses_post( Udetor_Helper::udetor_page_loader() );

		/*$args = array(
	'post_type'  => 'sfwd-courses',
	'meta_query' => array(
		
		array(
			'key'     => 'course_skill_lever',
			'value'   => 'Beginner',
			'compare' => 'LIKE',
		),
		
	),
);
$the_query = new WP_Query( $args );
if ( $the_query->have_posts() ) {
    echo '<ul>';
    while ( $the_query->have_posts() ) {
        $the_query->the_post();
        echo '<li>' . get_the_title() . '</li>';
    }
    echo '</ul>';
} */
	?>
<div id="page" class="site wrapper">	
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'udetor' ); ?></a>	

	<header id="masthead" class="site-header <?php echo $hname.' '; echo $hclass; if(!$global_header){ echo 'header-default-wap'; } ?>">
		<?php if (is_page( 'homepage' )|| is_front_page() || is_home() || is_page( 'home-academy' ) || is_page( 'home-online-learning' ) || is_page( 'home-standard' )) { ?>
            <h1 class="homepage-title"><?php the_title(); ?></h1>
        <?php }         
		if($custom_change_page_header !='' && $custom_change_page_header == '1'){
			$custom_page_header =  esc_html( get_post_meta(  $post->ID, 'custom_page_header', true) );
			$custom_content_header = get_post($custom_page_header);
			
			echo Udetor_HeaderDesigner::render_content($custom_content_header->post_content,'vc');
		}
		elseif($global_header){
			$post_header = get_post($global_header);			
			echo Udetor_HeaderDesigner::render_content($post_header->post_content,'vc');

		}else{
	        if ( is_customize_preview() ) {
	            echo '<div class="udetor_highlight_mask"><a class="udetor_customize_section btn btn-primary" href="#" data-section="udetor_header">Customizer Header</a></div>';
	        }
	        ?>
			<div class="container">
				<div class="row">
					<?php
					if ( has_nav_menu( 'main-menu' ) ) {
						echo '<div class="site-branding col-sm-10 col-sp-10 col-md-10 col-lg-2">';		
					}else{
						echo '<div class="site-branding col-sm-7 col-sp-6 col-md-8 col-lg-2">';		
					}?>					
			            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
			            	<?php if($udetor_header_default_logo){
			            		echo '<img src="'.esc_url( $udetor_header_default_logo ).'" alt="'. esc_attr( get_bloginfo('description') ).'">';
			            	}else{ ?>
		                    	<img alt="<?php echo esc_attr( get_bloginfo('description') ); ?>" src="<?php echo get_parent_theme_file_uri() .'/assets/udetor/images/logo.png';?>">
		                    <?php } ?>
		                </a>						
					</div><!-- .site-branding -->

					<?php
					if ( has_nav_menu( 'main-menu' ) ) {	?>
						<button id="menu-toggle" class="menu-toggle col-md-2 col-sm-2 col-sp-2"><i class="fa fa-bars" aria-hidden="true"></i></button>
						<div id="site-header-menu" class="site-header-menu col-lg-10 col-md-12">
							<nav id="site-navigation" class="main-navigation col-lg-10 default-header">
								<?php wp_nav_menu( array( 'theme_location' => 'main-menu' ) ); ?>
							</nav><!-- #site-navigation -->
						</div>
					<?php }else{
						$admin_url = get_admin_url() . 'customize.php?url=' . get_permalink() . '&autofocus%5Bsection%5D=menu_locations';
						echo '<div class="txt-assign-menu col-sm-5 col-sp-6 col-md-4 col-lg-10"><a href="' . esc_url($admin_url) . '">' . esc_html__('Assign a menu here', 'udetor') . '</a></div>';
					} ?>
			    </div>
		    </div>
        <?php } ?>
        
	</header><!-- #masthead -->	
	