<?php
/**
 * Udetor - Education Experience Wordpress Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Udetor
 */

include_once 'inc/merlin-config.php';
get_template_part('udetor/core');

if ( is_plugin_active( 'buddypress/bp-loader.php' ) && is_plugin_active( 'sfwd-lms/sfwd_lms.php' ) ) {
	function udetor_buddypress_tab() {
	  global $bp;
	  bp_core_new_nav_item( array( 
	        'name' => __( 'Course Profile', 'udetor' ), 
	        'slug' => 'udetor-course-profile', 
	        'position' => 100,
	        'screen_function' => 'udetor_budypress_course_profile',
	        'show_for_displayed_user' => false,
	        'item_css_id' => 'udetor_budypress_course_profile'
	  ) );
	  
	}
	add_action( 'bp_setup_nav', 'udetor_buddypress_tab', 1000 );

	function udetor_budypress_course_profile () {
	    add_action( 'bp_template_title', 'udetor_buddypress_course_profile_title' );
	    add_action( 'bp_template_content', 'udetor_buddypress_course_profile_content' );
	    bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/plugins' ) );
	}

	function udetor_buddypress_course_profile_title() {
	  _e( 'Course Profile', 'udetor' );
	}

	function udetor_buddypress_course_profile_content() {
	  
	  echo do_shortcode('[ld_profile]');
	}
}