
jQuery( function ( $ ) {
	'use strict';

	/**
	 * Ajax for achive courses page.
	 */
	var _ = $( '.course-filter-items' );

	function getCourses( e ) {
		e.preventDefault();

		var num = $( '.current' ).text(),
			sortby = $( '.orderby_current' ).attr( 'data' ),
			layout = $( '.layout_current' ).attr( 'data' ),
			postPerpage = $( '.items_per_page' ).val(),
			type = $( '.type_current' ).children().attr( 'data' ),
			skill = $( '.skill_current' ).children().attr( 'data' ),
			cat = 'all',
			currentCat = $( '.cat_current' ),
			link,
			$this = $( this );
		var $rem = $this.attr('data');
		console.log($rem);
		if($rem == 'cat-removal'){
			cat = 'all';
		}else{
			cat = currentCat.data( 'slug' );
		}

		if($rem == 'type-removal'){
			type = 'all';
		}
		if($rem == 'skill-removal'){
			skill = 'all';
		}
		
		

		if ( $this.hasClass( 'items_per_page' ) ) {
			num = 1;
		}

		var href = $this.attr( 'href' );
		if ( href ) {
			if ( href.match( /(paged=\d+)/g ) ) {
				link = href.match( /(paged=\d+)/g )[0].split( '=' )[1];
			}
			else if ( href.match( /(page\/\d)/g ) ) {
				link = href.match( /(page\/\d+)/g )[0].split( '/' )[1];
			}

			num = null === link ? 1 : link;
		}

		var $siteMain = $( '.site-main' );
		if ( $this.hasClass( 'content-list' ) ) {
			$this.parent().find( '.layout_current' ).removeClass( 'layout_current' );
			$this.addClass( 'layout_current' );
			layout = 'list';
		}
		if ( $this.hasClass( 'content-grid' ) ) {
			$this.parent().find( '.layout_current' ).removeClass( 'layout_current' );
			$this.addClass( 'layout_current' );
			layout = '';
		}

		if ( $this.hasClass( 'content-counter' ) ) {
			$this.parent().find( '.orderby_current' ).removeClass( 'orderby_current' );
			$this.addClass( 'orderby_current' );
			sortby = 'trendding';
		}
		if ( $this.hasClass( 'content-rating' ) ) {
			$this.parent().find( '.orderby_current' ).removeClass( 'orderby_current' );
			$this.addClass( 'orderby_current' );
			sortby = 'rating';
		}
		if ( $this.hasClass( 'content-new' ) ) {
			$this.parent().find( '.orderby_current' ).removeClass( 'orderby_current' );
			$this.addClass( 'orderby_current' );
			sortby = '';
		}
		if($rem == 'cat-removal'){
			$('.list-style').find( '.cat_current' ).removeClass( 'cat_current' );
			$('.list-style').find( '[data-slug="all"]' ).addClass( 'cat_current' );
			$('.filter-removal-buttons').find('.cat-removal').remove();
			cat ='all';
			num = 1;
		}else{
			if ( $this.hasClass( 'cat-item' ) ) {
			$this.parent().find( '.cat_current' ).removeClass( 'cat_current' );
			$this.addClass( 'cat_current' );

			cat = $this.data( 'slug' );
			var catlabel =  $this.find('a').text();
			if(cat !='all'){
				$('.filter-removal-buttons').find('.cat-removal').remove();
				$('.filter-removal-buttons').append( '<div class="cat-removal" data="cat-removal">'+catlabel+'</div>' );	
			}else{
				$('.filter-removal-buttons').find('.cat-removal').remove();
			}
			
			num = 1;
			}

		}
		
		if($rem == 'type-removal'){
			$('.list-style').find( '.type_current' ).removeClass( 'type_current' );
			$('.type-item').find( '[data="all"]' ).parent().addClass( 'type_current' );
			$('.filter-removal-buttons').find('.type-removal').remove();
			type ='all';
			num = 1;
		}else{

			if ( $this.hasClass( 'type-item' ) ) {
				$this.parent().find( '.type_current' ).removeClass( 'type_current' );
				$this.addClass( 'type_current' );
				type = $this.children().attr( 'data' );
				if(type !='all'){
					$('.filter-removal-buttons').find('.type-removal').remove();
					$('.filter-removal-buttons').append( '<div class="type-removal" data="type-removal">'+type+'</div>' );	
				}else{
					$('.filter-removal-buttons').find('.type-removal').remove();
				}
				num = 1;
			}
		}

		if($rem == 'skill-removal'){
			$('.list-style').find( '.skill_current' ).removeClass( 'skill_current' );
			$('.skill-item').find( '[data="all"]' ).parent().addClass( 'skill_current' );
			$('.filter-removal-buttons').find('.skill-removal').remove();
			skill ='all';
			num = 1;
		}else{

			if ( $this.hasClass( 'skill-item' ) ) {
				$this.parent().find( '.skill_current' ).removeClass( 'skill_current' );
				$this.addClass( 'skill_current' );
				skill = $this.children().attr( 'data' );
				if(skill !='all'){
					$('.filter-removal-buttons').find('.skill-removal').remove();
					$('.filter-removal-buttons').append( '<div class="skill-removal" data="skill-removal">'+skill+'</div>' );	
				}else{
					$('.filter-removal-buttons').find('.skill-removal').remove();
				}
				num = 1;
			}
		}

		_.addClass( 'spinner' );
		$.get(
			UdeTor.ajaxUrl,
			{
				action: 'get_courses',
				_wpnonce: UdeTor.nonce_course,
				style: layout,
				posts_per_page: postPerpage,
				sort: sortby,
				paged: num,
				category: cat,
				type: type,
				skill: skill,
			},
			function ( response ) {
				_.removeClass( 'spinner' );
				_.hide();
				_.html( response );
				_.fadeIn( 500 );

				if ( $( '.content-grid' ).hasClass( 'layout_current' ) ) {
					$siteMain.removeClass( 'list-main' );
					$siteMain.addClass( 'grid-main' );
				}else{
					$siteMain.addClass( 'list-main' );
					$siteMain.removeClass( 'grid-main' );
				}

				_.removeClass( 'list' );
				_.removeClass( 'grid' );
				_.addClass( $siteMain.find( '.layout_current' ).attr( 'data' ) );

				var offset = 0;
				offset = offset + ( $( '#wpadminbar' ).length ? $( '#wpadminbar' ).height() : 0 );
				offset = offset + ( $( '.site-header' ).length ? $( '.site-header' ).height() : 0 );
				offset = offset + ( $( '.topbar' ).length ? $( '.topbar' ).height() : 0 );
				offset = offset + ( $( '.page__banner-top' ).length ? $( '.page__banner-top' ).height() : 0 );

				$( 'body, html' ).animate( {
					scrollTop: offset - 100
				}, 1000 );
			}
		);
	}

	$( '.post-type-archive-sfwd-courses .items_per_page' ).on( 'change', getCourses );
	$( '.tax-course_category .items_per_page' ).on( 'change', getCourses );

	var str = '.content-list, .content-grid, .content-counter, .content-rating, .page-numbers, .content-new, .udetor-filter-courses-widget .cat-item, .type-item, .skill-item, .cat-removal,.type-removal,.skill-removal';
	$( '.post-type-archive-sfwd-courses' ).on( 'click', str, getCourses );
	$( '.tax-course_category' ).on( 'click', str, getCourses );

})
