/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	'use strict';
	
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );

	jQuery('#customize-header-actions').append('<h3>Search Here</h3>');

	/* Call Customizer */
    $(".udetor_customize_panel").on('click', function(){ 
        var e = $(this).data("panel");
        parent.wp.customize.panel(e).focus();
    })

    $(".udetor_customize_section").on('click', function(){ 
        var e = $(this).data("section");
        parent.wp.customize.section(e).focus();
    })
    $(".udetor_customize_control").on('click', function(){ 
        var e = $(this).data("control");
        parent.wp.customize.control(e).focus();
    })

} )( jQuery );