<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
get_header(); 
?>
<div class="header-page course-list-title">
    <div class="container">        
            <div class="info-header-page">
            <?php
            if ( true == get_theme_mod( 'udetor_courses_show_page_title', true ) ) : 
                $custom_course_title = get_theme_mod('udetor_courses_page_title_content','');
                if($custom_course_title !=''){
                    echo '<h1 class="page-title">'. esc_html($custom_course_title) .'</h1>';
                }else{
                   the_archive_title( '<h1 class="page-title">', '</h1>' );
    
                }
                $udetor_courses_sub_heading = get_theme_mod( 'udetor_courses_sub_heading', '' );
                if($udetor_courses_sub_heading !=''){
                    echo '<div class="archive-description">'. esc_html($udetor_courses_sub_heading) .'</div>';
                }else{
                    the_archive_description( '<div class="archive-description">', '</div>' );    
                }
                
            endif;
            echo Udetor_Helper::udetor_learn_dash_breadcrumbs();             
            ?>
            </div>        
    </div>
</div>
    
    <div id="content" class="container site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
    
    <div id="primary" class="content-area">
        <main id="main" class="site-main" role="main"> 
        <?php
                if ( have_posts() ) : ?>
                    <div class="switch-layout-container">
                        <div class="switch-layout udetor-switch">
                            <a href="#" class="list switchToGrid  switch-active"><i class="fa fa-th-large"></i></a>
                            <a href="#" class="grid switchToList"><i class="fa fa-list-ul"></i></a>
                        </div>
                    </div> 
                    <div id="udetor-blog-archive" class="udetor-layout-grid course-filter-items">
                        <div class="container">
                            <div class="row">
                                <?php
                                /* Start the Loop */
                                while ( have_posts() ) : the_post();
                                    /*
                                     * Include the Post-Format-specific template for the content.
                                     * If you want to override this in a child theme, then include a file
                                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                                     */
    				                get_template_part( 'learndash/course_list_template');
                                    
                                endwhile;
                                wp_reset_postdata();
                                ?>
                            </div>
                            <?php
                            the_posts_pagination( array(
                            'screen_reader_text' => '',
                            'prev_text' => wp_kses('<i class="fa fa-arrow-'.(is_rtl()?'right':'left').'"></i>', array('i' => array('class' => array()))),
                            'next_text' => wp_kses('<i class="fa fa-arrow-'.(is_rtl()?'left':'right').'"></i>', array('i' => array('class' => array()))),
                            'before_page_number' => '',
                            ) );
                            ?>
                        </div>
                    </div>
                        <?php                        
						
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                    endif; ?>
                </main>
    </div>
    <?php 
    if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
        get_sidebar();
    } 
get_footer();
