<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Udetor
 */
get_header(); ?>
<div class="udetor-page-title events-pagetitle">
    <div class="entry-header container">
        <div class="col-md-12">
        <?php 
            the_archive_title( '<h1 class="entry-title">', '</h1>' );
            $udetor_event_list_sub_heading = get_theme_mod( 'udetor_event_list_sub_heading', '' );
            if($udetor_event_list_sub_heading !=''){
                    echo '<div class="ld-subheading">'. esc_html($udetor_event_list_sub_heading) .'</div>';
            }
            the_archive_description( '<div class="archive-description">', '</div>' );        
        
            Udetor_Core::get_udetor_template('breadcrumbs'); 
        
        ?>
        </div>
    </div>  
    
</div>
    <div id="content" class="container site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
    <div id="primary" class="content-area">
        <div class="container education-category-event">
            <div class="row">
                <main id="main" class="site-main">
                    <?php
                    if ( have_posts() ) : ?>
                        <div class="page-detail">
                            <?php
                            /* Start the Loop */
                            while ( have_posts() ) : the_post();
                                /*
                                 * Include the Post-Format-specific template for the content.
                                 * If you want to override this in a child theme, then include a file
                                 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                                 */
                                get_template_part( 'template-parts/content', 'event');
                            endwhile;
                            ?>
                        </div>
                        <?php
                        the_posts_pagination( array(
                            'screen_reader_text' => '',
                            'prev_text'          => wp_kses('<i class="fa fa-chevron-'.(is_rtl()?'right':'left').'"></i>', array('i' => array('class' => array()))),
                            'next_text'          => wp_kses('<i class="fa fa-chevron-'.(is_rtl()?'left':'right').'"></i>', array('i' => array('class' => array()))),
                            'before_page_number' => '',
                        ) );
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                    endif; ?>
                </main><!-- #main -->                
            </div>
        </div>
    </div><!-- #primary -->
<?php
if(Udetor_Helper::udetor_get_layout_class()=='right-sidebar' || Udetor_Helper::udetor_get_layout_class()=='left-sidebar'){
    get_sidebar();
}
get_footer();
