<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Udetor
 */
get_header(); 
$udetor_pages_404_img_content = get_theme_mod( 'udetor_pages_404_img_content', '' );
if($udetor_pages_404_img_content) {
	$urlimg404 = $udetor_pages_404_img_content;
}else{
	$urlimg404 = get_parent_theme_file_uri() . '/assets/udetor/images/img404.jpg';
}
$udetor_pages_404_main_txt1 = get_theme_mod('udetor_pages_404_main_txt1','' );
$udetor_pages_404_main_txt2 = get_theme_mod('udetor_pages_404_main_txt2','' );
?>
<div class="udetor-page-title">
    <div class="entry-header container">
	    <div class="col-md-12">	    
	        <h1 class="entry-title"><?php echo esc_html__( '404 Page', 'udetor' ); ?></h1>
	    
	        <?php 			
				Udetor_Core::get_udetor_template('breadcrumbs'); 			
			?>
		</div>
    </div>  
    
</div>
	<div id="content" class="site-content <?php echo esc_html(Udetor_Helper::udetor_get_layout_class()); ?>">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<section class="error-404 not-found container">
				<div class="page-content row">
					
					<div class="col-md-5 img-left-404">
						<img src="<?php echo esc_url($urlimg404); ?>" alt="<?php  esc_html_e( 'Udetor Page Error', 'udetor' ); ?>">							
					</div>						
					
					<div class="col-md-7">
						<?php if($udetor_pages_404_main_txt1 || $udetor_pages_404_main_txt2){
							echo '<h2 class="page-title">';
							if($udetor_pages_404_main_txt1){
								echo '<span class="txt1">'. esc_html($udetor_pages_404_main_txt1 ) .' </span>';
							}
							if($udetor_pages_404_main_txt2){
								echo '<span class="txt2 color-green">'. esc_html($udetor_pages_404_main_txt2 ) .'</span>';
							}
							echo '</h2>';
						}else{ ?>	
							<h2 class="page-title">
								<span class="txt1"><?php esc_html_e('404','udetor' ); ?></span>
								<span class="txt2 color-green"><?php esc_html_e('ERROR!', 'udetor' ) ?></span>
							</h2>		
						<?php } ?>
						<p class="sub-content">
						<?php 
						printf( esc_html__( 'Sorry, we can\'t find the page you are looking for. Please come back %s', 'udetor' ),'<a href="'. esc_url( home_url( '/' ) ) .'" rel="nofollow">Home</a>' );
						?>							
						</p>
					</div>
				
				</div><!-- .page-content -->
			</section><!-- .error-404 -->

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();
