<?php
/**
 * cleopa functions and definitions
 *
 * @package Netbase
 */

/**
 * Define theme constants
 */
 
 if( !function_exists('cleopa_default_options') ){
	function cleopa_default_options()
	{
		return array(
			'nbcore_blog_archive_layout' => 'classic',
			'nbcore_blog_sidebar' => 'right-sidebar',
			'nbcore_excerpt_only' => false,
			'nbcore_excerpt_length' => '35',
			'nbcore_blog_single_sidebar' => 'right-sidebar',
			'nbcore_color_scheme' => 'scheme_1',
			'nbcore_primary_color' => '#ca457e',
			'nbcore_secondary_color' => '#e68373',
			'nbcore_background_color' => '#ffffff',
			'nbcore_inner_background' => '#f7f7f7',
			'nbcore_heading_color' => '#444444',
			'nbcore_body_color' => '#666666',
			'nbcore_link_color' => '#444444',
			'nbcore_link_hover_color' => '#ca457e',
			'nbcore_divider_color' => '#d7d7d7',
			'nbcore_header_style' => 'left-inline',
			'nbcore_logo_upload' => '',
			'nbcore_logo_width' => '180',
			'nbcore_menu_resp' => '768',
			'nbcore_header_fixed' => false,
			'header_bgcolor' => '#ffffff',
			'nbcore_blog_width' => '70',
			'nbcore_blog_meta_date' => true,
			'nbcore_blog_meta_read_time' => true,
			'nbcore_blog_meta_author' => true,
			'nbcore_blog_meta_category' => true,
			'nbcore_blog_meta_tag' => true,
			'nbcore_blog_sticky_sidebar' => false,
			'nbcore_blog_meta_align' => 'left',
			'show_title_section' => true,
			'nbcore_page_title_padding' => '15',
			'nbcore_page_title_color' => '#444444',
			'body_font_family' => 'google,Poppins',
			'body_font_style' => '400',
			'body_font_size' => '14',
			'heading_font_family' => 'google,Poppins',
			'heading_font_style' => '400',
			'heading_base_size' => '16',
			'subset_cyrillic' => false,
			'subset_greek' => false,
			'subset_vietnamese' => false,
			'nbcore_wc_breadcrumb' => true,
			'nbcore_wc_content_width' => '70',
			'nbcore_pa_swatch_style' => '',
			'nbcore_wc_attr' => false,
			'nbcore_shop_title' => esc_html__('Shop', 'cleopa'),
			'nbcore_shop_action' => true,
			'nbcore_shop_sidebar' => 'right-sidebar',
			'nbcore_loop_columns' => 'three-columns',
			'nbcore_products_per_page' => '9',
			'nbcore_product_list' => 'grid-type',
			'nbcore_shop_content_width' => '70',
			'nbcore_grid_product_description' => false,
			'nbcore_pd_details_title' => true,
			'nbcore_pd_details_width' => '70',
			'nbcore_pd_details_sidebar' => 'right-sidebar',
			'nbcore_wc_sale' => 'style-1',
			'nbcore_pd_images_width' => '50',
			'nbcore_pd_thumb_pos' => 'bottom-thumb',
			'nbcore_pd_meta_layout' => 'left-images',
			'nbcore_pd_featured_autoplay' => false,
			'nbcore_info_style' => 'accordion-tabs',
			'nbcore_reviews_form' => 'full-width',
			'nbcore_reviews_round_avatar' => true,
			'nbcore_add_cart_style' => 'style-1',
			'nbcore_pd_show_social' => true,
			'nbcore_show_related' => true,
			'nbcore_pd_related_columns' => '4',
			'nbcore_show_upsells' => false,
			'nbcore_pd_upsells_columns' => '4',
			'nbcore_pb_background' => '#ca457e',
			'nbcore_pb_background_hover' => '#d56a98',
			// 'nbcore_pb_background_hover' => '#ae2761',
			'nbcore_pb_text' => '#ffffff',
			'nbcore_pb_text_hover' => '#ffffff',
			'nbcore_pb_border' => '#ca457e',
			'nbcore_pb_border_hover' => '#d56a98',
			'nbcore_sb_background' => '#ffffff',
			'nbcore_sb_background_hover' => '#ca457e',
			'nbcore_sb_text' => '#ca457e',
			'nbcore_sb_text_hover' => '#ffffff',
			'nbcore_sb_border' => '#ca457e',
			'nbcore_sb_border_hover' => '#ca457e',
			'nbcore_button_padding' => '30',
			'nbcore_button_border_radius' => '5px',
			'nbcore_button_border_width' => '1',
			'nbcore_cart_layout' => 'cart-layout-2',
			'nbcore_show_cross_sells' => true,
			'nbcore_cross_sells_per_row' => '4',
			'nbcore_cross_sells_limit' => '6',
			'home_page_title_section' => false,
			'nbcore_show_footer_top' => false,
			'nbcore_footer_top_layout' => 'layout-9',
			'nbcore_footer_top_color' => '#999999',
			'nbcore_footer_top_bg' => '#333333',
			'nbcore_show_footer_bot' => false,
			'nbcore_footer_bot_layout' => 'layout-9',
			'nbcore_footer_bot_color' => '#999999',
			'nbcore_footer_bot_bg' => '#333333',
			'nbcore_footer_abs_color' => '#999999',
			'nbcore_footer_abs_bg' => '#333333',
			'nbcore_top_section_padding' => '10',
			'nbcore_middle_section_padding' => '20',
			'nbcore_bot_section_padding' => '30',
			'nbcore_header_top_bg' => '#ffffff',
			'nbcore_header_top_color' => '#888888',
			'nbcore_header_middle_bg' => '#ffffff',
			'nbcore_header_middle_color' => '#333333',
			'nbcore_header_bot_bg' => '#fff',
			'nbcore_header_bot_color' => '#444444',
			'nbcore_footer_top_heading' => '#999999',
			'nbcore_footer_bot_heading' => '#999999',
			'nbcore_blog_archive_comments' => true,
			'nbcore_blog_archive_summary' => true,
			'nbcore_blog_archive_post_style' => 'style-1',
			'nbcore_blog_single_title_position' => 'position-1',
			'nbcore_blog_single_show_thumb' => true,
			'nbcore_blog_single_title_size' => '50',
			'nbcore_blog_single_show_social' => true,
			'nbcore_blog_single_show_author' => true,
			'nbcore_blog_single_show_nav' => true,
			'nbcore_blog_single_show_comments' => true,
			'nbcore_page_title_size' => '50',
			'nbcore_footer_abs_padding' => '10',
			'share_buttons_style' => 'style-1',
			'share_buttons_position' => 'inside-content',
			'pagination_style' => 'pagination-style-2',
			'show_back_top' => true,
			'back_top_shape' => 'square',
			'back_top_style' => 'light',
			'shop_sticky_sidebar' => false,
			'product_sticky_sidebar' => false,
			//meta
			'page_thumb' => 'no-thumb',
			'page_sidebar' => 'full-width',
			'page_content_width' => '70',
			'nbcore_blog_masonry_columns' => '2',
            'product_category_wishlist' => true,
            'product_category_quickview' => true,
            'nbcore_header_top_hover_color' => '#ffffff',
            'nbcore_header_middle_hover_color' => '#f68d7d',
            'nbcore_header_bot_hover_color' => '#f68d7d',
            'nbcore_meta_color' => '#999999',
            'nbcore_page_title_image' => '',
            'nbcore_footer_top_hover_color' => '#f68d7d',
            'nbcore_footer_bot_hover_color' => '#f68d7d',
            'nbcore_footer_abs_hover_color' => '#f68d7d',
            'nbcore_header_mainmn_bg' => '#fff',
            'nbcore_header_mainmn_color' => '#646464',
            'nbcore_header_mainmn_bor' => '#646464',
            'nbcore_header_mainmnhover_bg' => '#fff',
            'nbcore_header_mainmnhover_color' => '#646464',
            'nbcore_header_mainmnhover_bor' => '#646464',
            'nbcore_header_text_section' =>'',
            'nbcore_header_facebook' => '',
            'nbcore_header_linkedin' => '',
            'nbcore_header_instagram' => '',
            'nbcore_header_blog' => '',
            'nbcore_header_pinterest' => '',
            'nbcore_header_ggplus' => '',
            'nbcore_header_twitter' => '',
            'nbcore_footer_abs_left_content' => '',
            'nbcore_footer_abs_right_content' => '',
            'nbcore_show_to_shop' => '',
            'nbcore_shop_banner' => '',
            'nbcore_upsells_limit' => '',
            'nbcore_logo_upload2' => '',
			'nbcore_page_layout' => 'full-width',
			'nbcore_header_preloading' =>false,
			'nbcore_header_style_preloading'=>'demo2'
		);

		if (!empty($default[$option])) {
			return $default[$option];
		}
	}
}

function child_theme_scripts_enqueue()
{
	wp_enqueue_style('nbcore_front_style_child_maincss', get_stylesheet_directory_uri() . '/assets/netbase/css/main.css', array(), Cleopa_VER);

}

add_action('wp_enqueue_scripts', 'child_theme_scripts_enqueue');
