<?php
/**
 * Template to displaying single toolkit
 * This template be registered in this plugin
 *
 * @since 1.0
 */

get_header();
$image_thumb = 'netbase-masonry-thumb';
if ( get_theme_mod( 'netbase_toolkit_layout' ) == 'grid' ): $image_thumb = 'netbase-thumb'; endif;
?>

<?php if( ! get_theme_mod( 'netbase_disable_breadcrumb' ) ): ?>
	<div class="container netbase-breadcrumb">
		<span><a class="crumb" href="<?php echo esc_url( home_url('/') ); ?>"><?php esc_html_e( 'Home', 'nbstart' ); ?></a></span><i class="fa fa-angle-right"></i>
		<span><?php single_cat_title('', true); ?></span>
	</div>
<?php endif; ?>

<div class="container <?php if ( get_theme_mod( 'netbase_toolkit_cat_enable_sidebar' ) ) : ?>netbase_sidebar<?php endif; ?>">
	<div id="main">
		<div class="netbase-page-header">
			<h1><?php single_cat_title(); ?></h1>
		</div>
		
		<?php if ( category_description() ) : // Show an optional category description ?>
			<div class="netbase-category-description align-center"><?php echo sanitize_text_field( category_description() ); ?></div>
		<?php endif; ?>
		
		<?php if( have_posts() ): ?>
		<div class="wrapper-netbase-toolkit">
			<div class="netbase-toolkit netbase-toolkit-wrap column-<?php if ( get_theme_mod( 'netbase_toolkit_cat_enable_sidebar' ) ) { echo '2'; } else { echo '3'; } ?>">
				<div class="inner-toolkit-posts">
					<?php while ( have_posts() ): the_post(); ?>
						<article class="toolkit-item" id="toolkit-<?php the_ID(); ?>">
							<div class="inner-item-toolkit">
								<div class="info-toolkit">
									<div class="netbase-toolkit-thumbnail">
										<a href="<?php the_permalink(); ?>">
										<?php /* Thumbnail */
										if ( has_post_thumbnail() ) {
											the_post_thumbnail( $image_thumb );
										}
										else {
											echo '<img src="' . Netbase_Toolkit_Post_Type::$plugin_uri . 'assets/images/no-thumbnail.jpg" alt="' . __( "No Thumbnail", 'nbstart' ) . '" />';
										}
										?>
										</a>
									</div>
									<div class="toolkit-desc">
										<a href="<?php the_permalink(); ?>">
											<h3 class="toolkit-title"><?php the_title(); ?></h3>
											<?php
											/* Get list term of this toolkit */
											$get_terms = wp_get_post_terms( $post->ID, 'toolkit_cat' );
											if ( ! empty( $get_terms ) ):
											
											$list_cats = array();
											foreach ( $get_terms as $term ) {
												$list_cats[] = $term->name;
											}
											$list_cats = implode( ', ', $list_cats );
											?>
											<span class="toolkit-cat"><?php echo $list_cats;?></span>
											<?php endif; ?>
										</a>
									</div>
								</div>
							</div>
						</article>
					<?php endwhile; ?>
				</div>
			</div>
		</div>	
		
		<?php echo Netbase_Toolkit::netbase_pagination_numbers(); ?>
		<?php endif; ?>
	</div>

<?php if ( get_theme_mod( 'netbase_toolkit_cat_enable_sidebar' ) ) : ?><?php get_sidebar(); ?><?php endif; ?>

<?php get_footer(); ?>