<?php
/*
Plugin Name: Netbase WPBakery - Elementor
Plugin URI: http://netbaseteam.com/
Description: WPBakery and Elementor Element
Version: 1.0
Author: nham.dv
Author URI: http://themeforest.net/user/netbaseteam
*/

define('NB_ELEMENTS_PATH', plugin_dir_path(__FILE__) );

// Register Elemetor Categories
function nb_add_elementor_widget_categories( $elements_manager ) {
   	$elements_manager = Elementor\Plugin::instance()->elements_manager;

    $elements_manager->add_category( 'Udetor', [ 'title' => __( 'Udetor', 'nb-core' ), 'icon' => 'fa fa-plug', ] );  
}
add_action( 'elementor/elements/categories_registered', 'nb_add_elementor_widget_categories' );    

// Require Element
require_once( NB_ELEMENTS_PATH . 'inc/functions.php' );	
/*require_once( NB_ELEMENTS_PATH . 'elements/social-media.php' );
require_once( NB_ELEMENTS_PATH . 'elements/blog.php' );
require_once( NB_ELEMENTS_PATH . 'elements/brands-list.php' );
require_once( NB_ELEMENTS_PATH . 'elements/heading.php' );*/

require_once( NB_ELEMENTS_PATH . 'elements/list-posts.php' );
require_once( NB_ELEMENTS_PATH . 'elements/countdown.php' );
require_once( NB_ELEMENTS_PATH . 'elements/counters-box.php' );
require_once( NB_ELEMENTS_PATH . 'elements/heading.php' );
require_once( NB_ELEMENTS_PATH . 'elements/our-team.php' );
require_once( NB_ELEMENTS_PATH . 'elements/posts-gallery.php' );
require_once( NB_ELEMENTS_PATH . 'elements/pricing-table.php' );
require_once( NB_ELEMENTS_PATH . 'elements/services.php' );
require_once( NB_ELEMENTS_PATH . 'elements/testimonials.php' );
require_once( NB_ELEMENTS_PATH . 'elements/upcoming-events.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-banner.php' );


function nb_element_class() {
    //TODO add apply_filter
    return array(
        /*'NB_Social_Element',
        'NB_Blog_Element',
        'NB_Brands_Element',
        'NB_Heading_Element',*/
        'NB_List_Posts_Element',
        'NB_Countdown_Element',
        'NB_Counters_Box_Element',
        'NB_Heading_Element',
        'NB_Our_Team_Element',
        'NB_Posts_Gallery_Element',
        'NB_Pricing_Table_Element',
        'NB_Services_Element',
        'NB_Testimonials_Element',
        'NB_Upcoming_Events_Element',
        'NB_Vc_Banner_Element',
    );
}

// Elementor
function nb_elementor() {
    $class_arr = nb_element_class();

    foreach( $class_arr as $class ) {
        $element = new $class();
        $options = $element->options();
        $args = array();

        add_action( 'elementor/widgets/widgets_registered', function() use( $options, $args ) {

            include_once NB_ELEMENTS_PATH . 'inc/class-elementor.php';

            $args['widget_name'] = $options['name'];
            $args['id_control'] = isset( $options['id'] ) ? $options['id'] : 'content_section';
            $args['icon'] = isset( $options['icon'] ) ? $options['icon'] : '';
            $args['title'] = $options['name'];
            $args['category'] = $options['category'];
            $args['option'] = $options['params'];
            
            $elementor = new Create_Element();
            $elementor->init( $args );
    
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( $elementor );
        } );
    }
}
nb_elementor();

// WPBakery Map
function nb_wpbakery_map() {
    $class_arr = nb_element_class();

    foreach( $class_arr as $class ) {
        $element = new $class();
        $options = $element->options();

        vc_map( $options );
    }
}
add_action( 'vc_before_init', 'nb_wpbakery_map' );

// WPBakery Shortcode
function nb_wpbakery_shortcode() {
    $class_arr = nb_element_class();

    foreach( $class_arr as $class ) {
        $element = new $class();
        $options = $element->options();

        $base = $options['base'];

        add_shortcode( $base, array( $class, 'content' ) );
    }
}
add_action( 'init', 'nb_wpbakery_shortcode' );

?>