<?php
function nb_elementor_options( $pagebuilder, $options ) {
	$defaults = array(  
		'param_name'		=> '',
		'heading' 			=> '',
		'admin_label' 		=> false,
		'value' 			=> '',
		'std'				=> '',
		'edit_field_class' 	=> '',
		'dependency' 		=> '',
		'description'		=> '',
		'type'				=> 'text',
		'group'				=> '',
		'params'			=> '',
	);
	
	$html = array();

	if ( $pagebuilder == 'elementor' ) {
		if ( is_array( $options ) ) {
			foreach( $options as $key => $option ) {
				$option = wp_parse_args( $option, $defaults );

				if ( $option['param_name'] == '' && $option['type'] != 'css_editor') continue;

				$condition = array();
				$depen = $option['dependency'];

				if ( $depen != '' ) {

					if ( isset( $depen['value_not_equal_to'] ) && $depen['value_not_equal_to'] != '' ) {
						// Switcher for Elementor
						if ( $depen['value_not_equal_to'] == 'true' || $depen['value_not_equal_to'] == '1' ) {
							$depen['value'] = 'yes';
						}
						elseif ( $depen['value_not_equal_to'] == 'false' || $depen['value_not_equal_to'] == '0' ) {
							$depen['value'] = 'no';
						}
						// End Switcher

						$condition[ $depen['element'] . '!' ] = $depen['value_not_equal_to'];
					} 
					else {
						// Switcher for Elementor
						if ( $depen['value'] == 'true' || $depen['value'] == '1' ) {
							$depen['value'] = 'yes';
						}
						elseif ( $depen['value'] == 'false' || $depen['value'] == '0' ) {
							$depen['value'] = 'no';
						}
						// End Switcher

						$condition[ $depen['element'] ] = $depen['value'];
					}
				}

				$arr_option = array();

				// Return options dropdown and more
				if ( isset( $option['value'] ) && is_array( $option['value'] ) ) {		        	
					$arr_option = array_flip( $option['value'] );
				}

				// Return value
				if ( isset( $option['value'] ) ) {
					if ( $option['type'] == 'checkbox' ) {
						$option['std'] = $option['value'] ? 'yes' : 'no';
					}
					if ( $option['type'] == 'textfield' || $option['type'] == 'colorpicker' || $option['type'] == 'textarea' ) {
						$option['std'] = $option['value'];
					}

				}
				// End return values

				$html[$key]["id"] = $option['param_name'];
				
				// Type: Gallery
				if ( $option['type'] == 'attach_images' ) {
					$html[$key]["field"] = array(
						"label" => $option['heading'],
						"type" => $option['type'],
						"default" => [],
						"condition" => $condition,
						"description" => $option['description'],
					);
				}
				if ( $option['type'] == 'attach_image' ) {
					$html[$key]["field"] = array(
						"label" => $option['heading'],
						"type" => $option['type'],
						"default" => [],
						"condition" => $condition,
						"description" => $option['description'],
					);
				}
				else {
					$html[$key]["field"] = array(
						"params" => $option['params'],
						"label" => $option['heading'],
						"type" => $option['type'],
						"options" => $arr_option,
						"default" => $option['std'],
						"condition" => $condition,
						"txt_default" => $option['value'],
						"description" => $option['description'],
					);
				}	
			}
		}
		
	} else {

		foreach( $options as $option ) {
			$html[] = $option;			
		}
	}

	return $html;
}

function nb_elementor_render( $name, $content ) {

	switch ( $name ) {
		case 'List Posts':
			echo NB_List_Posts_Element::content( $content );
			break;

		case 'Countdown Box':
			echo NB_Countdown_Element::content( $content );
			break;

		case 'Counters Box':
			echo NB_Counters_Box_Element::content( $content );
			break;

		case 'Heading':
			echo NB_Heading_Element::content( $content );
			break;
		case 'Our Team':
			echo NB_Our_Team_Element::content( $content );
			break;
		case 'Posts Gallery':
			echo NB_Posts_Gallery_Element::content( $content );
			break;
		case 'Pricing Table':
			echo NB_Pricing_Table_Element::content( $content );
			break;

		case 'Services':
			echo NB_Services_Element::content( $content );
			break;

		case 'Testimonials':
			echo NB_Testimonials_Element::content( $content );
			break;
		case 'List Upcoming Events':
			echo NB_Upcoming_Events_Element::content( $content );
			break;
		case 'Banner':
			echo NB_Vc_Banner_Element::content( $content );
			break;			
			
		default:
			wp_die();
			break;
	}
}

function nb_elementor_get_type( $type ) {
    $args = array(
        'textarea' => \Elementor\Controls_Manager::TEXTAREA,
        'textfield' => \Elementor\Controls_Manager::TEXT,
        'textarea_html' => \Elementor\Controls_Manager::WYSIWYG,
        'dropdown' => \Elementor\Controls_Manager::SELECT,
        'checkbox' => \Elementor\Controls_Manager::SWITCHER,
        'param_group' => \Elementor\Controls_Manager::REPEATER,
        'attach_image' => \Elementor\Controls_Manager::MEDIA,
        'attach_images' => \Elementor\Controls_Manager::GALLERY,
        //'number'=>\Elementor\Controls_Manager::NUMBER,
        // 'posttypes'
        'colorpicker' => \Elementor\Controls_Manager::COLOR,
        'exploded_textarea' => \Elementor\Controls_Manager::CODE,
        // 'widgetised_sidebars'
        'textarea_raw_html' => \Elementor\Controls_Manager::RAW_HTML,
        'vc_link' => \Elementor\Controls_Manager::URL,
        // 'loop'
        // 'css_editor'
    );
    return isset( $args[$type] ) ? $args[$type] : Elementor\Controls_Manager::TEXTAREA;
}
?>