<?php

class Create_Element extends \Elementor\Widget_Base {
    protected $widget_name;
    protected $id_control;
    protected $icon;
    protected $title;
    protected $category;
    protected $option;

    public function init( $args = [] ) {
        $this->widget_name = isset( $args['widget_name'] ) ? $args['widget_name'] : '';
        $this->id_control = isset( $args['id_control'] ) ? $args['id_control'] : '';
        $this->icon = isset( $args['icon'] ) ? $args['icon'] : '';
        $this->title  = isset( $args['title'] ) ? $args['title'] : '';
        $this->category  = isset( $args['category'] ) ? $args['category'] : '';
        $this->option = isset( $args['option'] ) ? $args['option'] : '';
    }

    public function get_name() {
        return $this->widget_name;
    }

    public function get_title() {
        return $this->title;
    }

    public function get_icon() {
        return $this->icon;
    }

    public function get_categories() {
        return [ $this->category ];
    }
    
    protected function _register_controls() {

        $this->start_controls_section(
            $this->id_control,
            [
                'label' => __( 'General', 'elementor' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $elements = nb_elementor_options( 'elementor', $this->option );

        foreach ( $elements as $element ) {
            $item                   = array();
            $params_repeater = array();
            $i_option = array();
            if (isset($element["field"]['params'])) {
                $params_repeater = $element["field"]['params'];
            }
            if (isset($element["field"]['options'])) {
                $i_option = $element["field"]['options'];
            }
            $item['id']             = $element["id"];
            $item['label']          = $element["field"]['label'];
            $item['type']           = nb_elementor_get_type( $element["field"]['type'] );
            $item['options']        = $i_option;
            $item['default']        = $element["field"]['default'];
            $item['condition']      = $element["field"]['condition'];
            $item['description']    = $element["field"]['description'];
            $item['params']         = $params_repeater;

            // Type: Repeater
            if ( nb_elementor_get_type( $element["field"]['type'] ) == 'repeater' && ! empty( $element["field"]['params'] ) ) {
                $repeater = new \Elementor\Repeater();

                foreach ( $item['params'] as $param_item ) {
                    $repeater->add_control(
                        $param_item['param_name'], [
                            'label' => $param_item['heading'],
                            'type'  => nb_elementor_get_type( $param_item['type'] ),
                        ]
                    );
                }

                $this->add_control(
                    $item['id'],
                    [
                        'label'     =>  $item['label'],
                        'type'      =>  $item['type'],
                        'fields'    => $repeater->get_controls(),
                        'default'   => [],
                    ]
                );
            }
            else {
                $this->add_control(
                    $item['id'],
                    [
                        'label'         => $item['label'],
                        'type'          => $item['type'],
                        'options'       => $item['options'],
                        'description'   => $item['description'],
                        'default'       => $item['default'],
                        'condition'     => $item['condition'],
                    ]
                );
            }  
        }

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        // Get Element name
        $data = $this->get_data();
        $name = $data['widgetType'];

        // Render Content
        echo nb_elementor_render( $name, $settings );
    }
}
