<?php
class NB_Vc_Banner_Element {

	public function options() {		

		$options = array(
			"name" => __( "Banner", "nb_element" ),
			"base" => "netbase_vc_banner",
			"class" => "",
			"category" => __( "Udetor", "nb_element"),
			'id' => 'netbase_vc_banner',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Primary Text', 'netbase-toolkit' ),
                    'param_name'  => 'txt_primary',
                    'value'       => esc_html__( '', 'netbase-toolkit' ),
                    'description' => esc_html__( 'Write the title.', 'netbase-toolkit' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ), 

                array(
                    'heading'    => __( 'Text Primary 1', 'netbase-toolkit' ),
                    'param_name' => 'title_e1',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type'        => 'colorpicker',                    
                    'heading'     => esc_html__( 'Text color custom ', 'netbase-toolkit' ),
                    'param_name'  => 'textcolor_custom',
                    'value'       => esc_html__( '', 'netbase-toolkit' ),
                    'description' => esc_html__( 'Select the title color.', 'netbase-toolkit' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    
                ),  
                array(
                    'heading'    => __( 'Text Primary 2', 'netbase-toolkit' ),
                    'param_name' => 'title_e2',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                        'heading'     => __( 'Image', 'netbase-toolkit' ),
                        'param_name'  => 'banner_img',
                        'type'        => 'attach_image',
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show Image as background', 'netbase-toolkit' ),
                        'param_name' => 'show_img_as_background',                                          
                ),

                array(
                    'heading'    => __( 'Caption text', 'netbase-toolkit' ),
                    'param_name' => 'txt_caption',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show divider', 'netbase-toolkit' ),
                        'param_name' => 'show_caption_divider',                                          
                ),
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Description', 'netbase-toolkit' ),
                    'param_name'  => 'description',
                    'value'       => esc_html__( '', 'netbase-toolkit' ),
                    'description' => esc_html__( 'Write the title for the heading.', 'netbase-toolkit' )
                ), 
                array(
                    'heading'    => __( 'Button Text', 'netbase-toolkit' ),
                    'param_name' => 'txt_button',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Url', 'netbase-toolkit' ),
                    'param_name' => 'button_url',
                    'type'       => 'textfield',                    
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Alt text', 'netbase-toolkit' ),
                    'param_name' => 'txt_alt',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Add link to Title', 'netbase-toolkit' ),
                        'param_name' => 'link_to_title',                                          
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Background', 'netbase-toolkit' ),
                        'param_name' => 'text_info_bg',                                          
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Box Circle', 'netbase-toolkit' ),
                        'param_name' => 'text_info_circle',                                          
                ),

                //Alignment
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Text alignment', 'netbase-toolkit' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Text at left', 'netbase-toolkit' )   => 'text-left',
                        __( 'Text at center', 'netbase-toolkit' ) => 'text-center',
                        __( 'Text at right', 'netbase-toolkit' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),

                //Alignment
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Text alignment', 'netbase-toolkit' ),
                    'param_name'  => 'text_position',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Top left', 'netbase-toolkit' )   => 'top-left',
                        __( 'Top Right', 'netbase-toolkit' )   => 'top-right',
                        __( 'Center Center', 'netbase-toolkit' ) => 'center-center',
                        __( 'Center Left', 'netbase-toolkit' )  => 'center-left',
                        __( 'Center Right', 'netbase-toolkit' )  => 'center-right',
                        __( 'Bottom Center', 'netbase-toolkit' )  => 'bottom-center',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Effect Image', 'netbase-toolkit' ),
                    'param_name'  => 'effect_img',
                    'value'       => array(
                        'Choose the effect'     => '',
                        __( 'Effect Zoom', 'netbase-toolkit' )   => 'effect-zoom',
                        __( 'Effect 1', 'netbase-toolkit' ) => 'effect-1',
                        __( 'Effect 3', 'netbase-toolkit' ) => 'effect-3',
                        __( 'Effect 5', 'netbase-toolkit' ) => 'effect-5',
                        
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom Class', 'netbase-toolkit' ),
                    'param_name' => 'custom_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',  
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                  
                ),

                //Animation
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Animation', 'netbase-toolkit' ),
                    'param_name'  => 'css_animation',                    
                    'value'       => array(
                        __( 'No', 'netbase-toolkit' )                 => '',
                        __( 'Top to bottom', 'netbase-toolkit' )      => 'top-to-bottom',
                        __( 'Bottom to top', 'netbase-toolkit' )      => 'bottom-to-top',
                        __( 'Left to right', 'netbase-toolkit' )      => 'left-to-right',
                        __( 'Right to left', 'netbase-toolkit' )      => 'right-to-left',
                        __( 'Appear from center', 'netbase-toolkit' ) => 'appear'
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'netbase-toolkit' )
                ),                
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'netbase-toolkit' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'netbase-toolkit' ),
                )
				
				


			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		$html = $attr_parent = '';
        $custom_class ='';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'txt_primary' => '',
                    'txt_caption' => '',
                    'description' => '',
                    'txt_button' => '',
                    'button_url' => '',
                    'txt_alt' => '',
                    'link_to_title' => '',
                    'show_caption_divider' => '',
                    'show_img_as_background' => '',
                    'text_info_bg' =>'',
                    'text_info_circle' => '',
                    'text_align' => 'text-left',
                    'text_position'=>'',
                    'css_animation' => '',
                    'title_e1' => '',
                    'title_e2' => '',
                    'textcolor_custom'         => '',
                    'custom_class' => '',
                    'effect_img' => '',
                    'css' => '',    
                    'banner_img' => '',                   
                    
                ),
                $atts
            )
        );
        
        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        
        $css_class = $edusite_animation = $sub_heading_css = $html = $nbcss_custom = $line = $line_css = '';
        $classes = array();
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_vc_banner', $atts ); 
        }
        if ( $textcolor_custom ) {
            $nbcss_custom .= 'color:' . $textcolor_custom . ';';
        }               
             
                
        if ( $nbcss_custom ) {
            $nbcss_custom = ' style="' . $nbcss_custom . '"';
        }
        if(isset($text_info_bg)){
            if($text_info_bg){
                $classes[] ='bg-white';
            }  
        }
        if($text_info_circle){
            $classes[] ='box-circle';
        }
        
        $src = wp_get_attachment_image_src($banner_img,'full');       
       
        if($text_align && $text_align <> ''){ $text_align = $text_align; }else{ $text_align = ''; }

        if($text_position){ $text_position = 'p-'.$text_position; }else{ $text_position=''; }

        $bg_image_style =  $show_img_as_background ? "style='background: url(" . esc_url( $src[0] ) . ")  center/cover no-repeat'" : '';

        $has_divider_class = $show_caption_divider ? ' has-divider' : '';

        // Generate HTML code.
        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw banner '.$custom_class.' '.$effect_img.' '.esc_attr( $css_class ).'">';

        $html .= '<div class="nbfw_banner-container" ' . $bg_image_style . ' >';

        if( ! $show_img_as_background )
            $html .= '<img src="' . esc_url( $src[0] ) . '" alt="banner" />';
        
        if($txt_caption || $txt_primary || $description || $txt_button){
            $html .= '<div class="nbfw-txt-info '.$text_align.' '.$text_position.' '. esc_attr( implode( ' ', $classes ) ) .'" >';
            if($txt_caption){
                $html .='<div class="txt-caption' . $has_divider_class . '"> ' . $txt_caption;
                if($show_caption_divider) $html .= '<span class="txt-caption-divider"></span>';
                $html .= '</div>';
            }
            if($title_e2){
                $html .='<h4 class="title_e2">';
                    $html .=' '.$title_e2;
                $html .='</h4>';
            }
            if($txt_primary){

                $html .='<h4 class="txt-primary" '. $nbcss_custom .'>';
                if($link_to_title && $button_url){
                $html .='<a href="'. esc_url($button_url).'">';
                }
                $html .=' '.$txt_primary ;
                if($title_e1){
                $html .='<span > '.$title_e1.'</span>';
                }
                
                if($link_to_title && $button_url){
                    $html .='</a>';
                }

                $html .='</h4>';
            }

            if($description){
                $html .='<p class="txt-des"> '.$description.'</p>';
            }
            if($txt_button){
                $html .='<a href="'. esc_url($button_url).'" class="banner-more">'.$txt_button.'</a>';
            }

            $html .= '</div>';
        }
        
        
        $html .= '</div>';
        $html .= '</div>';
        // End HTML code.

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_banner', force_balance_tags($html));
	}
}
