<?php
class NB_Posts_Gallery_Element {

	public function options() {		

		$options = array(
			"name" => __( "Posts Gallery", "nb_element" ),
			"base" => "netbase_posts_gallery",
			"class" => "",
			"category" => __( "Udetor", "nb_element"),
			'id' => 'netbase_posts_gallery',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Title', 'udetor' ),
                    'param_name'  => 'title',
                    'value'       => '',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Number posts', 'udetor' ),
                    'param_name'  => 'number_posts',
                    'std'         => '4',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',
                        esc_html__( '5', 'udetor' )      => '5',
                        esc_html__( '6', 'udetor' )      => '6',
                        esc_html__( '7', 'udetor' )      => '7',
                        esc_html__( '8', 'udetor' )      => '8',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Colunms posts', 'udetor' ),
                    'param_name'  => 'colunms_posts',
                    'std'         => '3',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',
                        
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type'       => 'dropdown',
                    'heading'    => esc_html__( 'Select Category', 'udetor' ),
                    'param_name' => 'cat_id',
                    'value'      => Netbase_Toolkit::udetor_core_sc_get_categories(),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type' => 'checkbox',
                    'heading'     => esc_html__( 'Show Description', 'udetor' ),
                    'param_name'  => 'show_description',
                    'value' => array(
                        esc_html__( 'Yes', 'udetor' ) => true,
                    ),
                    'std' => true,
                    'save_always' => true,
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Order by', 'udetor' ),
                    'param_name'  => 'orderby',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' )  => '',
                        esc_html__( 'Popular', 'udetor' ) => 'popular',
                        esc_html__( 'Recent', 'udetor' )  => 'recent',
                        esc_html__( 'Title', 'udetor' )   => 'title',
                        esc_html__( 'Random', 'udetor' )  => 'random',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Order', 'udetor' ),
                    'param_name'  => 'order',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( 'ASC', 'udetor' )    => 'asc',
                        esc_html__( 'DESC', 'udetor' )   => 'desc',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                /*array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Layout', 'udetor' ),
                    'param_name'  => 'layout',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( 'Default', 'udetor' ) => 'base',
                        esc_html__( 'Grid', 'udetor' )   => 'grid',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),*/

                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Select Image Size', 'udetor' ),
                    'param_name'  => 'image_size',
                    'value'       => Netbase_Toolkit::udetor_core_sc_get_list_image_size(),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

               /* array(
                    'type' => 'checkbox',
                    'heading'     => esc_html__( 'Show feature posts', 'udetor' ),
                    'param_name'  => 'display_feature',
                    'value' => array(
                        esc_html__( 'Yes', 'udetor' ) => 'yes',
                    ),
                    'group'       => esc_html__( 'Grid Settings', 'udetor' ),
                    'dependency' => array(
                        'element' => 'layout',
                        'value'   => 'grid',
                    ),
                ),*/

                /*array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Items vertical', 'udetor' ),
                    'param_name'  => 'item_vertical',
                    'std'         => '0',
                    'group'       => esc_html__( 'Grid Settings', 'udetor' ),
                    'dependency' => array(
                        'element' => 'layout',
                        'value'   => 'grid',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),*/

               /* array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Link All Posts', 'udetor' ),
                    'param_name'  => 'link',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text All Posts', 'udetor' ),
                    'param_name'  => 'text_link',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),*/

                /*array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Style', 'udetor' ),
                    'param_name'  => 'style',
                    'value'       => array(
                        esc_html__( 'Default Style', 'udetor' )  => '',
                        esc_html__( 'List', 'udetor' ) => 'list',
                      
                    ),
                ),*/

                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
				
				


			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		$html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'            => '',
                    'cat_id'           => '',
                    'image_size'       => 'none',
                    'show_description' => false,
                    'number_posts'     => '4',
                    'colunms_posts'    =>'3',
                    /*'layout'           => 'base',*/
                    'display_feature'  => '',
                    'item_vertical'    => '0',
                    'orderby'          => 'recent',
                    'order'            => 'asc',
                    /*'link'             => '',
                    'text_link'        => '',*/
                    /*'style'            => '',*/
                ),
                $atts
            )
        );        

        // Filter post type.
        $args = array(
            'cat' => $cat_id,
            'post_type'           => 'post',
            'orderby'             => $orderby,
            'order'               => $order,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'posts_per_page'      => $number_posts,
            'no_found_rows' => true,
        );

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');

        // Get query object.
        $the_query = new WP_Query( $args );
        $class_gallery_post='';
        switch ($colunms_posts){
            case '1': $class_gallery_post= 'col-md-12'; break;
            case '2': $class_gallery_post= 'col-md-6'; break;
            case '3': $class_gallery_post= 'col-md-6 col-sm-6 col-lg-4'; break;
            case '4': $class_gallery_post= 'col-md-6 col-sm-6 col-lg-3'; break;
            default : $class_gallery_post= 'col-md-6 col-sm-6 col-lg-4';
        }
        if($image_size=='none'){
            $image_size =  'udetor-course-thumb';   
        }        

        ob_start();
        // Generate HTML code.
        
            if($title){
                echo '<h3 class="font-h1 udetor-detail-title">'. esc_html($title) .'</h3>';    
            }            
            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();  
                echo '<div class="blog-gallery-item-popup '.esc_html($class_gallery_post).' ">';

                if( has_post_thumbnail( ) ) {
                    echo '<div class="post-thumbnail-gallery">';                    
                        echo '<a href="' . esc_url( get_the_post_thumbnail_url(get_the_ID(),'full') ) . '" title="'.get_the_title().'" class="gpopup bggallery">';
                        the_post_thumbnail($image_size);                       
                        echo '</a>';                    
                    ?>
                    <div class="gallery-title">
                        <span><?php the_title(); ?></span>
                        <ul>
                            <li><?php echo '<a href="' . esc_url( get_the_post_thumbnail_url(get_the_ID(),'full') ) . ' " title="'.get_the_title().'" class="gpopup"><i class="fa fa-search" aria-hidden="true"></i></a>';?></li>
                            <li><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>" ><i class="fa fa-link" aria-hidden="true"></i></a></li>
                        </ul>                    
                    </div>
                    <?php
                    echo '</div>';
                }
                         
                echo '</div>';

            }         

        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit list-post-gallery row">' . ob_get_clean() . '</div><!-- .netbase-toolkit -->';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_posts_gallery', force_balance_tags($html));
	}
}
