<?php
class NB_Our_Team_Element {

	public function options() {		

		$options = array(
			"name" => __( "Our Team", "nb_element" ),
			"base" => "netbase_our_team",
			"class" => "",
			"category" => __( "Udetor", "nb_element"),
			'id' => 'netbase_our_team',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'netbase-toolkit'),
                    'param_name' => 'title',
                    'value' => '',
                ),

                array(
                        'heading'    => esc_html__( 'Our Team content', 'netbase-toolkit' ),
                        'type'       => 'param_group',
                        'param_name' => 'our_team_content',
                        'params'     => array(
                            array(
                                'param_name' => 'avatar',
                                'heading'    => esc_html__( 'Avatar', 'netbase-toolkit' ),
                                'type'       => 'attach_image',
                            ),
                            array(
                                'param_name' => 'description',
                                'heading'    => esc_html__( 'description', 'netbase-toolkit' ),
                                'type'       => 'textarea',
                            ),
                            array(
                                'param_name' => 'name',
                                'heading'    => esc_html__( 'Name', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'job',
                                'heading'    => esc_html__( 'Job', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'facebook',
                                'heading'    => esc_html__( 'Facebook', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'twitter',
                                'heading'    => esc_html__( 'Twitter', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'google_plus',
                                'heading'    => esc_html__( 'Google plus', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),

                            array(
                                'param_name' => 'button_text',
                                'heading'    => esc_html__( 'Button Text', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'heading'    => __( 'Button Url', 'netbase-toolkit' ),
                                'param_name' => 'button_url',
                                'type'       => 'vc_link',
                                'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                            ),
                            array(
                                'param_name' => 'class_text',
                                'heading'    => esc_html__( 'Class', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'height',
                                'heading'    => esc_html__( 'Height', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'weight',
                                'heading'    => esc_html__( 'Weight', 'netbase-toolkit' ),
                                'type'       => 'textfield',
                            ),
                        ),
                    ),
                array(
                        'param_name' => 'avt_shape',
                        'heading'    => esc_html__( 'Avatar style', 'netbase-toolkit' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Square', 'netbase-toolkit' ) => 'square',
                            __( 'Circle', 'netbase-toolkit' ) => 'circle',
                        ),
                        'std'        => 'circle',
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                    ),
                array(
                        'param_name' => 'style',
                        'heading'    => esc_html__( 'Style', 'netbase-toolkit' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Style 1', 'netbase-toolkit' ) => 'style-1',
                            __( 'Style 2', 'netbase-toolkit' ) => 'style-2',
                            __( 'Style 3', 'netbase-toolkit' ) => 'style-3',
                            __( 'Style Home Fitness', 'udetor' ) => 'style-fitness',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                    ),              

                 array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'netbase-toolkit'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),        
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'netbase-toolkit' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                
                array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'netbase-toolkit' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                ), 
                array(
                        'param_name' => 'loop',
                        'heading'    => esc_html__( 'Enable Loop', 'netbase-toolkit' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                ), 
                array(
                        'param_name' => 'dots_size',
                        'heading'    => esc_html__( 'Dots Size', 'netbase-toolkit' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Big', 'netbase-toolkit' ) => 'big',
                            __( 'Small', 'netbase-toolkit' ) => 'small',
                            __( 'Line', 'netbase-toolkit' ) => 'line',
                        ),
                        'std'        => 'small',
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                ),         

                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'netbase-toolkit' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'netbase-toolkit' )  => '1',
                            __( '2 columns', 'netbase-toolkit' ) => '2',
                            __( '3 columns', 'netbase-toolkit' ) => '3',
                            __( '4 columns', 'netbase-toolkit' ) => '4',
                            __( '5 columns', 'netbase-toolkit' ) => '5',
                            __( '6 columns', 'netbase-toolkit' ) => '6',
                            __( '7 columns', 'netbase-toolkit' ) => '7',
                            __( '8 columns', 'netbase-toolkit' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'netbase-toolkit' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'netbase-toolkit' )  => '',
                            __( '1 column', 'netbase-toolkit' )  => '1',
                            __( '2 columns', 'netbase-toolkit' ) => '2',
                            __( '3 columns', 'netbase-toolkit' ) => '3',
                            __( '4 columns', 'netbase-toolkit' ) => '4',
                            __( '5 columns', 'netbase-toolkit' ) => '5',
                            __( '6 columns', 'netbase-toolkit' ) => '6',
                            __( '7 columns', 'netbase-toolkit' ) => '7',
                            __( '8 columns', 'netbase-toolkit' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),          
                array(
                        'param_name'  => 'columnstablet767',
                        'heading'     => esc_html__( 'Number of columns displayed mobile', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),      
                array(
                    'heading'    => __( 'Extra class name', 'netbase-toolkit' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'netbase-toolkit' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'netbase-toolkit' ),
                )

			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		$data_owlcarousel = $html = $attr_parent = '';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'layout' => 'default',
                    'columns' => '3',                  
                    'columnstablet' =>'',  
                    'our_team_content'  => '',
                    'avatar'                => '',
                    'avt_shape'             => 'circle',
                    'description'           => '',
                    'name'                  => '',
                    'job'                   => '',
                    'facebook' =>'',
                    'twitter' => '',
                    'google_plus' => '',
                    'style'                 => 'style-1',
                    'slider'                => true,
                    'pagination'   => '',
                    'autoplay'     => '',
                    'loop'         => '', 
                    'dots_size' => 'small',
                    'extra_class' => '',
                    'css' =>'',
                    'button_url' =>'',
                    'button_text' => '',
                    'columnstablet767' =>'',
                    'class_text'=> '',
                    'height' => '',
                    'weight' => '',
                ),
                $atts
            )
        );        
        
        $classes = $attr = array();     

        if ($extra_class !== '') {
            $classes[] = $extra_class;
        }
        if($style !=''){
         $classes[] = $style;   
        }        
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_our_team', $atts ); 
        }
        if ( ! empty( $slider ) ) {

            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"ades": "' . ( int ) $columnstablet . '"';
            }
            if (isset($columnstablet767) && ! empty( $columnstablet767 ) ) {
                $attr[] = '"tablet": "' . ( int ) $columnstablet767 . '"';
            }
            if ( $pagination ) { $attr[] = '"dots": "true"'; }
            if($autoplay){ $attr[] = '"autoplay": "true"'; }
            if($loop){ $attr[] = '"loop": "true"'; }
            if ( ! empty( $attr ) ) {                
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }
            if($dots_size && $pagination){
                $classes[] =' dots-'.$dots_size.' ';
            }

            $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
        }
        
        // Generate HTML code.

        $html .= '<div class="'.esc_attr( $css_class ).' netbase-toolkit our_team '. esc_attr( implode( ' ', $classes ) ) .'"  '.$data_owlcarousel.'>';
        $values = array();
        if(is_array($our_team_content)){
        	$values =$our_team_content;
        }else{
        	if (function_exists('vc_param_group_parse_atts')) {
            	$values = ( array ) vc_param_group_parse_atts( $our_team_content );
        	}
        }
        
        foreach ( $values as $key => $values ) {
        	
            $url = $target = $link_title = $rel ='';
            if(isset($values[ 'button_url']) && $values[ 'button_url'] !=''){
            	if(isset($values[ 'button_url']['url'])){
	            	$url = $values[ 'button_url']['url'];
	            	if(isset($values[ 'button_url']['is_external']) && $values[ 'button_url']['is_external'] =='on'){
						$target ='_blank';
	            	}
	            	if(isset($values[ 'button_url']['nofollow']) && $values[ 'button_url']['nofollow'] =='on'){
						$rel ='nofollow';
	            	}
	            }else{
	            	if(function_exists('vc_build_link')){
		                $href       =   vc_build_link($values[ 'button_url']);
		                $url            = ( isset( $href['url'] ) && $href['url'] !== '' ) ? $href['url']  : '';
		                $target         = ( isset( $href['target'] ) && $href['target'] !== '' ) ? esc_attr( trim( $href['target'] ) ) : '';
		                $link_title     = ( isset( $href['title'] ) && $href['title'] !== '' ) ? esc_attr($href['title']) : '';
		                $rel            = ( isset( $href['rel'] ) && $href['rel'] !== '' ) ? esc_attr($href['rel']) : '';
	            	}
	            }  

            }
                      

            if($target !=''){ $target = ' target="'.$target.'"'; }
            if($link_title !=''){ $link_title =' title="'.$link_title.'"';}
            if($rel !=''){ $rel = ' rel="'.$rel.'"';}
            if(isset($values[ 'button_text']) && $values[ 'button_text'] !='' ){
                $button_text = $values[ 'button_text'];
            }else{
                $button_text = 'Read more';
            }
            // Get image link and image data
            if ( ! empty( $values[ 'avatar' ] )){
            	if (  isset($values[ 'avatar' ]['url']) && $values[ 'avatar' ]['url'] !='') {
					$image_link = $values[ 'avatar' ]['url'];
	            }else{
	                $img_id       = preg_replace( '/[^\d]/', '', $values[ 'avatar' ] );
	                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
	                $image_link   = $image[ 'p_img_large' ][ 0 ];
	            }

            }            
            
            $html .= '<div class="profile-item text-center">';
            if($style =='style-fitness'){
                if ( ! empty( $values[ 'avatar' ] )  ) {                    
                    $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'netbase-toolkit' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . '  />';
                }

                    $html .= '<div class="tes-content">';
                        if ( ! empty( $values[ 'name' ] ) ) {
                            $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                        }
                        if ( ! empty( $values[ 'facebook' ]) || ! empty( $values[ 'twitter' ]) || ! empty( $values[ 'google_plus' ] ) ) {
                            
                            $html .='<div class="team-social">';
                                if ( ! empty( $values[ 'facebook' ] ) ) {
                                    $html .= '<a href="' . esc_html( $values[ 'facebook' ] ) . '"><i class="fa fa-facebook"></i> </a>';
                                }
                                if ( ! empty( $values[ 'twitter' ] ) ) {
                                    $html .= '<a href="' . esc_html( $values[ 'twitter' ] ) . '"><i class="fa fa-twitter"></i></a>';
                                }
                                if ( ! empty( $values[ 'google_plus' ] ) ) {
                                    $html .= '<a href="' . esc_html( $values[ 'google_plus' ] ) . '"><i class="fa fa-google"></i> </a>';
                                }
                            $html .='</div>';
                        } 
                        if ( ! empty( $values[ 'description' ] )  ) {
                            $html .= '<div class="content">';
                                $html .= '<p>' . $values[ 'description' ] . '</p>';
                            $html .= '</div>';
                        }
                         

                    $html .= '</div>';
                

            }else{
                $html .= '<div class="author mgt20">';
                    if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'netbase-toolkit' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . '  />';
                        $html .= '</div>';
                    }
                    if ( ! empty( $values[ 'name' ] ) ) {
                        $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                    }

                    if ( ! empty( $values[ 'job' ] ) ) {
                        $html .= '<p class="job meta-color">' . esc_html( $values[ 'job' ] ) . '</p>';
                    }
                    $html .= '</div>';
                    if ( ! empty( $values[ 'description' ] )  ) {
                        $html .= '<div class="content">';
                            $html .= '<p>' . $values[ 'description' ] . '</p>';
                        $html .= '</div>';
                    }
                    if ( ! empty( $values[ 'facebook' ]) || ! empty( $values[ 'twitter' ]) || ! empty( $values[ 'google_plus' ] ) ) {
                        
                        $html .='<div class="udetor-social-share">';
                            if ( ! empty( $values[ 'facebook' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'facebook' ] ) . '"><i class="fa fa-facebook"></i> </a>';
                            }
                            if ( ! empty( $values[ 'twitter' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'twitter' ] ) . '"><i class="fa fa-twitter"></i></a>';
                            }
                            if ( ! empty( $values[ 'google_plus' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'google_plus' ] ) . '"><i class="fa fa-google"></i> </a>';
                            }
                        $html .='</div>';
                    }           
                    if($url !='') {
                    $html .='<a class="btn-our-team" href="'. esc_url($url).'" '.$target.' '.$link_title.' '.$rel.'>';
                    $html .= $button_text;
                    $html .= '</a>';
                    }

            }
                             
            $html .= '</div>';            
        }

        $html .= '</div>';
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_our_team', force_balance_tags($html));
	}
}
