<?php
class NB_List_Posts_Element {

	public function options() {

		$args = array(
			'type' => 'post',
			'child_of' => 0,
			'parent' => '',
			'orderby' => 'parent',
			'order' => 'ASC',
			'hide_empty' => false,
			'hierarchical' => 1,
			'exclude' => '',
			'include' => '',
			'number' => '',
			'taxonomy' => 'category',
			'pad_counts' => false,
		);
		$categories = get_categories( $args );
		$output_categories = array();

		$output_categories[ "All Categories" ] = "";

		foreach( $categories as $category ) { 
			$output_categories[ wp_specialchars_decode( $category->name ) ] = $category->slug;
		}

		$options = array(
			"name" => __( "List Posts", "nb_element" ),
			"base" => "netbase_list_post",
			"class" => "",
			"category" => __( "Udetor", "nb_element"),
			'id' => 'netbase_list_post',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", "nb_element" ),
					"param_name" => "title",
					"description" => __('Title', 'nb_element'),
					"value" => '',
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number posts", "nb_element" ),
					"param_name" => "number_posts",
					"description" => __('Number posts', 'nb_element'),
					"value" => array(
						__( "Select", "nb_element" ) => '',
						__( "1", "nb_element" ) => '1',
						__( "2", "nb_element" ) => '2',
						__( "3", "nb_element" ) => '3',
						__( "4", "nb_element" ) => '4',
						__( "5", "nb_element" ) => '5',
						__( "6", "nb_element" ) => '6',
						__( "7", "nb_element" ) => '7',
						__( "8", "nb_element" ) => '8',
					), 
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Select Category", "nb_element" ),
					"param_name" => "cat_slug",
					"description" => __('Select Category', 'nb_element'),
					"value" => $output_categories,
				),

				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Order by", "nb_element" ),
					"param_name" => "orderby",
					"description" => __('Order by', 'nb_element'),
					"value"       => array(
                        esc_html__( 'Select', 'udetor' )  => '',
                        esc_html__( 'Popular', 'udetor' ) => 'popular',
                        esc_html__( 'Recent', 'udetor' )  => 'recent',
                        esc_html__( 'Title', 'udetor' )   => 'title',
                        esc_html__( 'Random', 'udetor' )  => 'random',
                    ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Order", "nb_element" ),
					"param_name" => "order",
					"description" => __('Order', 'nb_element'),
					"value"       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( 'ASC', 'udetor' )    => 'asc',
                        esc_html__( 'DESC', 'udetor' )   => 'desc',
                    ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Link All Posts", "nb_element" ),
					"param_name" => "link",
					"description" => __('Link All Posts', 'nb_element'),
					"value" => '',
				),

				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Text All Posts", "nb_element" ),
					"param_name" => "text_link",
					"description" => __('Text All Posts', 'nb_element'),
					"value" => '',
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Style", "nb_element" ),
					"param_name" => "style",
					"value"       => array(
                        esc_html__( 'Default Style', 'udetor' )  => '',
                        esc_html__( 'List', 'udetor' ) => 'list',
                        esc_html__( 'Grid', 'udetor' ) => 'grid',
                        esc_html__( 'Wave', 'udetor' ) => 'wave',
                        esc_html__( 'Multi Color', 'udetor' ) => 'multi-color',
                        esc_html__( 'Course', 'udetor' ) => 'course',
                    ),
					"description" => __( "Style blog", "nb_element" )
				),

				array(
					"type" => "checkbox",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Enable carousel", "nb_element" ),
					"param_name" => "slider",
					"description" => __('Enable carousel', 'nb_element'),
					"value" => "true",
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Number of columns displayed", "nb_element" ),
					"param_name" => "columns",
					"value"       => array(
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),
					"description" => __( "Number of columns displayed", "nb_element" )
				),

				array(
					"type" => "checkbox",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Enable Navigation", "nb_element" ),
					"param_name" => "navigation",
					"description" => __('Enable Navigation', 'nb_element'),
					"value" => "true",
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                    ),
				),

				array(
					"type" => "checkbox",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Enable Pagination", "nb_element" ),
					"param_name" => "pagination",
					"description" => __('Enable Pagination', 'nb_element'),
					"value" => "true",
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                    ),
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Dots Size", "nb_element" ),
					"param_name" => "dots_size",
					"value"      => array(
                            __( 'Big', 'udetor' ) => 'big',
                            __( 'Small', 'udetor' ) => 'small',
                        ),
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                        ),
					"description" => __( "Dots Size", "nb_element" )
				),

				array(
					"type" => "checkbox",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Enable Auto Play", "nb_element" ),
					"param_name" => "autoplay",
					"description" => __('Enable Auto Play', 'nb_element'),
					"value" => 'false',
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                    ),
				),

				array(
					"type" => "checkbox",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Enable Loop", "nb_element" ),
					"param_name" => "loop",
					"description" => __('Enable Loop', 'nb_element'),
					"value" => 'false',
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                    ),
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Navigation Position", "nb_element" ),
					"param_name" => "nav_position",
					"value"      => array(
                            __( 'Top', 'udetor' ) => 'top',
                            __( 'Center', 'udetor' ) => 'center',
                            __( 'Bottom', 'udetor' ) => 'bottom',
                        ),
					"dependency" => array(
                            "element" => 'navigation',
                            "value"   => "true",
                        ),
					"description" => __( "Navigation Position", "nb_element" )
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Number of columns displayed Tablet", "nb_element" ),
					"param_name" => "columnstablet",
					"value"       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ), 
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                        ),
					"description" => __( "Number of columns displayed Tablet", "nb_element" )
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Number of columns displayed Tablet s", "nb_element" ),
					"param_name" => "columnstablets",
					"value"       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ), 
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                        ),
					"description" => __( "Number of columns displayed Tablet s", "nb_element" )
				),

				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Margin Element", "nb_element" ),
					"param_name" => "margin",
					"description" => __('Margin Element', 'nb_element'),
					"value" => '',
					"dependency" => array(
                            "element" => 'slider',
                            "value"   => "true",
                        ),
				),

				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Extra class name", "nb_element" ),
					"param_name" => "extra_class",
					"description" => __('Style particular content element differently - add a class name and refer to it in custom CSS.', 'nb_element'),
					"value" => '',
					
				),

				array(
					"type" => "css_editor",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Css", "nb_element" ),
					"param_name" => "css",
					"description" => '',
					"value" => '',
					'group' => __( 'Design options', 'udetor' ),
					
				),

				
				


			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		global $post;

		$caption = $category = $detail = $button = $description = $background = $color = '';
		extract( shortcode_atts( array(
			'title'            => '',
            'cat_slug'           => '',
            'number_posts'     => '4',
			'display_feature'  => '',
                    'item_vertical'    => '0',
                    'orderby'          => 'recent',
                    'order'            => 'asc',
                    'link'             => '',
                    'text_link'        => esc_html__( 'Browse more', 'udetor' ),
                    'style'            => '',
                    'columns' => '3',  
                    'slider'                => true,
                    'columnstablet' =>'',    
                    'columnstablets' => '',           
                    'nav_position' => 'bottom',
                    'pagination'   => '',
                    'navigation'   => '',
                    'autoplay'     => '',
                    'loop'         => '', 
                    'margin'       => '',
                    'dots_size' => 'small',
		), $atts ) );

		// Filter post type.
        $args = array(
            'category_name' => $cat_slug,
            'post_type'           => 'post',
            'orderby'             => $orderby,
            'order'               => $order,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'posts_per_page'      => $number_posts,
            'no_found_rows' => true,
        );
        // Get query object.
        $the_query = new WP_Query( $args );

		ob_start();

		//set_query_var( 'colunms_post', $colunms_posts );
        $classes = $attr = array();
        $data_owlcarousel = '';

        if($style){
                $classes[] =' post-style-'.$style.' ';   
            }

            if ( ! empty( $slider ) ) {
                if($margin){
                    
                    $attr[] = '"margin": "' . ( int ) $margin . '"';
                }
                
                if ( $navigation ) {
                    $attr[] = '"nav": "true"';
                }
                if ( $pagination ) {
                    $attr[] = '"dots": "true"';
                }
                
                if ( ! empty( $columnstablets ) ) {
                    $attr[] = '"tablet": "' . ( int ) $columnstablets . '"';
                }
                if ( ! empty( $columnstablet ) ) {
                    $attr[] = '"ades": "' . ( int ) $columnstablet . '"';
                }
                if ( ! empty( $columns ) ) {
                    $attr[] = '"items": "' . ( int ) $columns . '"';
                }
                if($autoplay){
                    $attr[] = '"autoplay": "true"';
                }
                if($loop){
                    $attr[] = '"loop": "true"';
                }

                if ( ! empty( $attr ) ) {
                    $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
                }            

                if($dots_size && $pagination){
                    $classes[] =' dots-'.$dots_size.' ';
                }                

                if ( $nav_position && $navigation) {
                    $classes[] =' nav-'.$nav_position.' ';
                }                

                $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
        }
        echo '<div class="netbase-toolkit list-post '. esc_attr( implode( ' ', $classes ) ) .'"  '.$data_owlcarousel.'>';

        if($style && $style=='list'){
            if($title){
                echo '<h3 class="font-h1 udetor-detail-title">'. esc_html($title) .'</h3>';    
            }            
            echo '<ul class="plst">';
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();  
                    echo '<li>';
                        echo '<div class="featured-date">';
                            the_time('F j, Y');
                        echo '</div>'; ?>
                        <p class="plst-title" ><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>" ><?php the_title(); ?></a></p>
                    <?php                              
                    echo '</li>';
                }
            echo '</ul>';
            if($cat_slug && $cat_slug !=''){
                // Get the URL of this category
                $cat = get_category_by_slug($cat_slug); 
                $catID = $cat->term_id;
                $category_link = get_category_link( $catID );
                echo '<a href="'.esc_url( $category_link ).' " title="Category Name" class="secondary_btn">'. esc_html__( 'See all', 'udetor' ) .'</a>';
            }

        }
        elseif($style == 'grid'){            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();   
                ?>
                <div class="blog-item">
                    <?php
                    if( has_post_thumbnail( ) ) {
                        echo '<div class="post-thumbnail">';
                            echo '<a href="' . esc_url( get_permalink() ) . '">';
                            the_post_thumbnail('udetor-blog-thumb');
                            echo '</a>'; 
                        echo '</div>'; 
                    }
                    ?>
                    <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                        <?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        echo '<div class="featured-date">';
                            the_time('j F, Y');
                        echo '</div>';
                        if ( has_excerpt() ){
                            echo '<div class="entry-excerpt heading3">';                                   
                                echo wp_trim_words( get_the_excerpt(), 14, '...' );
                            echo '</div>';
                        }
                        ?>
                        <div class="blog-meta-info">
                            <div class="blog-author">
                                <?php
                                $byline = sprintf(
                                    esc_html_x( '%s', 'post author', 'udetor' ),
                                    '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
                                );  
                                echo '<div class="author-wap">';     
                                echo get_avatar( get_the_author_meta('email'), '30' ); 
                                echo $byline; 
                                echo '</div>';
                                ?>
                            </div>
                            <div class="blog-meta">
                                <?php
                                if(function_exists('the_views')) { 
                                    echo '<div class="meta-views">';
                                            echo '<i class="fa fa-eye"></i>';
                                            the_views();                        
                                    echo '</div>';
                                }
                                echo '<div class="comments-link">';
                                if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
                                        echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                                        comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );                        
                                        }
                                echo '</div>';
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
            }
        }
        elseif($style == 'course'){            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();   
                ?>
                <div class="blog-item">
                    <?php
                    if( has_post_thumbnail( ) ) {
                        echo '<div class="post-thumbnail">';
                            echo '<a href="' . esc_url( get_permalink() ) . '">';
                            the_post_thumbnail('udetor-blog-thumb');
                            echo '</a>'; 
                        echo '</div>'; 
                    }
                    ?>
                    <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                        <?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        echo Udetor_Helper::udetor_reviews_star(get_the_ID());
                        
                        ?>
                        <div class="blog-meta-info">
                            <div class="blog-author">
                                <?php
                                $byline = sprintf(
                                    esc_html_x( '%s', 'post author', 'udetor' ),
                                    '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
                                );  
                                echo '<div class="author-wap">';     
                                echo get_avatar( get_the_author_meta('email'), '30' ); 
                                echo $byline; 
                                echo '</div>';
                                ?>
                            </div>
                            <div class="blog-meta">
                                <?php
                                if(function_exists('the_views')) { 
                                    echo '<div class="meta-views">';
                                            echo '<i class="fa fa-eye"></i>';
                                            the_views();                        
                                    echo '</div>';
                                }
                                echo '<div class="comments-link">';
                                if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
                                        echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                                        comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );                        
                                        }
                                echo '</div>';
                                ?>
                            </div>
                            <div class="course-apply clear"> <a href="<?php echo esc_url( get_permalink() );?>"><span>Apply now</span></a></div>
                        </div>

                    </div>
                </div>

                <?php
            }
        }
        elseif($style == 'wave'){            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();
                $byline = sprintf(
                    esc_html_x( '%s', 'post author', 'udetor' ),'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span> . '
                );    
                ?>
                <div class="blog-item">
                    <?php
                    if( has_post_thumbnail( ) ) {
                        echo '<div class="post-thumbnail">';
                            echo '<a href="' . esc_url( get_permalink() ) . '">';
                            the_post_thumbnail('udetor-blog-thumb');
                            echo '</a>'; 
                        echo '</div>'; 
                    }
                    ?>
                    <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                        <?php 
                        echo '<div class="featured-date">';
                            echo $byline; 
                            the_time('j F, Y');
                        echo '</div>';
                        echo '<div class="wrap-text">';
                        the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        if ( has_excerpt() ){
                            echo '<div class="entry-excerpt heading3">';                                   
                                echo wp_trim_words( get_the_excerpt(), 14, '...' );
                            echo '</div>';
                        }
                        echo '</div>';
                        ?>
                    </div>
                </div>

                <?php
            }
        }elseif($style == 'multi-color'){
            while ( $the_query->have_posts() ) {
                $the_query->the_post();
                $byline = sprintf(
                    esc_html_x( '%s', 'post author', 'udetor' ),'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span> . '
                );  
            ?>
            <div class="blog-item">
                <?php
                if( has_post_thumbnail( ) ) {
                    echo '<div class="thumbnail">';
                        echo '<a href="' . esc_url( get_permalink() ) . '">';
                        the_post_thumbnail('udetor-blog-thumb');
                        echo '</a>'; 
                    echo '</div>'; 
                }
                ?>
                <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                    <?php 
                    echo '<div class="featured-date">';
                        echo $byline; 
                        the_time('j F, Y');
                    echo '</div>';
                    echo '<div class="wrap-text">';
                    the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                    echo '<a href="'.esc_url( get_permalink()).'" class="multi-btn"><span>'.esc_html__( 'Enjoy class','udetor' ).'</span></a>';
                    echo '</div>';
                    ?>
                </div>
            </div>
            <?php
            }
        }else{            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();                           
            ?>  
            <div class="blog-item">
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>       
                    <div class="entry-content">
                            <?php
                            if( has_post_thumbnail( ) ) {
                                echo '<div class="post-thumbnail">';
                                    echo '<a href="' . esc_url( get_permalink() ) . '">';
                                    the_post_thumbnail('udetor-blog-thumb');
                                    echo '</a>';                                
                                ?>
                                <ul class="post-meta">
                                    <li class="meta-reading-time">
                                    <?php
                                        if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
                                        echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                                        comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );                        
                                        }
                                    ?>
                                    </li>
                                    <?php if(function_exists('the_views')) { 
                                    echo '<li class="meta-views">';
                                        echo '<i class="fa fa-eye"></i>';
                                        the_views();                        
                                    echo '</li>';
                                    }
                                    ?>
                                    
                                <?php
                                echo '</div>';
                            }
                            ?>
                            <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                                <?php
                                if ( 'post' === get_post_type() ) : ?>
                                    <div class="entry-meta post-meta heading3">
                                        <?php Udetor_Template_Tags::udetor_posted_meta(); ?>
                                    </div>
                                <?php
                                endif;                                
                                the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );                                
                                if ( has_excerpt() ){
                                    echo '<div class="entry-excerpt heading3">';                                   
                                        echo wp_trim_words( get_the_excerpt(), 30, '...' );
                                    echo '</div>';
                                }
                                ?>
                                <a href="<?php the_permalink(); ?>" class="read-more secondary_btn"><span><?php echo esc_html__( 'Read more','udetor' ); ?></span></a>
                            </div>                           
                        </div>
                    </article>
                </div>
                <?php
            }
            
        }

        echo '</div>';
        if($style == 'grid' || $style == 'wave'){
            if($cat_slug && $cat_slug !=''){
                // Get the URL of this category
                $cat = get_category_by_slug($cat_slug); 
                $catID = $cat->term_id;
                $category_link = get_category_link( $catID );
                echo '<div class="netbase-toolkit list-post-grid-btn">';
                echo '<a href="'.esc_url( $category_link ).' " title="Category Name" class="browse_btn">'. $text_link .'</a>';
                echo '</div>';
            }
        }
        

        wp_reset_postdata();

		return ob_get_clean();
	}
}
