<?php
class NB_List_Posts_Element {

	public function options() {

		

		$options = array(
			"name" => __( "List Posts", "nb_element" ),
			"base" => "netbase_list_post",
			"class" => "",
			"category" => __( "Udetor", "nb_element"),
			'id' => 'netbase_list_post',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Title', 'udetor' ),
                    'param_name'  => 'title',
                    'value'       => '',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Number Course display', 'udetor' ),
                    'param_name'  => 'number_posts',
                    'std'         => '3',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',
                        esc_html__( '5', 'udetor' )      => '5',
                        esc_html__( '6', 'udetor' )      => '6',
                        esc_html__( '7', 'udetor' )      => '7',
                        esc_html__( '8', 'udetor' )      => '8',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),
                
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Colunms Number', 'udetor' ),
                    'param_name'  => 'colunms_posts',
                    'std'         => '3',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',                        
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Item Grid Style", 'udetor' ),
                   "param_name"         => "item_grid_style",                   
                   'value'              => array(                            
                       __( 'Default', 'udetor' )      => 'default',
                       __( 'Style 1', 'udetor' )        => 'style-1',
                       __( 'Style 2', 'udetor' )       => 'style-2'                       
                   ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text View All', 'udetor' ),
                    'param_name'  => 'text_link',
                    'std'         => esc_html__( 'View All', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),                
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
				
				


			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		$html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'        => '',                    
                    'number_posts' => '3',
                    'text_link'    => '',
                    'colunms_posts'    =>'3',
                    'item_grid_style' => '',
                ),
                $atts
            )
        );

        if($item_grid_style != ''){
           $grid_style = $item_grid_style;
        }else{
           $grid_style = 'default';
        }

        
        $e_params = array('col' => $colunms_posts, 'grid' => $grid_style);

        ob_start();
        // Generate HTML code.        

        $popular = new WP_Query( 
            array(
                'post_type' => 'sfwd-courses',
                'ignore_sticky_posts' => 1, 
                'posts_per_page' => $number_posts, 
                'post_status' => 'publish', 
                'orderby' => 'meta_value_num',  
                'order' => 'desc',
            'meta_key' => 'featured',
            'meta_value' => '1',));
        
        while ($popular->have_posts()) : $popular->the_post();                 
                             
             Netbase_Toolkit::netbase_toolkit_template('list-course.php', $e_params, true);
                
        endwhile;
        wp_reset_query();

        // Generate HTML code.
        $html .= '<div class="netbase-toolkit featured-courses row">' . ob_get_clean() . '</div>';
        wp_reset_postdata();

        return apply_filters('netbase_shortcode_featured_courses', force_balance_tags($html));
	}
}
