<?php
class NB_Countdown_Element {

	public function options() {		

		$options = array(
			"name" => __( "Countdown Box", "nb_element" ),
			"base" => "netbase_countdown",
			"class" => "",
			"category" => __( "Udetor", "nb_element"),
			'id' => 'netbase_countdown',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Text Days', 'udetor' ),
                    'param_name'  => 'text_days',
                    'value' => 'days',
                    'description'=> '',
                ),

                array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Text Hours', 'udetor' ),
                    'param_name'  => 'text_hours',
                    'value' => 'hours',
                    'description'=> '',
                    
                ),

                array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Text Minutes', 'udetor' ),
                    'param_name'  => 'text_minutes',
                    'value' => 'minutes',
                    'description'=> '',
                    
                ),

                array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Text Seconds', 'udetor' ),
                    'param_name'  => 'text_seconds',
                    'value' => 'seconds',
                    'description'=> '',
                    
                ),

                array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Year', 'udetor' ),
                    'param_name'  => 'time_year',
                    'description'=> '',
                    'value' => '',
                ),

                array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Month', 'udetor' ),
                    'param_name'  => 'time_month',
                    'description'=> '',
                    'value' => '',
                ),

                array(
                    'type'        => 'textfield',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Day', 'udetor' ),
                    'param_name'  => 'time_day',
                    'description'=> '',
                    'value' => '',
                ),                

                array(
                    'type' => 'dropdown',
                    'holder' => 'div',
                    
                    'heading' => __( 'Style color', 'udetor' ),
                    'param_name' => 'style_color',
                    /*'value' => array_merge( getVcShared( 'colors' ) ),*/
                    'description' => __( 'Select style color.', 'udetor' ),                  
                    'value' => '',
                    
                ),
                
                array(
                    'type'        => 'dropdown',
                    'holder' => 'div',
					
                    'heading'     => esc_html__( 'Text alignment', 'udetor' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' )         => '',
                        esc_html__( 'Text at left', 'udetor' )   => 'text-left',
                        esc_html__( 'Text at center', 'udetor' ) => 'text-center',
                        esc_html__( 'Text at right', 'udetor' )  => 'text-right',
                    ),
                    'description'=> '',
                    
                ),

                array(
                    'type'       => 'textfield',
                    'holder' => 'div',
                    
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'value' => '',
                    
                ),
                array(
                    'type'       => 'textfield',
                    'holder' => 'div',
                    
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'description'=> '',
                    'value' => '',
                    
                ),
                
                array(
                    'type' => 'dropdown',
                    'holder' => 'div',
                    
                    'heading' => __( 'Style Countdown', 'udetor' ),
                    'param_name' => 'style_countdown',
                    'description'=> 'Change style count down',
                    'value' => array(
                        'default' => 'default',
                        'square' => 'square',
                    ),
                ),

                


			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		
		extract( shortcode_atts( array(
					'text_days'    => 'days',
                    'text_hours'   => 'hours',
                    'text_minutes' => 'minutes',
                    'text_seconds' => 'seconds',
                    'time_year'    => '',
                    'time_month'   => '',
                    'time_day'     => '',                   
                    'style_color'  => '',
                    'text_align'   => '',   
                    'style_countdown' =>'default',  
            
		), $atts ) );

		$classes = array();
        if($style_color){
            $classes[] =' countdown-'.$style_color.' ';
        }

        $text_days    = ( isset( $text_days ) && '' != $text_days ) ? $text_days : 'days';
        $text_hours   = ( isset( $text_hours ) && '' != $text_hours ) ? $text_hours : 'hours';
        $text_minutes = ( isset( $text_minutes ) && '' != $text_minutes ) ? $text_minutes : 'minutes';
        $text_seconds = ( isset( $text_seconds ) && '' != $text_seconds ) ? $text_seconds : 'seconds';
  
        $year = ( (int) ( $time_year ) != '' ) ? (int) ( $time_year ) : date( "Y", time() );
        $month = ( (int) ( $time_month ) != '' ) ? (int) ( $time_month ) : date( "m", time() );
        $day = ( (int) ( $time_day ) != '' ) ? (int) ( $time_day ) : date( "d", time() );
      
        /*if ( $time_hour != '' ) {
            $hour = ( (int) ( $time_hour ) != '' ) ? (int) ( $time_hour ) : date( "G", time() );
        }*/

        // Generate HTML code.
        $datetime = date( ent2ncr($year. '/'. $month  .'/' . $day  ));

		
        $html = '';
		$html .= '<div class="netbase-toolkit countdown-box '. esc_attr( implode( ' ', $classes ) ) .' '.esc_html($style_countdown).'">';        
            $html .= '<div class="education-event-time-countdown">';
            //$start_date = $datetime->start_date('Y/m/d'); 
            $html .= '<div data-countdown="'.$datetime.'" class="education-time-countdown">';
            $html .= '<div class="education-days font-h1"><span></span>'.$text_days.'</div>';
            $html .= '<div class="education-hours font-h1"><span></span>'.$text_hours.'</div>';
            $html .= '<div class="education-mins font-h1"><span></span>'.$text_minutes.'</div>';
            $html .= '<div class="education-secs font-h1"><span></span>'.$text_seconds.'</div>';
            $html .= '</div>';
            $html .= '</div>';
        $html .= '</div><!-- .netbase-toolkit -->';

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_countdown', force_balance_tags($html));
	}
}
