<?php
if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_course-category',
		'title' => 'course category',
		'fields' => array (
			array (
				'key' => 'field_59c21db470183',
				'label' => esc_html__('Udetor course category thumb', 'udetor'),
				'name' => 'course_cat_thumb',
				'type' => 'image',
				'save_format' => 'object',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'ef_taxonomy',
					'operator' => '==',
					'value' => 'course_category',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'no_box',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_course-settings',
		'title' => 'Course Settings',
		'fields' => array (
			array (
				'key' => 'field_596066419d3a4',
				'label' => esc_html__('Course', 'udetor'),
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_596066579d3a5',
				'label' => esc_html__('Goals - Prerequisites', 'udetor'),
				'name' => 'goals_prerequisites',
				'type' => 'wysiwyg',
				'instructions' => esc_html__('Does your course have any prerequisites?', 'udetor'),
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_5960666c9d3a6',
				'label' => esc_html__('Goals - Target student', 'udetor'),
				'name' => 'goals_target_student',
				'type' => 'wysiwyg',
				'instructions' => esc_html__('Who is your target student?', 'udetor'),
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_596066819d3a7',
				'label' => esc_html__('Goals - Will Learn', 'udetor'),
				'name' => 'goals_will_learn',
				'type' => 'wysiwyg',
				'instructions' => esc_html__('What will they learn? At the end of your course, students will be able to...', 'udetor'),
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			/*array (
				'key' => 'field_596066959d3a8',
				'label' => esc_html__('Promotion Image', 'udetor'),
				'name' => 'promotion_image',
				'type' => 'image',
				'save_format' => 'object',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),*/
			array (
				'key' => 'udetor_video_type_field',
				'label' => esc_html__('Promotion video Type', 'udetor'),
				'name' => 'promotion_video_type',
				'type' => 'select',
				'instructions' => esc_html__('Select the Promotion video Type.', 'udetor'),
				'choices' => array (
					'youtube' => 'Youtube',
					'vimeo' => 'Vimeo',
					
				),
				'default_value' => 'youtube',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_596066a19d3a9',
				'label' => esc_html__('Promotion Video', 'udetor'),
				'name' => 'promotion_video',
				'type' => 'text',
				'instructions' => esc_html__('ID Video Promotion (Example:ID vimeo: 259245389 , youtube: CcoUY4Q-OAI)', 'udetor'),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_596066b39d3aa',
				'label' => esc_html__('Maximum students', 'udetor'),
				'name' => 'maximum_students',
				'type' => 'number',
				'instructions' => esc_html__('Maximum number of students who can enroll in this course.
	', 'udetor'),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_596066c79d3ab',
				'label' => esc_html__('Re-take course', 'udetor'),
				'name' => 're_take_course',
				'type' => 'number',
				'instructions' => esc_html__('How many times the user can re-take this course. Set to 0 to disable.
	', 'udetor'),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_596066e09d3ac',
				'label' => esc_html__('Block Lessons Content', 'udetor'),
				'name' => 'block_lessons_content',
				'type' => 'true_false',
				'instructions' => esc_html__('Block lessons content when course is expired.
	', 'udetor'),
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_596067079d3ae',
				'label' => esc_html__('Skill Level', 'udetor'),
				'name' => 'course_skill_lever',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_596067209d3af',
				'label' => esc_html__('Featured', 'udetor'),
				'name' => 'featured',
				'type' => 'true_false',
				'instructions' => esc_html__('Set course as featured.', 'udetor'),
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_59632238f4ae5',
				'label' => esc_html__('Date Start', 'udetor'),
				'name' => '_courses_date_start',
				'type' => 'date_picker',
				'instructions' => esc_html__('Date Start', 'udetor'),
				'date_format' => 'dd/mm/yy',
				'display_format' => 'dd/mm/yy',
				'first_day' => 1,
			),
			array (
				'key' => 'field_596325a1f4ae6',
				'label' => esc_html__('Date End', 'udetor'),
				'name' => '_courses_date_end',
				'type' => 'date_picker',
				'date_format' => 'dd/mm/yy',
				'display_format' => 'dd/mm/yy',
				'first_day' => 1,
			),
			array (
				'key' => 'field_59633664f7e08',
				'label' => esc_html__('Language', 'udetor'),
				'name' => '_courses_lang',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_edu_ages300718',
				'label' => esc_html__('Enrolment ages', 'udetor'),
				'name' => '_enrolment_ages',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'sfwd-courses',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_page-settings',
		'title' => 'Page Settings',
		'fields' => array (
			array (
				'key' => 'field_59604fa4da2a6',
				'label' => esc_html__('General', 'udetor'),
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_59604feada2a7',
				'label' => esc_html__('Site Layout', 'udetor'),
				'name' => 'site_layout',
				'type' => 'select',
				'instructions' => esc_html__('Select the layout for your site. This option should only be used in very specific cases such as landing.', 'udetor'),
				'choices' => array (
					'default' => 'Default',
					'full-width' => 'Full-width',
					'boxed' => 'Boxed',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_596053b087500',
				'label' => esc_html__('Sidebar Layout', 'udetor'),
				'name' => 'sidebar_layout',
				'type' => 'select',
				'instructions' => esc_html__('Select your custom layout for this page content.', 'udetor'),
				'choices' => array (
					'default' => 'Default',
					'full-screen' => 'Full Screen',
					'left-sidebar' => 'Sidebar Left',
					'right-sidebar' => 'Sidebar Right',
					'no-sidebar' => 'No Sidebar',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5960574f87501',
				'label' => esc_html__('Sidebar', 'udetor'),
				'name' => 'sidebar',
				'type' => 'sidebar_selector',
				'instructions' => esc_html__('Select your a custom sidebar for this page.', 'udetor'),
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_596053b087500',
							'operator' => '!=',
							'value' => 'no-sidebar',
						),
					),
					'allorany' => 'all',
				),
				'allow_null' => 1,
				'default_value' => '',
			),
			array (
				'key' => 'field_5960582887504',
				'label' => esc_html__('Hidden Breadcrumbs', 'udetor'),
				'name' => 'custom_breadcrumbs_page_hidden',
				'type' => 'true_false',
				'instructions' => esc_html__('Hidden this element on this page.', 'udetor'),
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_59db4da9a66fb',
				'label' => esc_html__('Hidden Page Title', 'udetor'),
				'name' => 'custom_page_title_hidden',
				'type' => 'true_false',
				'instructions' => esc_html__('Hidden this element on this page.', 'udetor'),
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_59db4e8da66fc',
				'label' => esc_html__('Page Title Position', 'udetor'),
				'name' => 'custom_page_title_position',
				'type' => 'select',
				'instructions' => esc_html__('Enable or disable this element on this page.', 'udetor'),
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_59db4da9a66fb',
							'operator' => '!=',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'default' => 'Default',
					'left' => 'Left',
					'center' => 'Center',
					'right' => 'Right',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_59db4ecca66fd',
				'label' => esc_html__('Background Image Page Title', 'udetor'),
				'name' => 'custom_bg_image_page_title',
				'type' => 'image',
				'save_format' => 'object',
				'preview_size' => 'full',
				'library' => 'all',
			),
			array (
				'key' => 'field_5960585687505',
				'label' => esc_html__('Social Share', 'udetor'),
				'name' => 'social_share',
				'type' => 'select',
				'instructions' => esc_html__('Enable or disable this element on this page.', 'udetor'),
				'choices' => array (
					'default' => 'Default',
					'enable' => 'Enable',
					'disable' => 'Disable',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'udetor_meta_field_custom_page_image',
				'label' => esc_html__('Page Background Image', 'udetor'),
				'name' => 'custom_bg_page_image',
				'type' => 'image',
				'save_format' => 'object',
				'preview_size' => 'full',
				'library' => 'all',
			),
			array (
				'key' => 'udetor_meta_field_footer_bg_image',
				'label' => esc_html__('Footer Background Image', 'udetor'),
				'name' => 'custom_bg_footer_image',
				'type' => 'image',
				'save_format' => 'object',
				'preview_size' => 'full',
				'library' => 'all',
			),
			array (
				'key' => 'field_ph_transparent',
				'label' => esc_html__('Header transparent', 'udetor'),
				'name' => 'custom_page_header_trans',
				'type' => 'true_false',
				'message' => '',
				'default_value' => 0,
			),
			/*array (
				'key' => 'field_59dd9069cfb4e',
				'label' => esc_html__('Change Default Page Header ', 'udetor'),
				'name' => 'custom_change_page_header',
				'type' => 'true_false',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_59dd8deb7698a',
				'label' => esc_html__('Select Page Header', 'udetor'),
				'name' => 'custom_page_header',
				'type' => 'page_link',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_59dd9069cfb4e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'post_type' => array (
					0 => 'page_header',
				),
				'allow_null' => 0,
				'multiple' => 0,
			),*/

			array (
				'key' => 'field_footer_col108',
				'label' => esc_html__('Custom Footer Main Column 1', 'udetor'),
				'name' => 'page_custom_footer_main_col1',
				'type' => 'sidebar_selector',
				'instructions' => esc_html__('Select your a custom sidebar for this page.', 'udetor'),
				/*'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_596053b087500',
							'operator' => '!=',
							'value' => 'no-sidebar',
						),
					),
					'allorany' => 'all',
				),*/
				'allow_null' => 1,
				'default_value' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));

	/*event*/

	register_field_group(array (
		'id' => 'acf_event-option',
		'title' => 'Event option',
		'fields' => array (
			array (
				'key' => 'field_event_5ba1f5572e855',
				'label' => 'People',
				'name' => 'udetor_event_people',
				'type' => 'user',
				'role' => array (
					0 => 'all',
				),
				'field_type' => 'multi_select',
				'allow_null' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'espresso_events',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'no_box',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));


}
