<?php
/**
 * @version    1.0.1
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Shortcodes {
	/**
	 * Initialize.
	 *
	 * @return  void
	 */
	public static function initialize() {

		// Enqueue script
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );

		add_shortcode('display_search_form', array(__CLASS__, 'udetor_display_search_form'));

		/* Load Visual Composer Element */
		Netbase_Toolkit_Element_HLogo::initialize();
        Netbase_Toolkit_Element_HText::initialize();
        Netbase_Toolkit_Element_HSocials::initialize();
        Netbase_Toolkit_Element_HSidebar::initialize();
        Netbase_Toolkit_Element_HMenu::initialize();
        Netbase_Toolkit_Element_HSearch::initialize();
//        Netbase_Toolkit_Element_List_Posts::initialize();
        //Netbase_Toolkit_Element_Heading::initialize();
        //Netbase_Toolkit_Element_Upcoming_Events::initialize();        
        //Netbase_Toolkit_Element_Testimonials::initialize();
/*        Netbase_Toolkit_Element_Countdown::initialize();*/
        //Netbase_Toolkit_Element_Our_Team::initialize();
        //Netbase_Toolkit_Element_Counters_Box::initialize();        
        //Netbase_Toolkit_Element_Pricing_Table::initialize();
        //Netbase_Toolkit_Element_Services::initialize();
        //Netbase_Toolkit_Element_Video::initialize();
        //Netbase_Toolkit_Element_Posts_Gallery::initialize();
        //Netbase_Toolkit_Element_Custom_Nav::initialize();
        //Netbase_Toolkit_Element_Search_Form_Icon::initialize();
        //Netbase_Toolkit_Element_Vc_Comments::initialize();
        //Netbase_Toolkit_Element_Vc_Mini_Cart::initialize();        
        /*Netbase_Toolkit_Element_Vc_Images_Gallery::initialize();*/
        Netbase_Toolkit_Element_Vc_Bmi_Calculator::initialize();
        //Netbase_Toolkit_Element_Vc_Banner::initialize();
        if(is_plugin_active( 'sfwd-lms/sfwd_lms.php' )){
        	Netbase_Toolkit_Element_Popular_Courses::initialize();	
        	Netbase_Toolkit_Element_Course_Category_Carousel::initialize();
        	Netbase_Toolkit_Element_Content_Tabs::initialize();
        	Netbase_Toolkit_Element_Featured_Courses::initialize();
        }
        
	}

	public static function udetor_display_search_form() {
        return get_search_form(false);
    }


	/**
	 * Enqueue scripts and styles.
	 *
	 * @return  void
	 */
	public static function enqueue_scripts() {
		if ( is_singular() ) {
			global $post;

			if ( isset( $post->post_content ) && has_shortcode( $post->post_content, 'netbase_toolkit' ) ) {
				// Isotope
				/*wp_enqueue_script( 'isotope', NETBASE_TOOLKIT_URL . 'assets/vendors/nivo-lightbox/nivo-lightbox.min.js', array(), false, true );*/

				// Nivo lightbox
				/*wp_enqueue_script( 'nivo-lightbox', NETBASE_TOOLKIT_URL . 'assets/vendors/nivo-lightbox/nivo-lightbox.min.js', array(), false, true );
				wp_enqueue_style( 'nivo-lightbox', NETBASE_TOOLKIT_URL . 'assets/vendors/nivo-lightbox/nivo-lightbox.css' );*/

				// Owl carousel
				/*wp_enqueue_script( 'owl-carousel', NETBASE_TOOLKIT_URL . 'assets/vendors/owl-carousel/owl.carousel.min.js', array(), false, true );
				wp_enqueue_style( 'owl-carousel', NETBASE_TOOLKIT_URL . 'assets/vendors/owl-carousel/owl.carousel.min.css' );*/

			}
		}
		wp_enqueue_style('edu-element', NETBASE_TOOLKIT_URL . 'assets/css/edu.css');
		wp_enqueue_style('edu-element-custom', NETBASE_TOOLKIT_URL . 'assets/css/custom.css');
		wp_enqueue_style('font-icomoon', NETBASE_TOOLKIT_URL. 'assets/vendors/icomoon/style.css');
		if (is_rtl()) {
			wp_enqueue_style('edu-rtl', NETBASE_TOOLKIT_URL . 'assets/css/edu-rtl.css');
		}
	}
}
