<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Video
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('netbase_video', array(__CLASS__, 'shortcode_video'));
    }
   
    public static function map()
    {
        vc_map(array(
            'name' => esc_html__('Udetor: Video', 'udetor'),
            'base' => 'netbase_video',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display video.', 'udetor'),
            'icon' => 'udetor-widget-icon udetor-widget-icon-our-team',
            'params' => array(
                array(
                        'param_name'  => 'source',
                        'heading'     => esc_html__( 'Video Source', 'udetor' ),
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'value'       => array(
                            __( 'Youtube', 'udetor' ) => 'youtube',
                            __( 'Vimeo', 'udetor' )   => 'vimeo',
                        ),
                    ),
                    array(
                        'param_name' => 'url',
                        'heading'    => esc_html__( 'Link To Video', 'udetor' ),
                        'type'       => 'textfield',
                    ),
                    array(
                        'param_name' => 'style',
                        'heading'    => esc_html__( 'Style', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Video Screen Preview', 'udetor' ) => 'screen',
                            __( 'Player Icon', 'udetor' )          => 'icon',
                            __( 'Image Thumbnail', 'udetor' )      => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_color',
                        'heading'    => esc_html__( 'Icon Color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#2d2d2d2',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => array( 'image', 'icon' ),
                        ),
                    ),
                    array(
                        'param_name'  => 'width',
                        'heading'     => esc_html__( 'Video Width (number only)', 'udetor' ),
                        'description' => esc_html__( 'This parameter is not work on video popup', 'udetor' ),
                        'type'        => 'textfield',
                        'value'       => 500,
                    ),
                    array(
                        'param_name' => 'graphic',
                        'heading'    => esc_html__( 'Upload image', 'udetor' ),
                        'type'       => 'attach_image',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),
                   /* array(
                        'param_name' => 'align',
                        'heading'    => esc_html__( 'Video Align', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Left', 'udetor' )   => 'tl',
                            __( 'Center', 'udetor' ) => 'tc',
                            __( 'Right', 'udetor' )  => 'tr',
                        ),
                    ),*/
                    array(
                        'param_name' => 'shadow',
                        'heading'    => esc_html__( 'Shadow', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'None', 'udetor' )    => '',
                            __( 'Style 1', 'udetor' ) => '1',
                            __( 'Style 2', 'udetor' ) => '2',
                            __( 'Style 3', 'udetor' ) => '3',
                            __( 'Style 4', 'udetor' ) => '4',
                            __( 'Style 5', 'udetor' ) => '5',
                            __( 'Style 6', 'udetor' ) => '6',
                            __( 'Style 7', 'udetor' ) => '7',
                            __( 'Style 8', 'udetor' ) => '8',
                            __( 'Style 9', 'udetor' ) => '9',
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => array( 'image' )
                        ),
                    ),
                    /*array(
                        'param_name' => 'popup',
                        'heading'    => esc_html__( 'Play in popup?', 'udetor' ),
                        'type'       => 'checkbox',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),*/
                    array(
                        'param_name' => 'disable_icon_play',
                        'heading'    => esc_html__( 'Disable Icon Play?', 'udetor' ),
                        'type'       => 'checkbox',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'control',
                        'heading'    => esc_html__( 'Enable Control', 'udetor' ),
                        'type'       => 'checkbox',
                        'dependency' => array(
                            'element' => 'source',
                            'value'   => 'youtube',
                        ),
                    ),
                    array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'udetor' ),
                        'type'       => 'checkbox',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => array( 'screen' ),
                        ),
                    ),
                    array(
                        'param_name'  => 'extra_class',
                        'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                        'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                        'type'        => 'textfield',
                    ),
                    array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'editor_css',
                    'group' => __( 'Design options', 'udetor' ),
                    ),                    
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_video($atts, $content = null)
    {
       $html = $id = $frame_style = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'source'          => 'youtube',
                    'url'             => '',
                    'style'           => 'screen',
                    'icon_color'      => '#2d2d2d',
                    'width'           => 500,
                    'graphic'         => '',
                    /*'align'           => '',*/
                    'shadow'          => '',
                    /*'popup'           => '',*/
                    'disable_icon_play' => '',
                    'control'         => '',
                    'autoplay'        => '',
                    'extra_class'     => '',
                    'editor_css' => '',
                    
                ),
                $atts
            )
        );

        // Generate custom ID
        $idbox = uniqid('netbase_toolkit_video_');
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $editor_css, ' ' ), 'netbase_video', $atts ); 
        }
        $classes = array( 'sc-video' );

        if ( $extra_class ) {
            $classes[] = $extra_class;
        }

        /*if ( $align ) {
            $classes[] = $align;
        }*/

        if ( ! empty( $shadow ) ) {
            $classes[] = 'shadow-' . $shadow;
        }

        if ( $style == 'screen' ) {
            $frame_style = 'style="max-width:' . esc_attr( $width ) . 'px";';
        }
        // Generate HTML code.        
        
        $html .= '<div id="' . esc_attr($idbox) . '" class="netbase-toolkit ' . esc_attr( implode( ' ', $classes ) ) . ' '.esc_attr( $css_class ).'" ' . $frame_style . '>';

            if ( $source == 'youtube' ) {
                $url = explode( 'v=', $url );
                if ( isset( $url[1] ) ) {
                    $url = explode( '&', $url[1] );
                    $id = $url[0];
                    if ( ! $id ) {
                        $url = explode( '/', $url );
                        $id = $url[ count( $url ) - 1 ];
                    }
                }

                if ( $id ) {
                    if ( $style == 'screen' ) {
                        $html .= '<div class="fluid-iframe pr">';
                            $html .= '<iframe class="pa" type="text/html" width="' . esc_attr( $width ) . '" height="' . intval( $width / 1.777 ) . '" src="https://www.youtube.com/embed/' . $id . '?rel=0' . ( $control ? '&controls=1' : '&controls=0' ) . ( $autoplay ? '&autoplay=1' : '' ) . '" frameborder="0"/>';
                        $html .= '</div>';
                    } elseif ( $style == 'icon' ) {
                        $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup" href="https://www.youtube.com/watch?v=' . $id . '">';
                            $html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                                $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                                $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                            $html .= '</svg>';
                        $html .= '</a>';
                    } else {
                        if ( ! empty( $graphic ) ) {
                            $image_id = preg_replace( '/[^\d]/', '', $graphic );
                            $image    = wp_get_attachment_image_src( $image_id, 'full' );

                            $html .= '<div class="sc-video-thumb dib pr">';                                
                                    $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup pr" href="https://www.youtube.com/watch?v=' . $id . '">';
                                        $html .= '<img  src="' . esc_url( $image[0] ) . '" width="' . esc_attr( $width ) . '" height="' . esc_attr( $image[2] ) . '" alt="Video Thumbnail" />';
                                        if(isset($disable_icon_play) && $disable_icon_play){

                                        }else{
                                           $html .= '<svg class="pa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                                            $html .= '</svg>'; 
                                        }
                                        
                                    $html .= '</a>';
                                
                            $html .= '</div>';
                        }
                    }
                }
            } elseif ( $source == 'vimeo' ) {
                if ( $url ) {
                    $id = (int) substr( parse_url( $url, PHP_URL_PATH ), 1 );
                }
                if ( $id ) {
                    if ( $style == 'screen' ) {
                        $html .= '<div class="fluid-iframe pr">';
                            $html .= '<iframe class="pa" src="//player.vimeo.com/video/' . $id . '?rel=0' . ( $autoplay ? '&autoplay=1' : '' ) . '" width="' . esc_attr( $width ) . '" height="' . intval( $width / 1.777 ) . '" frameborder="0"></iframe>';
                        $html .= '</div>';
                    } elseif ( $style == 'icon' ) {
                        $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup" href="https://www.vimeo.com/' . $id . '">';
                            $html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                                $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                                $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                            $html .= '</svg>';
                        $html .= '</a>';
                    } else {
                        if ( ! empty( $graphic ) ) {
                            $image_id = preg_replace( '/[^\d]/', '', $graphic );
                            $image    = wp_get_attachment_image_src( $image_id, 'full' );
                            $html .= '<div class="sc-video-thumb dib ">';
                                
                                    $html .= '<a data-popup=\'{"control":"' . ( $control ? 'true' : 'false' ) . '"}\' class="sc-video-popup pr" href="https://www.vimeo.com/' . $id . '">';
                                        $html .= '<img src="' . esc_url( $image[0] ) . '" width="' . esc_attr( $width ) . '" height="' . esc_attr( $image[2] ) . '" alt="Video Thumbnail" />';
                                        if(isset($disable_icon_play) && $disable_icon_play){

                                        }else{
                                        $html .= '<svg class="pa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="64px" height="64px" viewBox="0 0 16 16">';
                                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
                                            $html .= '<path fill="' . esc_attr( $icon_color ) . '" d="M6 4v8l6-4z"/>';
                                        $html .= '</svg>';
                                        }
                                    $html .= '</a>';
                                
                            $html .= '</div>';
                        }
                    }
                }
            }

        $html .= '</div>';
        return apply_filters('netbase_shortcode_video', force_balance_tags($html));
    }   
}
