<?php

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_Vc_Mini_Cart
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('nbtoolkit_vc_mini_cart', array(__CLASS__, 'shortcode_vc_mini_cart'));        
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map()
    {
        vc_map(array(
            'name' => esc_html__('Udetor: Mini Cart', 'netbase-toolkit'),
            'base' => 'nbtoolkit_vc_mini_cart',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Mini cart.', 'netbase-toolkit'),
            'icon' => 'icon-wpb-woocommerce',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'netbase-toolkit'),
                    'param_name' => 'title_text',
                    'value' => '',
                ),

               array(
                        'param_name'       => 'style',
                        'heading'          => esc_html__( 'Style', 'netbase-toolkit' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6 mgt15',                        
                        'value'            => array(                            
                            __( 'Icon', 'netbase-toolkit' )      => 'icon',
                            __( 'Image', 'netbase-toolkit' )     => 'image',
                        ),
                ),
                array(
                        'param_name'       => 'align',
                        'heading'          => esc_html__( 'Box Alignment', 'netbase-toolkit' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6',                        
                        'value'            => array(
                            __( 'Left', 'netbase-toolkit' )   => 'left',
                            __( 'Center', 'netbase-toolkit' ) => 'center',
                            __( 'Right', 'netbase-toolkit' )  => 'right',
                        ),
                ),
                array(
                        'param_name' => 'content_box',
                        'heading'    => esc_html__( 'Content', 'netbase-toolkit' ),
                        'type'       => 'textarea',                        
                        'holder'     => 'p'
                ),
                array(
                        'param_name' => 'text_color',
                        'heading'    => esc_html__( 'Title Color', 'netbase-toolkit' ),
                        'type'       => 'colorpicker',
                        'edit_field_class' => 'vc_col-sm-6', 
                ),
                    array(
                        'param_name' => 'txtcontent_color',
                        'heading'    => esc_html__( 'Text Color', 'netbase-toolkit' ),
                        'type'       => 'colorpicker',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    
                    array(
                        'param_name' => 'hide_cart_subtotal',
                        'heading'    => esc_html__( 'Hide Cart Subtotal', 'netbase-toolkit' ),
                        'type'       => 'checkbox',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    array(
                        'param_name' => 'read_more',
                        'heading'    => esc_html__( 'Enable Read More?', 'netbase-toolkit' ),
                        'type'       => 'checkbox',
                        
                    ),
                    array(
                        'param_name' => 'read_more_link',
                        'heading'    => esc_html__( 'Read more link', 'netbase-toolkit' ),
                        'type'       => 'textfield',                        
                        'dependency' => array(
                            'element' => 'read_more',
                            'value'   => 'true',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_position',
                        'heading'    => esc_html__( 'Icon Position', 'netbase-toolkit' ),
                        'type'       => 'dropdown',                        
                        'value'      => array(
                            __( 'Top', 'netbase-toolkit' )   => 'top',
                            __( 'Left', 'netbase-toolkit' )  => 'left',                            
                        ),
                        
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                    ),
                   
                    array(
                        'param_name'  => 'icon_fontawesome',
                        'heading'     => esc_html__( 'Icon', 'netbase-toolkit' ),
                        'description' => esc_html__( 'Select icon from library.', 'netbase-toolkit' ),
                        'type'        => 'iconpicker',
                        'group'       => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'       => 'fa fa-adjust',
                        'settings'    => array(
                            'emptyIcon'    => false,
                            'iconsPerPage' => 4000,
                        ),
                        'dependency'  => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_color',
                        'heading'    => esc_html__( 'Icon color', 'netbase-toolkit' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'      => '#d6aa74',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    /*array(
                        'param_name' => 'bgicon_color',
                        'heading'    => esc_html__( 'Background Icon color', 'netbase-toolkit' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'      => '#fff',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),*/

                    array(
                        'param_name' => 'icon_style',
                        'heading'    => esc_html__( 'Icon Box Style', 'netbase-toolkit' ),
                        'type'       => 'dropdown',
                        'group'      => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'      => array(
                            esc_html__('Select', 'netbase-toolkit') => '',                        
                            esc_html__('Circle', 'netbase-toolkit') => 'circle',
                            esc_html__('Square', 'netbase-toolkit') => 'square',
                        
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                    ),
                    array(
                        'param_name' => 'icon_hover_color',
                        'heading'    => esc_html__( 'Icon Hover Color', 'netbase-toolkit' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_size',
                        'heading'    => esc_html__( 'Icon Size (px)', 'netbase-toolkit' ),
                        'type'       => 'textfield',
                        'group'      => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'      => 24,
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'graphic',
                        'heading'    => esc_html__( 'Upload Image', 'netbase-toolkit' ),
                        'type'       => 'attach_image',
                        'group'      => esc_html__( 'Image Settings', 'netbase-toolkit' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),
                array(
                        'param_name' => 'image_radius',
                        'heading'    => esc_html__( 'Border Radius (px)', 'netbase-toolkit' ),
                        'type'       => 'textfield',
                        'group'      => esc_html__( 'Image Settings', 'netbase-toolkit' ),
                        'value'      => 0,
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                ),
                
                array(
                    'heading'    => __( 'Extra class name', 'netbase-toolkit' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'netbase-toolkit' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'netbase-toolkit' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'netbase-toolkit' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_vc_mini_cart($atts, $content = null)
    {
        $html = $txtcolor = $class = $classtitle = $css= $txtcontentcolor = $eclass ='';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title_text' => '',
                    'style'                   => 'icon',
                    'align'                   => 'left',
                    'content_box'             => '',
                    'icon_position'           => 'top',
                    'text_color'              => '#333333',
                    'txtcontent_color'        => '',
                    /*'bgicon_color' => '',*/
                    'icon_style' => 'square',
                    'read_more'               => '',
                    'hide_cart_subtotal'      => '',
                    'read_more_link'          => '',
                    'icon_fontawesome'        => 'fa fa-adjust',
                    'icon_color'              => '#d6aa74',
                    'icon_hover_color'        => '',
                    'icon_size'               => 24,
                    'graphic'                 => '',
                    'image_radius'            => 0,
                    'extra_class' => '',
                ),
                $atts
            )
        );           
        
        if($align == 'center'){
            $class .='text-center';
        }elseif($align == 'left'){
            $class .='text-left';
        }else{
            $class .='text-right';
        }

        if($icon_position == 'left'){
            $class .=' icon-position-left';
        }

        if($hide_cart_subtotal){
            $class .=' hide-cart-sub';   
        }             

        if($extra_class){
            $eclass .=' '.$extra_class;   
        }
        
        if($icon_style == 'circle'){
            $class .=' svicon-circle';
        }

        if ( $icon_size != '' ) {
            $css .= 'font-size:' . ( is_numeric( trim( $icon_size ) ) ? trim( $icon_size ) . 'px' : trim( $icon_size ) ).';' ;
        }
        if($icon_color){
            $css .='color: ' . esc_attr( $icon_color ).';' ;
        }
        /*if($bgicon_color){
            $css .='background-color: ' . esc_attr( $bgicon_color ).';' ;
        }*/

        if ( $css ) {
            $css = ' style="' . $css . '"';
        }

        if($text_color){
            $txtcolor .='color:'. esc_attr($text_color ).';';
        }
        if($txtcolor){
            $txtcolor =' style="' . $txtcolor . '"';
        }

        
        if($txtcontent_color){
             $txtcontentcolor .='color:'. esc_attr($txtcontent_color ).';';
        }
        if($txtcontentcolor){
            $txtcontentcolor =' style="' . $txtcontentcolor . '"';
        }
        ob_start();        
        
        if ( class_exists( 'Woocommerce' ) ) {

        ?>
        <div id="site-header-cart" class="site-header-cart menu">
            <div class="<?php echo esc_attr( $class ); ?> nb-shopping-cart">
                <a class="cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'netbase-toolkit' ); ?>">                
                    <span class="amount"><?php echo wp_kses_data( WC()->cart->get_cart_subtotal() ); ?></span> 
                    <span class="count"><?php echo wp_kses_data( sprintf( _n( '%d', '%d ', WC()->cart->get_cart_contents_count(), 'netbase-toolkit' ), WC()->cart->get_cart_contents_count() ) );?></span>
                </a>
                <?php
                if ( 'icon' == $style ) {            
                        echo '<div class="nb-icon-font" '.$css.'><span class="' . esc_attr( $icon_fontawesome ) .'" ></span></div>';
                }else{
                    if ( ! empty( $graphic ) ) {
                        // Get image link and image data
                        $image = wpb_getImageBySize( array( 'attach_id' => preg_replace( '/[^\d]/', '', $graphic ) ) );

                        echo '<div class="image-icon"><img src="' . esc_url( $image['p_img_large'][0] ) . '" alt="' . esc_attr__( 'Separator', 'netbase-toolkit' ) . '" width="' . esc_attr( $image['p_img_large'][1] ) . '" height="' . esc_attr( $image['p_img_large'][2] ) . '" /></div>';
                    }
                }
                ?>
                </div>
                <?php //the_widget( 'WC_Widget_Cart', 'title=' ); ?>
                <div class="widget_shopping_cart_content text-left"></div>
            
        </div>
        <?php
        }
        
        $html .= '<div class="netbase-toolkit-mini-cart '.esc_attr( $eclass ).'">' . ob_get_clean() . '</div>';

        wp_reset_postdata();

        return apply_filters('nb_shortcode_vc_mini_cart', force_balance_tags($html));
    }

}
