<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_Vc_Images_Gallery
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('nbtoolkit_vc_images_gallery', array(__CLASS__, 'shortcode_vc_images_gallery'));
        
    }    
     
    // Element Mapping
    public static function map() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'Udetor: Images Gallery', 'netbase-toolkit' ),
            'base'        => 'nbtoolkit_vc_images_gallery',
            'icon' => 'icon-wpb-single-image',
            'category' => esc_html__('Udetor Elements', 'netbase-toolkit'),
            'description' => esc_html__( 'Display Logo.', 'netbase-toolkit' ),

            'params'      => array(
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Widget title', 'netbase-toolkit' ),
                    'param_name' => 'title',
                    'description' => __( 'Enter text used as widget title (Note: located above content element).', 'netbase-toolkit' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Gallery type', 'netbase-toolkit' ),
                    'param_name' => 'type',
                    'value' => array(
                        __( 'Flex slider fade', 'netbase-toolkit' ) => 'flexslider_fade',
                        __( 'Flex slider slide', 'netbase-toolkit' ) => 'flexslider_slide',                        
                        __( 'Image grid', 'netbase-toolkit' ) => 'image_grid',
                    ),
                    'description' => __( 'Select gallery type.', 'netbase-toolkit' ),
                ),
                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns', 'netbase-toolkit' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'netbase-toolkit' )  => '1',
                            __( '2 columns', 'netbase-toolkit' ) => '2',
                            __( '3 columns', 'netbase-toolkit' ) => '3',
                            __( '4 columns', 'netbase-toolkit' ) => '4',
                            __( '5 columns', 'netbase-toolkit' ) => '5',
                            __( '6 columns', 'netbase-toolkit' ) => '6',
                            __( '7 columns', 'netbase-toolkit' ) => '7',
                            __( '8 columns', 'netbase-toolkit' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'image_grid',
                        ),
                ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'udetor'),
                    'param_name' => 'slider',
                    'std' => true,  
                    'dependency' => array(
                            'element' => 'type',
                            'value' => 'image_grid',
                    ),                  
                ), 
                array(
                        'param_name'  => 'col_tablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),

                array(
                        'param_name'  => 'col_mobile',
                        'heading'     => esc_html__( 'Number of columns displayed mobile', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),
                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'udetor' ),
                        'type'       => 'checkbox',                                                
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'udetor' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Margin Items', 'netbase-toolkit' ),
                    'param_name' => 'margin',
                    'value' => '',
                    'description' => __( 'Enter image size in pixels. Example: 200x100 (Width x Height).', 'netbase-toolkit' ),
                    'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Image source', 'netbase-toolkit' ),
                    'param_name' => 'source',
                    'value' => array(
                        __( 'Media library', 'netbase-toolkit' ) => 'media_library',
                        __( 'External links', 'netbase-toolkit' ) => 'external_link',
                    ),
                    'std' => 'media_library',
                    'description' => __( 'Select image source.', 'netbase-toolkit' ),
                ),
                array(
                    'type' => 'attach_images',
                    'heading' => __( 'Images', 'netbase-toolkit' ),
                    'param_name' => 'images',
                    'value' => '',
                    'description' => __( 'Select images from media library.', 'netbase-toolkit' ),
                    'dependency' => array(
                        'element' => 'source',
                        'value' => 'media_library',
                    ),
                ),
                array(
                    'type' => 'exploded_textarea_safe',
                    'heading' => __( 'External links', 'netbase-toolkit' ),
                    'param_name' => 'custom_srcs',
                    'description' => __( 'Enter external link for each gallery image (Note: divide links with linebreaks (Enter)).', 'netbase-toolkit' ),
                    'dependency' => array(
                        'element' => 'source',
                        'value' => 'external_link',
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Image size', 'netbase-toolkit' ),
                    'param_name' => 'img_size',
                    'value' => 'thumbnail',
                    'description' => __( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'netbase-toolkit' ),
                    'dependency' => array(
                        'element' => 'source',
                        'value' => 'media_library',
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Image size', 'netbase-toolkit' ),
                    'param_name' => 'external_img_size',
                    'value' => '',
                    'description' => __( 'Enter image size in pixels. Example: 200x100 (Width x Height).', 'netbase-toolkit' ),
                    'dependency' => array(
                        'element' => 'source',
                        'value' => 'external_link',
                    ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'On click action', 'netbase-toolkit' ),
                    'param_name' => 'onclick',
                    'value' => array(
                        __( 'None', 'netbase-toolkit' ) => '',
                        __( 'Link to large image', 'netbase-toolkit' ) => 'img_link_large',
                        __( 'Open prettyPhoto', 'netbase-toolkit' ) => 'link_image',
                        __( 'Open custom link', 'netbase-toolkit' ) => 'custom_link',
                    ),
                    'description' => __( 'Select action for click action.', 'netbase-toolkit' ),
                    'std' => 'link_image',
                ),
                array(
                    'type' => 'exploded_textarea_safe',
                    'heading' => __( 'Custom links', 'netbase-toolkit' ),
                    'param_name' => 'custom_links',
                    'description' => __( 'Enter links for each slide (Note: divide links with linebreaks (Enter)).', 'netbase-toolkit' ),
                    'dependency' => array(
                        'element' => 'onclick',
                        'value' => array( 'custom_link' ),
                    ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Custom link target', 'netbase-toolkit' ),
                    'param_name' => 'custom_links_target',
                    'description' => __( 'Select where to open  custom links.', 'netbase-toolkit' ),
                    'dependency' => array(
                        'element' => 'onclick',
                        'value' => array(
                            'custom_link',
                            'img_link_large',
                        ),
                    ),
                    'value' => vc_target_param_list(),
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'netbase-toolkit' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'netbase-toolkit' ),
                )
            )
        ) );                               
        
    }     
     
    // Element HTML
    public static function shortcode_vc_images_gallery($atts, $content = null)
    {
        $custom_class ='';
        $thumbnail = '';
        $title = $source = $type = $onclick = $custom_links = $custom_links_target = $img_size = $external_img_size = $images = $custom_srcs = $el_class = $el_id = $interval = $css = $css_animation = '';
        $large_img_src = $default_src = '';
        
        $default_src = NETBASE_TOOLKIT_URL . 'assets/images/no_image.png';
        
        $gal_images = '';
        $link_start = '';
        $link_end = '';
        $el_start = '';
        $el_end = '';
        $slides_wrap_start = '';
        $slides_wrap_end = '';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'type' => '',
                    'columns'=> '3',
                    'source' => 'media_library',
                    'images' => '',
                    'custom_srcs' => '',
                    'img_size' => '',
                    'external_img_size' =>'',
                    'onclick' =>'link_image',
                    'custom_links' =>'',
                    'custom_links_target'=>'',
                    'css' => '',
                    'slider'                => true,
                    'col_tablet' =>'',  
                    'col_mobile' =>'',  
                    'pagination'   => '',
                    'navigation'   => '',
                    'margin'       => '',
                ),
                $atts
            )
        );       
                

        if ( 'image_grid' === $type ) {           

            $classes=$attr = array();
            $data_owlcarousel = '';
            if ( ! empty( $slider ) ) {
                if($margin && $margin !=''){                
                    $attr[] = '"margin": "' . ( int ) $margin . '"';
                }
                if ( ! empty( $col_tablet ) ) {
                    $attr[] = '"tablet": "' . ( int ) $col_tablet . '"';
                }
                if ( isset($col_mobile) && ! empty( $col_mobile ) ) {
                    $attr[] = '"mobile": "' . ( int ) $col_mobile . '"';
                }
                
                if ( ! empty( $columns ) ) {
                    $attr[] = '"items": "' . ( int ) $columns . '"';
                }
                if ( $navigation ) {
                    $attr[] = '"nav": "true"';
                }
                if ( $pagination ) {
                    $attr[] = '"dots": "true"';
                }            
                
                if ( ! empty( $attr ) ) {
                    $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
                }   
                $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
            }

            $el_start = '<li class="item-col-'.$columns.'">';
            $el_end = '</li>';
            $slides_wrap_start = '<ul class="nb_image_grid_ul '. esc_attr( implode( ' ', $classes ) ) .'" '.$data_owlcarousel.'>';
            $slides_wrap_end = '</ul>';
        }

        if ( 'link_image' === $onclick ) {
            wp_enqueue_script( 'prettyphoto' );
            wp_enqueue_style( 'prettyphoto' );
        }
        

        $pretty_rel_random = ' data-rel="prettyPhoto[rel-' . get_the_ID() . '-' . rand() . ']"';

        if ( 'custom_link' === $onclick ) {
            $custom_links = vc_value_from_safe( $custom_links );
            $custom_links = explode( ',', $custom_links );
        }

        switch ( $source ) {
            case 'media_library':
                $images = explode( ',', $images );
                break;

            case 'external_link':
                $images = vc_value_from_safe( $custom_srcs );
                $images = explode( ',', $images );

                break;
        }
        
        if($images !=''){
            foreach ( $images as $i => $image ) {
            switch ( $source ) {
                case 'media_library':
                    if ( $image > 0 && function_exists('wpb_getImageBySize')) {
                        $img = wpb_getImageBySize( array(
                            'attach_id' => $image,
                            'thumb_size' => $img_size,
                        ) );
                        $thumbnail = $img['thumbnail'];
                        $large_img_src = $img['p_img_large'][0];
                    } else {
                        $large_img_src = $default_src;
                        $thumbnail = '<img src="' . $default_src . '" />';
                    }
                    break;

                case 'external_link':
                    $image = esc_attr( $image );
                    $dimensions = vcExtractDimensions( $external_img_size );
                    $hwstring = $dimensions ? image_hwstring( $dimensions[0], $dimensions[1] ) : '';
                    $thumbnail = '<img ' . $hwstring . ' src="' . $image . '" />';
                    $large_img_src = $image;
                    break;
            }

            $link_start = $link_end = '';

            switch ( $onclick ) {
                case 'img_link_large':
                    $link_start = '<a href="' . $large_img_src . '" target="' . $custom_links_target . '">';
                    $link_end = '</a>';
                    break;

                case 'link_image':
                    $link_start = '<a class="prettyphoto" href="' . $large_img_src . '"' . $pretty_rel_random . '>';
                    $link_end = '</a>';
                    break;

                case 'custom_link':
                    if ( ! empty( $custom_links[ $i ] ) ) {
                        $link_start = '<a href="' . $custom_links[ $i ] . '"' . ( ! empty( $custom_links_target ) ? ' target="' . $custom_links_target . '"' : '' ) . '>';
                        $link_end = '</a>';
                    }
                    break;
            }

            $gal_images .= $el_start . $link_start . $thumbnail . $link_end . $el_end;
            }
        }       
        

        $html = $css_class = '';
        
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'nbtoolkit_vc_images_gallery', $atts );
        }
        // End HTML code.

        $html .= '<div class="netbase-toolkit vc_images_gallery '.esc_attr( $css_class ).'">' . $slides_wrap_start . $gal_images . $slides_wrap_end . '</div>';

        wp_reset_postdata();
        return apply_filters('nb_shortcode_vc_images_gallery', force_balance_tags($html));
    }
     
} // End Element Class
