<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Vc_Comments
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_vc_comments', array(__CLASS__, 'shortcode_vc_comments'));        
    }
    
    public static function map()
    {
        vc_map(array(
            'name' => esc_html__('Udetor: Comments', 'udetor'),
            'base' => 'netbase_vc_comments',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Comments.', 'udetor'),
            'icon' => 'udetor-widget-icon udetor-widget-icon-testimonials',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'udetor'),
                    'param_name' => 'title',
                    'value' => '',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Number items display', 'udetor' ),
                    'param_name'  => 'number_posts',
                    'std'         => '5',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',
                        esc_html__( '5', 'udetor' )      => '5',
                        esc_html__( '6', 'udetor' )      => '6',
                        esc_html__( '7', 'udetor' )      => '7',
                        esc_html__( '8', 'udetor' )      => '8',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),                

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Style Layout', 'udetor' ),
                    'param_name'  => 'comment_style',
                    'std'         => 'vertical_feature',
                    'value'       => array(
                        esc_html__( 'Vertical Feature', 'udetor' ) => 'vertical_feature',
                        esc_html__( 'List', 'udetor' )      => 'list',                        
                       
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Text all comment', 'udetor' ),
                    'param_name' => 'text_link',
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_vc_comments($atts, $content = null)
    {
        $html = $attr_parent = '';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'     => '',
                    'number_posts'  =>'5',  
                    'comment_style' => 'vertical_feature' ,
                    'css' => '', 
                    'text_link' => esc_html__('View more ~','udetor'),                
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_');

        $css_class = $classes = $attr = array(); 
        
        if (function_exists('vc_shortcode_custom_css_class')) {  
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_vc_comments', $atts );   
        }
        $query = get_comments(apply_filters('vc_comments_query_args', array('number'=> $number_posts, 'status' => 'approve', 'post_type'=>'sfwd-courses')));   
        ob_start();

        $allitem = count($query);
        $il = 0;
        foreach ($query as $comment): 

            $ratings = array();
            $star = get_comment_meta( $comment->comment_ID, 'nbcsr_rating', true);
            if( !empty( $star ) ) {
                        array_push( $ratings, $star );
            }
            if(!empty($ratings)){
                $total      = array_sum($ratings);
                $count      = count($ratings);        
                if( $count > 0 ) {
                    $average    = $total / $count;
                    $ratings_arrange = array_count_values($ratings);
                }
                
                // Insert 0 if it is undefined or empty
                for ( $i = 1; $i <= 5; $i++) {
                    if( !isset($ratings_arrange[$i]) ) {
                        $ratings_arrange[$i] = 0;
                    }
                }
                $output = wp_star_rating( array(
                    'rating'    => $average,
                    'type'      => 'rating',
                    'number'    => $count,
                    'echo'      => false
                ));
            }else{
                $output = wp_star_rating( array(                
                    'type'      => 'rating',                
                    'echo'      => false
                ));
            }

            
            if($il>0){
                $url_post= get_post_permalink( $comment->comment_post_ID);
                if($il==1){                
                echo '<div class="col-md-6 left-item-wap">';
                }
                    echo '<div class="left-item">';
                        echo $output;
                        echo '<a href="'.$url_post.'">';
                        comment_excerpt($comment->comment_ID); 
                        echo '</a>'; 
                    echo '</div>'; 
                if($il==$allitem){
                echo '</div>';
                }   
            }elseif($il == 0){
                echo '<div class="col-md-6 right-item">';
                $user = get_user_by( 'email', $comment->comment_author_email );
                $job_profile ='';
                if($user){                    
                    $job_profile = get_the_author_meta( 'job_profile' ,$user->ID);  

                }
                $av = get_avatar_url($comment->comment_author_email); 
                
                ?>
                <div class="lst-author">
                    <img alt="" src="<?php echo $av; ?>" class="avatar photo" ><span class="author vcard"><?php printf('%s', get_comment_author_link($comment->comment_ID));?></span>
                    <?php 
                    if($job_profile !=''){ 
                        echo '<div class="job_profile">'.$job_profile.'</div>';
                    } ?>
                </div>
                <?php                
                    echo '<div class="commnet-content">"';
                    echo $comment->comment_content;
                    echo '"</div>';
                    echo $output;
                    
                    //echo get_the_title($comment->comment_post_ID);
                    //echo $comment->comment_date;
                    $fm = "j F, Y";
                    echo '<div class="c-date">'. get_comment_date( $fm, $comment->comment_ID ).'</div>';
                    
                echo '</div>';
            }
           
            $il ++;
        endforeach; 
        
        
        // Generate HTML code.

        $html .= '<div class="'.esc_attr( $css_class ).' netbase-toolkit comment row">' . ob_get_clean() . '<p class="view-all-comment"><a href="'.esc_url( home_url( '/courses/' )).'">'.esc_html($text_link).'</a></p></div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_vc_comments', force_balance_tags($html));
    }

}
