<?php
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_Vc_Bmi_Calculator{

    public static function initialize(){        
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('nbtvc_bmi_calculator', array(__CLASS__, 'shortcode_vc_comments'));        
    }    
    public static function map(){
        vc_map(array(
            'name' => esc_html__('Udetor: Bmi Calculator', 'udetor'),
            'base' => 'nbtvc_bmi_calculator',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Comments.', 'udetor'),
            'icon' => 'icon-wpb-call-to-action',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'udetor'),
                    'param_name' => 'title',
                    'value' => '',
                ),

                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading Form', 'udetor' ),
                    'param_name'  => 'heading',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'heading.', 'udetor' )
                ),

                array(
                    'type'        => 'colorpicker',                    
                    'heading'     => esc_html__( 'Text color ', 'udetor' ),
                    'param_name'  => 'textcolor',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Select the Text color.', 'udetor' ),                    
                ),
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                ),
                
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_vc_comments($atts, $content = null)
    {
        $html = $txtcss = $attr_parent = '';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'     => '',
                    'heading'   =>'',     
                    'textcolor' => '',                 
                    'css'       => '', 
                    
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_');

        $css_class =  array();   
        
        if (function_exists('vc_shortcode_custom_css_class')) {
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'nbtvc_bmi_calculator', $atts );   
        }
        if ( $textcolor ) {
            $txtcss .= 'color:' . $textcolor . ';';
        } 
        if ( $txtcss ) {
            $txtcss = ' style="' . $txtcss . '"';
        }  
        ob_start();

        echo do_shortcode('[udetor_bmi_calculator heading="'.$heading.'"]'); 
        
        // Generate HTML code.

        $html .= '<div class="'.esc_attr( $css_class ).' netbase-toolkit bmi-calculator" '.$txtcss.'>' . ob_get_clean() . '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_vc_comments', force_balance_tags($html));
    }

}
