<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_Upcoming_Events{

    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('netbase_list_events', array(__CLASS__, 'shortcode_list_events'));        
    }

    public static function map()
    {
        vc_map( array(
            'name'        => esc_html__( 'Udetor: List Upcoming Events', 'udetor' ),
            'base'        => 'netbase_list_events',
            'category'    => esc_html__( 'Udetor Elements', 'udetor' ),
            'description' => esc_html__( 'Display List Events.', 'udetor' ),            
            'params'      => array(
                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Title', 'udetor' ),
                    'param_name'  => 'title',
                    'value'       => '',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Number events display', 'udetor' ),
                    'param_name'  => 'number_posts',
                    'std'         => '2',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',
                        esc_html__( '5', 'udetor' )      => '5',
                        esc_html__( '6', 'udetor' )      => '6',
                        esc_html__( '7', 'udetor' )      => '7',
                        esc_html__( '8', 'udetor' )      => '8',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Layout', 'udetor' ),
                    'param_name'  => 'layout',
                    'value'       => array(
                        esc_html__( 'Default', 'udetor' )  => 'base',
                        esc_html__( 'List', 'udetor' )   => 'list', 
                        esc_html__( 'Grid', 'udetor' )   => 'grid', 
                        esc_html__( 'List 2', 'udetor' )   => 'list-2', 
                        esc_html__( 'List Multi Color', 'udetor' )   => 'list-multi-color',                        
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),
                array(
                        'param_name'  => 'grid_columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',                           
                            __( '6 columns', 'udetor' ) => '6',                           
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                        'dependency' => array(
                            'element' => 'layout',
                            'value'   => 'grid',
                        ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text View All', 'udetor' ),
                    'param_name'  => 'text_link',
                    'std'         => esc_html__( 'View All', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ) );
    }

    public static function shortcode_list_events($atts, $content = null)
    {
        $html = $attr_parent = $css_class = '';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'        => '',
                    'layout'       => 'base',
                    'number_posts' => '2',
                    'text_link'    => '',
                    'grid_columns' => '3',
                    'css' =>'',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');

        if ( is_plugin_active( 'event-espresso-decaf/espresso.php' ) ) {
            $css_class = '';
            if (function_exists('vc_shortcode_custom_css_class')) {
                $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_list_events', $atts ); 
            }
            global $post;
            global $wpdb;
            // make sure there is some kinda post object
            if ( $post instanceof WP_Post ) {
            $where = array(
                // 'Datetime.DTT_is_primary' => 1,
                'status' => array( 'IN', array( 'publish', 'sold_out' ) )
            );
            // add category
            /* if ( $category ) {
                    $where['Term_Taxonomy.taxonomy'] = 'espresso_event_categories';
                    $where['Term_Taxonomy.Term.slug'] = $category;
            }*/
            $where['Datetime.DTT_EVT_end'] = array( '>=', EEM_Datetime::instance()->current_time_for_query( 'DTT_EVT_end' ) );
            // run the query
            $events = EE_Registry::instance()->load_model( 'Event' )->get_all( array(
                    $where,
                    'limit' => $number_posts > 0 ? '0,' . $number_posts : '0,10',
                    'order_by' => 'Datetime.DTT_EVT_start',
                    'order' => 'ASC',
                    'group_by' => 'EVT_ID'
            ));    
            $table1= $wpdb->prefix."esp_event_venue";
            $table2= $wpdb->prefix."esp_venue_meta";
            ob_start(); 
            if ( ! empty( $events )) {
                if($layout=='list'){
                    if($title){ echo '<h3 class="font-h1 udetor-detail-title">'. esc_html($title) .'</h3>'; }
                }
                elseif($layout=='grid'){
                    if(isset($grid_columns)){
                        $event_columns='';
                        switch ($grid_columns) {
                            case '1':
                                $event_columns= 'col-md-12';
                                break;
                            case '2':
                                $event_columns= 'col-md-6';
                                break;
                            case '3':
                                $event_columns= 'col-lg-4 col-md-6';
                                break;
                            case '4':
                                $event_columns= 'col-lg-3 col-md-6';
                                break;
                            case '6':
                                $event_columns= 'col-lg-2 col-md-4';
                                break;
                            default:
                                $event_columns= 'col-md-4';
                                break;
                        }
                    }
                }
                foreach ( $events as $event ) {
                        if ( $event instanceof EE_Event && ( !is_single() || $post->ID != $event->ID() ) ) {
                            $event_url = apply_filters( 'FHEE_EEW_Upcoming_Events__widget__event_url', $event->get_permalink(), $event );
                            $desc = $event->short_description( 20 );
                            $date_format = ! empty( $date_format ) ? $date_format : get_option( 'date_format' );
                            $time_format = ! empty( $time_format ) ? $time_format : get_option( 'time_format' );
                            $date_format = apply_filters( 'FHEE__espresso_list_of_event_dates__date_format', $date_format );
                            $time_format = apply_filters( 'FHEE__espresso_list_of_event_dates__time_format', $time_format );
                            $datetimes = EEH_Event_View::get_all_date_obj( $event->ID());  
                            if($layout=='list'){
                                echo '<div class="lst-upcoming-event">';
                                echo '<div class="udetor-event-meta ee-clearfix">';
                                    if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                        foreach ( $datetimes as $datetime ) {
                                            if ( $datetime instanceof EE_Datetime ) {                     
                                                $start = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_start', 'j|F, Y' ) );                                               
                                                $datestart=explode("|",$start);
                                                if(count($datestart)== 2){
                                                    echo '<div class="left-meta-event">'.$datestart[0].'</div>';
                                                    echo '<div class="right-meta-event">';
                                                    echo '<div class="udetor-date-event">'.$datestart[1].'</div>';
                                                }
                                                echo '<div class="udetor-event-timerange">' . $datetime->time_range( $time_format ) . '</div>';
                                                $resultslst = array();                                                        
                                                $query = " SELECT 
                                                                    tx.VNU_address, tx.STA_ID, tx.CNT_ISO 
                                                                FROM 
                                                                    $table1 t
                                                                    INNER JOIN $table2 tx On t.VNU_ID=tx.VNU_ID
                                                                WHERE t.EVT_ID LIKE '%d'                                                            
                                                            ";
                                                $query = ( $wpdb->prepare($query, $event->ID()));
                                                $resultslst = $wpdb->get_results( $query );
                                                          if(sizeof($resultslst) > 0 && is_array($resultslst) && !is_wp_error($resultslst)){
                                                                echo '<div class="lst-venue">';
                                                                foreach($resultslst as $resultlst){
                                                                   echo  $resultlst->VNU_address;
                                                                }
                                                                echo '</div>';
                                                            }                                                        
                                                            
                                                            if(count($datestart)== 2){
                                                                    echo '</div>'; 
                                                            }
                                                        }
                                                    }
                                            }

                                echo '</div>';
                                echo '<h3 class="entry-title font-h1"><a href="' . $event_url . '">' . $event->name() . '</a></h3>';
                                echo '</div>'; 
                            }
                            elseif($layout=='grid'){
                                echo '<div class="grid-upcoming-event text-center '.$event_columns.'">';
                                echo '<div class="wap-grid-event">';
                                $image_size = 'udetor-course-thumb';
                                if ( has_post_thumbnail( $event->ID() ) && $image_size != 'none' ) {
                                    echo '<div class="event-grid-thumb"><a class="ee-upcoming-events-widget-img" href="' . $event_url . '">' . get_the_post_thumbnail( $event->ID(), $image_size ) . '</a></div>';
                                }
                                echo '<div class="grid-event-date">';
                                if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                    foreach ( $datetimes as $datetime ) {
                                        if ( $datetime instanceof EE_Datetime ) {
                                            $start = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_start', 'j|F, Y' ) );
                                            $datestart=explode("|",$start);
                                            if(count($datestart)== 2){
                                                echo '<div class="day-event">'.$datestart[0].'</div>';
                                                echo '<div class="my-event">'.$datestart[1].'</div>';
                                            }
                                        }
                                    }
                                }
                                echo '</div>';

                                echo '<div class="grid-event-meta ee-clearfix">';
                                echo '<h2 class="entry-title font-h1"><a href="' . $event_url . '">' . $event->name() . '</a></h2>';
                                if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                    foreach ( $datetimes as $datetime ) {
                                        if ( $datetime instanceof EE_Datetime ) {
                                            $resultslst = array();
                                            $query = " SELECT tx.VNU_address, tx.STA_ID, tx.CNT_ISO FROM 
                                                        $table1 t
                                                        INNER JOIN $table2 tx On t.VNU_ID=tx.VNU_ID
                                                            WHERE t.EVT_ID LIKE '%d'                                                            
                                                        ";

                                            $query = ( $wpdb->prepare($query, $event->ID()));
                                            $resultslst = $wpdb->get_results( $query );
                                            if(sizeof($resultslst) > 0 && is_array($resultslst) && !is_wp_error($resultslst)){
                                                echo '<div class="lst-venue">';
                                                foreach($resultslst as $resultlst){
                                                    echo  $resultlst->VNU_address;
                                                }
                                                echo '</div>';
                                            }
                                            echo '<div class="udetor-event-timerange">' . $datetime->time_range( $time_format ) . '</div>';
                                        }
                                    }
                                }
                                echo '</div>';
                                echo '</div>';
                                echo '</div>';

                            }
                            elseif($layout == 'list-2'){
                                echo '<div class="list2-upcoming-event">';
                                    echo '<div class="e-thumb col-md-3">';
                                        if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                            foreach ($datetimes as $datetime) {
                                                if ($datetime instanceof EE_Datetime) {
                                                    $start = str_replace(' ', '&nbsp;', $datetime->get_i18n_datetime('DTT_EVT_start', 'j|M'));
                                                    $datestart = explode("|", $start);
                                                    if (count($datestart) == 2) {
                                                        echo '<div class="l2-date-event">';
                                                        echo '<div class="d-date-event">' . $datestart[0] . '</div>';
                                                        echo '<div class="m-date-event">' . $datestart[1] . '</div>';
                                                        echo '</div>';
                                                    }
                                                }
                                            }
                                        }
                                        $image_size = 'udetor-course-thumb';
                                        if ( has_post_thumbnail( $event->ID() ) && $image_size != 'none' ) {
                                            echo '<div class="event-l2-thumb"><a href="' . $event_url . '">' . get_the_post_thumbnail( $event->ID(), $image_size ) . '</a></div>';
                                        }
                                    echo '</div>';
                                    echo '<div class="e-content col-md-5">';
                                        echo '<h2 class="entry-title"><a href="' . $event_url . '">' . $event->name() . '</a></h2>';
                                        if (  $desc && $desc !='') { echo '<p class="lst-event-des">' . wp_trim_words($desc,10) . '</p>'; }

                                    echo '</div>';
                                    echo '<div class="e-info col-md-4">';
                                        if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                        foreach ( $datetimes as $datetime ) {
                                            if ( $datetime instanceof EE_Datetime ) {
                                                $results = array();
                                                $query = " SELECT 
                                                                    tx.VNU_address, tx.STA_ID, tx.CNT_ISO 
                                                            FROM 
                                                                    $table1 t
                                                                    INNER JOIN $table2 tx On t.VNU_ID=tx.VNU_ID
                                                            WHERE t.EVT_ID LIKE '%d'                                                            
                                                            ";

                                                $query = ( $wpdb->prepare($query, $event->ID()));
                                                $results = $wpdb->get_results( $query );
                                                if(sizeof($results) > 0 && is_array($results) && !is_wp_error($results)){
                                                    echo '<div class="venue">';
                                                    echo '<i class="fa fa-location-arrow"></i>';
                                                    foreach($results as $result){
                                                        echo  $result->VNU_address;
                                                    }
                                                    echo '</div>';
                                                }
                                                echo '<div class="event-timerange"><i class="fa fa-clock-o"></i>' . $datetime->time_range( $time_format ) . '</div>';
                                            }
                                        }
                                    }
                                    echo '</div>';
                                echo '</div>';
                            }
                            elseif($layout=='list-multi-color'){
                                echo '<div class="multi-color-upcoming-event">';
                                    echo '<div class="e-thumb">';
                                        $image_size = 'udetor-course-thumb';
                                        echo '<div class="wrap-thumb">';
                                        if ( has_post_thumbnail( $event->ID() ) && $image_size != 'none' ) {
                                            echo '<div class="event-l2-thumb"><a href="' . $event_url . '">' . get_the_post_thumbnail( $event->ID(), $image_size ) . '</a></div>';
                                        }
                                        if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                            foreach ($datetimes as $datetime) {
                                                if ($datetime instanceof EE_Datetime) {
                                                    $start = str_replace(' ', '&nbsp;', $datetime->get_i18n_datetime('DTT_EVT_start', 'j|M'));
                                                    $datestart = explode("|", $start);
                                                    if (count($datestart) == 2) {
                                                        echo '<div class="l2-date-event">';
                                                        echo '<div class="d-date-event">' . $datestart[0] . '</div>';
                                                        echo '<div class="m-date-event">' . $datestart[1] . '</div>';
                                                        echo '</div>';
                                                    }
                                                }
                                            }
                                        }
                                        echo '</div>';
                                    echo '</div>';
                                    echo '<div class="e-info">';
                                        echo '<span class="bg-content"></span>';
                                        echo '<div class="e-content">';
                                            echo '<h2 class="entry-title"><a href="' . $event_url . '">' . $event->name() . '</a></h2>';
                                            if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                            foreach ( $datetimes as $datetime ) {
                                                if ( $datetime instanceof EE_Datetime ) {
                                                    $results = array();
                                                    $query = " SELECT 
                                                                        tx.VNU_address, tx.STA_ID, tx.CNT_ISO 
                                                                FROM 
                                                                        $table1 t
                                                                        INNER JOIN $table2 tx On t.VNU_ID=tx.VNU_ID
                                                                WHERE t.EVT_ID LIKE '%d'                                                            
                                                                ";

                                                    $query = ( $wpdb->prepare($query, $event->ID()));
                                                    $results = $wpdb->get_results( $query );
                                                    echo '<div class="event-timerange"><i class="icomoon icon-clock"></i>' . $datetime->time_range( $time_format ) . '</div>';
                                                    if(sizeof($results) > 0 && is_array($results) && !is_wp_error($results)){
                                                        echo '<div class="venue">';
                                                        echo '<i class="icomoon icon-placeholder"></i>';
                                                        foreach($results as $result){
                                                            echo  $result->VNU_address;
                                                        }
                                                        echo '</div>';
                                                    }
                                                }
                                            }
                                        }
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            }else{
                                echo '<div class="col-md-6">';
                                echo '<div class="row">';
                                $image_size = 'udetor-course-thumb';
                                if ( has_post_thumbnail( $event->ID() ) && $image_size != 'none' ) {
                                    echo '<div class="col-sm-6 col-md-12 col-xl-6 archive-entry-thumb aethumb mgb15"><a class="ee-upcoming-events-widget-img" href="' . $event_url . '">' . get_the_post_thumbnail( $event->ID(), $image_size ) . '</a></div>';
                                }
                                echo '<div class="col-sm-6 col-md-12 col-xl-6">';
                                echo '<div class="udetor-event-meta ee-clearfix">';
                                if ( is_array( $datetimes ) && ! empty( $datetimes )) {
                                    foreach ( $datetimes as $datetime ) {
                                        if ( $datetime instanceof EE_Datetime ) {
                                            $start = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_start', 'j|F, Y' ) );
                                            $datestart=explode("|",$start);
                                            if(count($datestart)== 2){
                                                echo '<div class="left-meta-event">'.$datestart[0].'</div>';
                                                echo '<div class="right-meta-event">';
                                                echo '<div class="udetor-date-event">'.$datestart[1].'</div>';
                                            }
                                            echo '<div class="udetor-event-timerange">' . $datetime->time_range( $time_format ) . '</div>';

                                            $results = array();
                                            $query = "  SELECT 
                                                                tx.VNU_address, tx.STA_ID, tx.CNT_ISO 
                                                            FROM 
                                                                $table1 t
                                                                INNER JOIN $table2 tx On t.VNU_ID=tx.VNU_ID
                                                            WHERE t.EVT_ID LIKE '%d'                                                            
                                                        ";

                                            $query = ( $wpdb->prepare($query, $event->ID()));
                                            $results = $wpdb->get_results( $query );
                                            if(sizeof($results) > 0 && is_array($results) && !is_wp_error($results)){
                                                echo '<div class="lst-venue">';
                                                    foreach($results as $result){
                                                        echo  $result->VNU_address;
                                                    }
                                                echo '</div>';
                                            }

                                            if(count($datestart)== 2){
                                                echo '</div>';
                                            }
                                        }
                                    }
                                }

                                echo '</div>';
                                echo '<h2 class="entry-title"><a href="' . $event_url . '">' . $event->name() . '</a></h2>';
                                if (  $desc ) {
                                    echo '<p class="lst-event-des">' . $desc . '</p>';
                                }

                                echo '</div>';
                                echo '</div>';
                                echo '</div>';
                            }
                        }
                    }

                    if($layout=='list' || $layout == 'list-2'){
                        if($layout=='list'){ $bclass= 'secondary_btn btn-seeall';}
                        elseif($layout=='list-2'){ $bclass= 'btn-event-lst2';}
                        if($text_link !=''){
                            $text_link = $text_link;
                        }else{
                            $text_link = 'See all';
                        }
                        echo '<a href="'.esc_url( home_url( '/event-category/event/' )).'" class="'.$bclass.'">'. $text_link .'</a>';    
                    }elseif($layout=='grid'){
                        if($text_link !=''){
                            echo '<div class="col-md-12 text-center grid-layout-btn">';
                            echo '<a href="'.esc_url( home_url( '/event-category/event/' )).'" class="btn-style2">'. $text_link .'</a>';
                            echo '</div>';
                        }
                    }else{
                        if($text_link !=''){ $text_link = $text_link; }else{
                            $text_link = 'View all';
                        }
                        if($layout == 'list-multi-color'){
                            $btn = "multi_btn"; 
                        }else{
                            $btn = "secondary_btn";
                        }
                        echo '<p class="view-all-event text-center"><a href="'.esc_url( home_url( '/event-category/event/' )).'" class="'.$btn.'">'. $text_link .'</a></p>';
                    }
                    
            }   
        }
        // Generate HTML code.       
            $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit lst_upcoming_events row '.esc_attr( $css_class ).'">' . ob_get_clean() . '</div>';
            wp_reset_postdata();
        }

        return apply_filters('netbase_shortcode_list_events', force_balance_tags($html));
    }
}