<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_Testimonials
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_testimonials', array(__CLASS__, 'shortcode_testimonials'));        
    }

    public static function map()
    {

        vc_map(array(
            'name' => esc_html__('Udetor: Testimonial', 'udetor'),
            'base' => 'netbase_testimonials',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display testimonials.', 'udetor'),
            'icon' => 'udetor-widget-icon udetor-widget-icon-testimonials',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'udetor'),
                    'param_name' => 'title',
                    'value' => '',
                ),
                array(
                        'heading'    => esc_html__( 'Testimonial content', 'udetor' ),
                        'type'       => 'param_group',
                        'param_name' => 'testimonials_content',
                        'params'     => array(
                            array(
                                'param_name' => 'avatar',
                                'heading'    => esc_html__( 'Avatar', 'udetor' ),
                                'type'       => 'attach_image',
                            ),
                            array(
                                'param_name' => 'testimonial',
                                'heading'    => esc_html__( 'Testimonial', 'udetor' ),
                                'type'       => 'textarea',
                            ),
                            array(
                                'param_name' => 'name',
                                'heading'    => esc_html__( 'Name', 'udetor' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'job',
                                'heading'    => esc_html__( 'Job', 'udetor' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                'param_name' => 'date',
                                'heading'    => esc_html__( 'Date', 'udetor' ),
                                'type'       => 'textfield',
                            ),
                        ),
                    ),
                array(
                        'param_name' => 'avt_shape',
                        'heading'    => esc_html__( 'Avatar style', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Square', 'udetor' ) => 'square',
                            __( 'Circle', 'udetor' ) => 'circle',
                        ),
                        'std'        => 'circle',
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                    ),
                
                array(
                        'param_name' => 'style',
                        'heading'    => esc_html__( 'Style', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Style 1', 'udetor' ) => 'style-1',
                            __( 'Style 2', 'udetor' ) => 'style-2',
                            __( 'Style 3', 'udetor' ) => 'style-3',
                            __( 'Style Home Fitness', 'udetor' ) => 'style-fitness',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                    ),
                array(
                        'heading'     => __( 'Icon Quote Image', 'udetor' ),
                        'param_name'  => 'quote_img',
                        'type'        => 'attach_image',                       
                                               
                        'dependency'  => array(
                            'element' => 'style',
                            'value'   => 'style-3'
                        ),
                    ),    

                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'udetor'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),                

                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                    ),
                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'udetor' ),
                        'type'       => 'checkbox',                                                
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'udetor' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                        'param_name' => 'dots_size',
                        'heading'    => esc_html__( 'Dots Size', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Big', 'udetor' ) => 'big',
                            __( 'Small', 'udetor' ) => 'small',
                        ),
                        'std'        => 'small',
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                ), 
                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'param_name'  => 'columnstablet767',
                        'heading'     => esc_html__( 'Number of columns displayed mobile', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'udetor' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                        'param_name' => 'loop',
                        'heading'    => esc_html__( 'Enable Loop', 'udetor' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                        'param_name' => 'nav_position',
                        'heading'    => esc_html__( 'Navigation Position', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Top', 'udetor' ) => 'top',
                            __( 'Center', 'udetor' ) => 'center',
                            __( 'Bottom', 'udetor' ) => 'bottom',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                        'dependency' => array(
                            'element' => 'navigation',
                            'value'   => 'true',
                        ),
                ),                
                array(
                        'param_name'  => 'margin',
                        'heading'     => esc_html__( 'Margin Element', 'udetor' ),
                        'description' => esc_html__( 'Margin Element', 'udetor' ),
                        'type'        => 'textfield',
                        'value'       => 30,
                ),                
                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_testimonials($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'layout' => 'default',
                    'columns' => '3',                    
                    'testimonials_content'  => '',
                    'avatar'                => '',
                    'avt_shape'             => 'circle',
                    'testimonial'           => '',
                    'name'                  => '',
                    'job'                   => '',
                    'style'                 => 'style-1',
                    'slider'                => true,
                    'columnstablet' =>'',                
                    'nav_position' => 'bottom',
                    'pagination'   => '',
                    'navigation'   => '',
                    'autoplay'     => '',
                    'loop'         => '', 
                    'margin'       => 30,
                    'dots_size' => 'small',
                    'date' =>'',
                    'quote_img' =>'',
                    'columnstablet767' =>'',
                ),
                $atts
            )
        );

        // Generate custom ID
        /*$id = uniqid('netbase_toolkit_testimonials_');*/

        $classes = $attr = array();

        if($style){
            $classes[] = $style.' ';
        }

        if ( ! empty( $slider ) ) {
            if($margin){                
                $attr[] = '"margin": "' . ( int ) $margin . '"';
            }
            
            if ( $navigation ) {
                $attr[] = '"nav": "true"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }

            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"ades": "' . ( int ) $columnstablet . '"';
            }
            if ( isset($columnstablet767) && ! empty( $columnstablet767 ) ) {
                $attr[] = '"tablet": "' . ( int ) $columnstablet767 . '"';
            }
            
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if($autoplay){
                $attr[] = '"autoplay": "true"';
            }
            if($loop){
                $attr[] = '"loop": "true"';
            }

            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }            

            if($dots_size && $pagination){
                $classes[] =' dots-'.$dots_size.' ';
            }            

            if ( $nav_position && $navigation) {
                $classes[] =' nav-'.$nav_position.' ';
            }            

            $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
        }
        
        // Generate HTML code.

        $html .= '<div class="netbase-toolkit testimonials '. esc_attr( implode( ' ', $classes ) ) .'"  '.$data_owlcarousel.'>';
        
        $values = ( array ) vc_param_group_parse_atts( $testimonials_content );

        foreach ( $values as $key => $values ) {

            // Get image link and image data
            if ( ! empty( $values[ 'avatar' ] ) ) {
                $img_id       = preg_replace( '/[^\d]/', '', $values[ 'avatar' ] );
                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
                $image_link   = $image[ 'p_img_large' ][ 0 ];
            }
            
            $html .= '<div class="testimonial-item">';
            if($style == 'style-fitness'){
                if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar mgr20">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'udetor' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . ' width="70" height="70" />';
                        $html .= '</div>';
                    }
                    $html .= '<div class="tes-fitness-content">';
                        if ( ! empty( $values[ 'name' ] ) ) {
                            $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                        }
                        if ( ! empty( $values[ 'job' ] ) ) {
                            $html .= '<div class="job meta-color">' . esc_html( $values[ 'job' ] ) . '</div>';
                        }
                        $html .='<span class="icomoon icon-quotes-left"></span>';
                        $html .= '<p>' . $values[ 'testimonial' ] . '</p>';
                    $html .= '</div>'; 

            }else{
                if($style == 'style-3'){
                    $src = wp_get_attachment_image_src($quote_img); 

                    if($src){
                        $html .= '<img src="' . esc_url( $src[0] ) . '" alt="quote" class="i-quote"/>';
                    }else{
                        $html .='<i class="fa fa-quote-right"></i>';    
                    }
                    
                }   
                if($style == 'style-2' || $style == 'style-3'){
                    $html .= '<div class="content">';
                        $html .= '<p>"' . $values[ 'testimonial' ] . '"</p>';
                    $html .= '</div>';    
                }
                    $html .= '<div class="author mgt20">';
                    if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar mgr20">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'udetor' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . ' width="70" height="70" />';
                        $html .= '</div>';
                    }
                    if ( ! empty( $values[ 'name' ] ) ) {
                        $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                    }
                    if($style == 'style-2'){
                        if(isset($values[ 'date' ]) && ! empty( $values[ 'date' ] )){
                            $html .= '<div class="date">' . esc_html( $values[ 'date' ] ) . '</div>';
                        }
                    }

                    if ( ! empty( $values[ 'job' ] ) ) {
                        $html .= '<p class="job meta-color">' . esc_html( $values[ 'job' ] ) . '</p>';
                    }
                    $html .= '</div>';
                    if($style == 'style-1'){
                        $html .= '<div class="content">';
                            $html .= '<p>"' . $values[ 'testimonial' ] . '"</p>';
                        $html .= '</div>';    
                    }

            }
                                    
                    
            $html .= '</div>';            
        }

        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_testimonials', force_balance_tags($html));
    }
}
