<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Services
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_services', array(__CLASS__, 'shortcode_services'));        
    }

    public static function map(){
        vc_map(array(
            'name' => esc_html__('Udetor: Services Icon', 'udetor'),
            'base' => 'netbase_services',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Services Icon.', 'udetor'),
            'icon' => 'udetor-widget-icon udetor-widget-icon-our-team',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'udetor'),
                    'param_name' => 'title_text',
                    'value' => '',
                ),

               array(
                    'param_name'       => 'style',
                    'heading'          => esc_html__( 'Style', 'udetor' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6 mgt15',                        
                        'value'            => array(                                                     
                            __( 'Icon', 'udetor' )      => 'icon',
                            __( 'Image', 'udetor' )     => 'image',
                            __( 'Icon Icomoon', 'udetor' )      => 'icomoon',
                        ),
                ),
                    array(
                        'param_name'       => 'align',
                        'heading'          => esc_html__( 'Box Alignment', 'udetor' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6',                        
                        'value'            => array(
                            __( 'Left', 'udetor' )   => 'left',
                            __( 'Center', 'udetor' ) => 'center',
                            __( 'Right', 'udetor' )  => 'right',
                        ),
                    ),
                    array(
                        'param_name' => 'content_box',
                        'heading'    => esc_html__( 'Content', 'udetor' ),
                        'type'       => 'textarea',                        
                        'holder'     => 'p'
                    ),
                    array(
                        'param_name' => 'text_color',
                        'heading'    => esc_html__( 'Title Color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    array(
                        'param_name' => 'txtcontent_color',
                        'heading'    => esc_html__( 'Text Color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),

                    /*update*/
                    array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Icon Width', 'nb-elements'),
                    'param_name' => 'icon_width',
                    'value' => '',
                    'edit_field_class' => 'vc_col-sm-6', 
                    'dependency'  => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                    ),
                    array(
                        'type' => 'textfield',
                        'admin_label' => true,
                        'heading' => esc_html__('Icon Height', 'nb-elements'),
                        'param_name' => 'icon_height',
                        'value' => '',
                        'edit_field_class' => 'vc_col-sm-6', 
                        'dependency'  => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                    ),
                    /*end_update*/
                    
                    array(
                        'param_name' => 'title_font_primary',
                        'heading'    => esc_html__( 'Title Font Primary', 'udetor' ),
                        'type'       => 'checkbox',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    array(
                        'type' => 'textfield',
                        'admin_label' => true,
                        'heading' => esc_html__('Font size Title', 'nb-elements'),
                        'param_name' => 'font_size_title',
                        'value' => '',
                        'edit_field_class' => 'vc_col-sm-6',
                        'description'=> 'Example: 20px',
                    ),
                    array(
                        'param_name' => 'font_weight_title',
                        'heading'    => esc_html__( 'Font Weight Title', 'udetor' ),
                        'type'       => 'dropdown',  
                        'std' =>'normal',                      
                        'value'      => array(
                            __( 'normal', 'udetor' )   => 'normal',
                            __( 'bold', 'udetor' )  => 'bold', 
                            __( '600', 'udetor' )  => '600',
                        ),                        
                        
                    ),
                    array(
                        'param_name' => 'read_more',
                        'heading'    => esc_html__( 'Enable Read More?', 'udetor' ),
                        'type'       => 'checkbox',
                        
                    ),
                    array(
                        'param_name' => 'read_more_link',
                        'heading'    => esc_html__( 'Read more link', 'udetor' ),
                        'type'       => 'textfield',                        
                        'dependency' => array(
                            'element' => 'read_more',
                            'value'   => 'true',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_position',
                        'heading'    => esc_html__( 'Icon Position', 'udetor' ),
                        'type'       => 'dropdown',                        
                        'value'      => array(
                            __( 'Top', 'udetor' )   => 'top',
                            __( 'Left', 'udetor' )  => 'left',  
                            __( 'Right', 'nb-elements' )  => 'right',                          
                        ),
                        
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                    ),
                   
                    array(
                        'param_name'  => 'icon_fontawesome',
                        'heading'     => esc_html__( 'Icon', 'udetor' ),
                        'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                        'type'        => 'iconpicker',
                        'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                        'value'       => 'fa fa-adjust',
                        'settings'    => array(
                            'emptyIcon'    => false,
                            'iconsPerPage' => 4000,
                        ),
                        'dependency'  => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name'  => 'icon_icomoon',
                        'heading'     => esc_html__( 'Icon icomoon', 'udetor' ),
                        'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                        'type'        => 'iconpicker',
                        'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                        'value'       => '',
                        'settings' => array(
                            'emptyIcon' => true,
                            'type' => 'icomoon',
                            'iconsPerPage' => 200,
                        ),
                        'dependency'  => array(
                            'element' => 'style',
                            'value'   => 'icomoon',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_color',
                        'heading'    => esc_html__( 'Icon color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                        'value'      => '#ff4064',
                        'dependency' => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'bgicon_color',
                        'heading'    => esc_html__( 'Background Icon color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                        'value'      => '#fff',
                        'dependency' => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                    ),

                    array(
                        'param_name' => 'icon_style',
                        'heading'    => esc_html__( 'Icon Box Style', 'udetor' ),
                        'type'       => 'dropdown',
                        'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                        'value'      => array(
                            esc_html__('Select', 'udetor') => '',                        
                            esc_html__('Circle', 'udetor') => 'circle',
                            esc_html__('Square', 'udetor') => 'square',
                        
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                    ),
                    array(
                        'param_name' => 'icon_hover_color',
                        'heading'    => esc_html__( 'Icon Hover Color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_size',
                        'heading'    => esc_html__( 'Icon Size (px)', 'udetor' ),
                        'type'       => 'textfield',
                        'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                        'value'      => 24,
                        'dependency' => array(
                            'element' => 'style',
                            'value_not_equal_to'   => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'graphic',
                        'heading'    => esc_html__( 'Upload Image', 'udetor' ),
                        'type'       => 'attach_image',
                        'group'      => esc_html__( 'Image Settings', 'udetor' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'image_radius',
                        'heading'    => esc_html__( 'Border Radius (px)', 'udetor' ),
                        'type'       => 'textfield',
                        'group'      => esc_html__( 'Image Settings', 'udetor' ),
                        'value'      => 0,
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),
                
                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'editor_css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_services($atts, $content = null)
    {
        $customcolumn = $html = $txtcolor = $class = $classtitle = $css= $txtcontentcolor ='';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title_text' => '',
                    'style'                   => 'icon',
                    'align'                   => 'left',
                    'content_box'             => '',
                    'icon_position'           => 'top',
                    'text_color'              => '#333333',
                    'txtcontent_color'        => '',
                    'bgicon_color' => '#fff',
                    'icon_style' => 'square',
                    'read_more'               => '',
                    'title_font_primary'      => '',
                    'read_more_link'          => '',
                    'icon_fontawesome'        => 'fa fa-adjust',
                    'icon_color'              => '#d6aa74',
                    'icon_hover_color'        => '',
                    'icon_size'               => 24,
                    'graphic'                 => '',
                    'image_radius'            => 0,
                    'editor_css' => '',
                    'icon_width' => '',
                    'icon_height' => '',
                    'font_size_title' => '',
                    'extra_class' => '',
                    'font_weight_title' => 'normal',
                    'icon_icomoon' => '',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_services_');     
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $editor_css, ' ' ), 'netbase_services', $atts );     
        }
        if($align == 'center'){
            $class .='text-center';
        }elseif($align == 'left'){
            $class .='text-left';
        }else{
            $class .='text-right';
        }

        if($icon_position == 'left'){
            $class .=' icon-position-left';
        }elseif($icon_position == 'right'){
            $class .=' icon-position-right';
        }
        
        if($icon_style == 'circle'){
            $class .=' svicon-circle';
        }

        if($icon_width !=''){
            $css .= 'width:' . ( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).';' ;
            if($icon_position == 'left'){
                $customcolumn .=' width: calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');';
                $customcolumn .=' width: -webkit-calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');';
                $customcolumn .=' width: -moz-calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');' ;
            }
        }else{
            if($icon_position == 'left'){
                $customcolumn .=' width: calc(100% - 50px); width: -webkit-calc(100% - 50px); width: -moz-calc(100% - 50px);';                
            }
        }
        if($customcolumn){
            $customcolumn =' style="' . $customcolumn . '"';
        }
        if($icon_height !=''){
            $css .= 'height:' . ( is_numeric( trim( $icon_height ) ) ? trim( $icon_height ) . 'px' : trim( $icon_height ) ).';' ;
        }

        if ( $icon_size != '' ) {
            $css .= 'font-size:' . ( is_numeric( trim( $icon_size ) ) ? trim( $icon_size ) . 'px' : trim( $icon_size ) ).';' ;
        }
        if($icon_color){
            $css .='color: ' . esc_attr( $icon_color ).';' ;
        }
        if($bgicon_color){
            $css .='background-color: ' . esc_attr( $bgicon_color ).';' ;
        }

        if ( $css ) {
            $css = ' style="' . $css . '"';
        }
        
        if($font_weight_title !=''){
            $txtcolor .='font-weight:'. $font_weight_title.';';
        }

        if(isset($font_size_title) && $font_size_title){
            $sizepx = substr($font_size_title, -2,2);
            if($sizepx == 'px'){
                $txtcolor .='font-size:'. $font_size_title.';';
            }
        }

        if($text_color){
            $txtcolor .='color:'. esc_attr($text_color ).';';
        }
        if($txtcolor){
            $txtcolor =' style="' . $txtcolor . '"';
        }

        if($title_font_primary){
            $classtitle .=' font-h1';
        }
        if($txtcontent_color){
             $txtcontentcolor .='color:'. esc_attr($txtcontent_color ).';';
        }
        if($txtcontentcolor){
            $txtcontentcolor =' style="' . $txtcontentcolor . '"';
        }
        
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="'.esc_attr( $css_class ).' netbase-toolkit services '. esc_html($class) .'"  >';
        
        if ( 'icon' == $style ) {            
            $html .= '<div class="svicon-font" '.$css.'><span class="' . esc_attr( $icon_fontawesome ) .'" ></span></div>';
        }elseif('icomoon' == $style){
            $html .= '<div class="svicon-font" '.$css.'><span class="' . esc_attr( $icon_icomoon ) .'" ></span></div>';
        }
        else{
            if ( ! empty( $graphic ) ) {
                // Get image link and image data
                $image = wpb_getImageBySize( array( 'attach_id' => preg_replace( '/[^\d]/', '', $graphic ) ) );

                $html .= '<div class="image-icon"><img src="' . esc_url( $image['p_img_large'][0] ) . '" alt="' . esc_attr__( 'Separator', 'udetor' ) . '" width="' . esc_attr( $image['p_img_large'][1] ) . '" height="' . esc_attr( $image['p_img_large'][2] ) . '" /></div>';
            }
        }
        $html .= '<div class="content" '.$customcolumn.'>';
        $html .= '<h4 class="service-title '. esc_html($classtitle) .'" '. $txtcolor .'>' . wp_kses_post( $title_text ) . '</h4>';
        if($content_box){
            $html .= '<p class="sv-content-box" '. $txtcontentcolor .'>' . wp_kses_post( $content_box ) . '</p>';
        }
        
        if ( 'true' == $read_more ) {
                $html .= '<a class="more" href="' . esc_url( $read_more_link ) . '">' . __( 'Read more', 'udetor' ) . '</a>';
        }
        $html .= '</div>';
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_services', force_balance_tags($html));
    }

}
