<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Search_Form_Icon
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_search_form_icon', array(__CLASS__, 'shortcode_search_form_icon'));

    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map()
    {
        vc_map( array(
            'name'        => esc_html__( 'Udetor Search Form Icon', 'udetor' ),
            'base'        => 'netbase_search_form_icon',
            'category'    => esc_html__( 'Udetor Elements', 'udetor' ),
            'description' => esc_html__( 'Display Search Form.', 'udetor' ),
            'params'      => array(
                //Title
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading', 'udetor' ),
                    'param_name'  => 'title',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Write the title for the heading.', 'udetor' )
                ),

                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ) );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_search_form_icon($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'             => '',
                    'css'               => '',
                ),
                $atts
            )
        );
        
        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ),'netbase_search_form_icon', $atts );
        }
        ob_start();
        

        echo '<div class="header-search-wrap-popup">';
        echo '<span class="icon-header-search"><i class="fa fa-search " aria-hidden="true"></i></span>';
            echo '<div class="inner-search-wrap">';
                get_search_form();
            echo '</div>';
        echo '</div>';
        echo '<div class="close-search"></div>';
        
        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit search_form_icon '.$css_class.'" >' . ob_get_clean() . '</div>';
        

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_search_form_icon', force_balance_tags($html));
    }
}