<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Pricing_Table
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('netbase_pricing_table', array(__CLASS__, 'shortcode_pricing_table'));        
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map()
    {
        vc_map(array(
            'name' => esc_html__('Udetor: Pricing Table', 'udetor'),
            'base' => 'netbase_pricing_table',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Pricing Table.', 'udetor'),
            'icon' => 'icon-wpb-vc_carousel',
            'params' => array(
                
                array(
                     "type" => "textfield",
                     "holder" => "div",
                     "class" => "wpb_pricing_name",
                     "heading" => __("Plan Name",'udetor'),
                     "param_name" => "name",
                     "value" =>  ""
                ),
                  
                  array(
                     "type" => "dropdown",
                     "holder" => "div",
                     "class" => "wpb_pricing_plan",
                     "heading" => __("Plan Number",'udetor'),
                     "param_name" => "plan",
                     'value'      => array(
                            __( 'Style edu', 'udetor' ) => 'edu',
                            __( 'Style Fitness', 'udetor' ) => 'style_fitness',
                            __( 'Style 1', 'udetor' ) => '1',
                            __( 'Style 2', 'udetor' ) => '2',
                            __( 'Style 3', 'udetor' ) => '3',
                            __( 'Style 4', 'udetor' ) => '4',
                            __( 'Style 5', 'udetor' ) => '5',
                        ),
                  ),
                  
                  array(
                     "type" => "textfield",
                     "holder" => "div",
                     "class" => "wpb_pricing_currency",
                     "heading" => __("Currency",'udetor'),
                     "param_name" => "currency",
                     'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                     "value" =>  "$"
                  ),
                  
                  array(
                     "type" => "textfield",
                     "holder" => "div",
                     "class" => "wpb_pricing_price",
                     "heading" => __("Price",'udetor'),
                     "param_name" => "price",
                     'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                     "value" =>  ""
                  ),
                  
                  array(
                     "type" => "textfield",
                     "holder" => "div",
                     "class" => "wpb_quote_cycle",
                     "heading" => __("Payment Cycle",'udetor'),
                     "param_name" => "cycle",
                     'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                     "value" =>  "month"
                  ),
                  
                  array(
                     "type" => "textarea",
                     "holder" => "div",
                     "class" => "wpb_pricing_content",
                     "heading" => __("Plan Details",'udetor'),
                     "param_name" => "content",
                     "value" =>  "<ul><li>Add the detail items in the LI tag</li>
                     <li>Add the detail items in the LI tag</li></ul>"
                  ),
                  
                   array(
                     "type" => "textfield",
                     "holder" => "div",
                     "class" => "wpb_pricing_button_text",
                     "heading" => __("Button Text",'udetor'),
                     "param_name" => "linktext",
                     "value" =>  ""
                  ),
                  
                  array(
                     "type" => "textfield",
                     "holder" => "div",
                     "class" => "wpb_pricing_link hide",
                     "heading" => __("Button Link",'udetor'),
                     "param_name" => "link",
                     'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                     "value" =>  ""
                  ),
                  
                  array(
                     "type" => "dropdown",
                     "holder" => "div",
                     "class" => "wpb_pricing_target hide",
                     "heading" => __("Link Target",'udetor'),
                     "param_name" => "target",
                     'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                     "value" => array('_self','_blank'),
                     "description" => __("Select '_blank' - open the link in new window, select '_self' - open in same window",'udetor')
                  ),
                  array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Make this pricing box as featured', 'udetor'),
                    'param_name' => 'featured',    
                    'std' => false,                                   
                    ),  
                    array(
                        'heading'     => __( 'Image logo', 'udetor' ),
                        'param_name'  => 'logo',
                        'type'        => 'attach_image',                                                
                        'dependency'  => array(
                            'element' => 'plan',
                            'value'   => 'style_fitness'
                        ),
                    ),
                  
                  array(
                     "type" => "dropdown",
                     "holder" => "div",
                     "class" => "custom_hide_field",
                     "heading" => __("CSS Animation","focux"),
                     "param_name" => "css_animation",
                     "value" => array(
                      'no'=>'',
                      'Top to bottom'=>'top-to-bottom',
                      'Bottom to top'=>'bottom-to-top',
                      'Left to right'=>'left-to-right',
                      'Right to left'=>'right-to-left',
                      'Appear from center'=>'appear'
                     ),
                     "description" => __("Select animation type if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.",'udetor')
                  ),                  
            )
        ));
    }

   
    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_pricing_table($atts, $content = null)
    {
        $html = $css = $vc_css= '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'currency'=>'$',
                    'price' => '',
                    'cycle' =>'month',
                    'name' => '',
                    'plan' => 'edu',
                    'link'=>'',
                    'linktext'=>'More',
                    'target'=>'_self',
                    'featured' =>false,
                    'logo' =>'',
                    'css_animation' =>''                    
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_pricing_');

        // Get toolkit style
        /*if ($style) {
            $classes[] = $style;
        }        
        if ( $txt_color != '') {
            $css .= 'color:' . $txt_color . ';';
        }
        if ( $font_size != '' ) {
            $css .= 'font-size:' . $font_size . 'px;';
        }
        if ( $css ) {
            $css = ' style="' . $css . '"';
        }*/

        if($css_animation<>''){
            $vc_css=' wpb_animate_when_almost_visible wpb_'.$css_animation;
        }

        if (  $featured ) {
            $css= 'package_featured';
        }

        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit udetor-pricetable '.$css.' ">';
        
        $html .='<div class="pricetable '.$vc_css.'" >
           <div class="plan plan'.$plan.'">
                   <figure>
                     <figcaption class="font-h1">'.$name.'</figcaption>
                     <div class="price"><div class="pitem"><span class="font-h1">'.$currency.''.$price.'</span><div class="pcycle">'.$cycle.'</div></div></div>';
                        if($logo !== ''){
                            $src_logo = wp_get_attachment_image_src((int) $logo, 'full', false);
                            $html .= '<img class="the-member" src="' . $src_logo[0] . '" alt="member">';
                        }
                    $html .='</figure>
                   <div class="plan-content">'.$content.'</div>
                   <footer><a href="'.$link.'" target="'.$target.'" class="built-in-btn">'.$linktext.'</a></footer></div></div>';
        
        $html .= '</div>';
        wp_reset_postdata();

        return apply_filters('netbase_shortcode_pricing_table', force_balance_tags($html));
    }
   
}