<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */


class Netbase_Toolkit_Element_Popular_Courses
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_popular_courses', array(__CLASS__, 'shortcode_popular_courses'));
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );
    }

    public static function enqueue_scripts() {
       
        wp_enqueue_script( 'element', NETBASE_TOOLKIT_URL . 'assets/js/element/element.js', array(), false, true );

    }
    public static function map()
    {
        $categories = get_terms( 'course_category' );
        $categories_dropdown[] = array(
                'label' => 'Select categories',
                'value' => '',
        );
        foreach ($categories as $category) {
                $name = $category->name;
                $value = $category->slug;
                $categories_dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
        }    
        vc_map( array(
            'name'        => esc_html__( 'Udetor: Popular Courses', 'udetor' ),
            'base'        => 'netbase_popular_courses',
            'category'    => esc_html__( 'Udetor Elements', 'udetor' ),
            'description' => esc_html__( 'Display List Courses.', 'udetor' ),
            'icon' => 'udetor-widget-icon udetor-widget-icon-list-courses',
            'params'      => array(
                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Title', 'udetor' ),
                    'param_name'  => 'title',
                    'value'       => '',
                ),
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Number events display', 'udetor' ),
                    'param_name'  => 'number_posts',
                    'std'         => '2',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',
                        esc_html__( '5', 'udetor' )      => '5',
                        esc_html__( '6', 'udetor' )      => '6',
                        esc_html__( '7', 'udetor' )      => '7',
                        esc_html__( '8', 'udetor' )      => '8',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Category', 'udetor' ),
                    'param_name'  => 'category',
                    'value' =>$categories_dropdown,
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,          
                    'heading'     => esc_html__( 'Style', 'udetor' ),          
                    'param_name'  => 'style_gird',
                    'std'         => 'default',
                    'value'       => array(                        
                        esc_html__( 'default', 'udetor' )      => 'default',
                        esc_html__( 'multi color', 'udetor' )      => 'multi_color',
                        
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Colunms posts', 'udetor' ),
                    'param_name'  => 'colunms_posts',
                    'std'         => '3',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' ) => '',
                        esc_html__( '1', 'udetor' )      => '1',
                        esc_html__( '2', 'udetor' )      => '2',
                        esc_html__( '3', 'udetor' )      => '3',
                        esc_html__( '4', 'udetor' )      => '4',                        
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text View All', 'udetor' ),
                    'param_name'  => 'text_link',
                    'std'         => esc_html__( 'View All', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ) );
    }    

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_popular_courses($atts, $content = null)
    {
        $html = $attr_parent = $loadmore = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'        => '',
                    'category'       => '',
                    'number_posts' => '2',
                    'colunms_posts'    =>'3',
                    'style_gird' => 'default',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        ob_start();
        // Generate HTML code.
        set_query_var( 'colunms_courses', $colunms_posts );   

        $args = array(
            'post_type' => 'sfwd-courses',
            'ignore_sticky_posts' => 1,
            'post_status' => 'publish',
            'posts_per_page' => $number_posts,
            'orderby' => 'meta_value_num',  'order' => 'desc',
            /*'tax_query' => array(
                array(
                'taxonomy' => 'course_category',
                'field' => 'slug',
                'terms' => $category
            ))*/
            
        );     
        if($category &&  $category !=''){
            $args_tax_query = array(
            'tax_query' => array(
                array(
                'taxonomy' => 'course_category',
                'field' => 'slug',
                'terms' => $category
            ))) ; 
            $args = $args + $args_tax_query;
        }         

        $popular = new WP_Query( $args );

                
                    if($style_gird =='multi_color' ){
                        while ($popular->have_posts()) : $popular->the_post(); 
                        switch ($colunms_posts){
                            case '1': $class_wap_courses= 'col-md-12'; break;
                            case '2': $class_wap_courses= 'col-md-6'; break;
                            case '3': $class_wap_courses= 'col-md-6 col-sm-6 col-lg-4'; break;
                            case '4': $class_wap_courses= 'col-md-6 col-sm-6 col-lg-3'; break;
                            default : $class_wap_courses= 'col-md-6 col-sm-6 col-lg-4';
                        }
                        $options = get_option('sfwd_cpt_options');
                        $currency = null;
                        if(!is_null($options)){
                            if(isset($options['modules']) && isset($options['modules']['sfwd-courses_options']) && isset($options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'])){
                                $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
                            }
                        }
                        if(is_null($currency)){
                            $currency = 'USD';
                        }
                        $course_options = get_post_meta(get_the_ID(),'_sfwd-courses', true);
                        $price = $course_options && isset($course_options['sfwd-courses_course_price']) ?
                                $course_options['sfwd-courses_course_price']
                                : esc_html__('Free', 'udetor');
                        if($price==''){
                            $price .= esc_html__('Free', 'udetor');
                        }

                        if(is_numeric($price)){
                            if($currency == "USD"){
                            $price = '$' . $price;
                            } else {
                            $price .= ' ' . $currency;
                            }
                        }
                        ?>
                        <article class="ld-entry-content entry-content course-item <?php echo esc_html($class_wap_courses); ?> style-3">  
                            <div class="course-item-wap">
                                <div class="thumbnail">
                                    <a href="<?php the_permalink(); ?>" title="<?php echo the_title_attribute( 'echo=0' ); ?>" rel="bookmark">
                                        <?php if ( has_post_thumbnail() ) :                 
                                            the_post_thumbnail('udetor-blog-thumb');
                                        endif; ?>
                                    </a>        
                                </div>
                                <div class="entry-course">
                                <?php the_title( '<h2 class="ld-entry-title entry-title"><a href="' . esc_url( get_permalink() ) . '" title="' . the_title_attribute( 'echo=0' ) . '" rel="bookmark">', '</a><span></span></h2>' ); ?>
                                <div class="wrap-content">
                                    <div class="gird-course">
                                        <a href="<?php echo esc_url( get_permalink() ); ?>" >
                                            <span><?php echo $price ?></span>
                                        </a>
                                        <?php echo Udetor_Helper::udetor_reviews_star(get_the_ID()); ?>
                                    </div>
                                    <div class="infor-course">
                                        <?php 
                                        $enrolment_ages = get_post_meta(get_the_ID(),'_enrolment_ages', true);
                                        if($enrolment_ages && $enrolment_ages !=''){
                                            echo '<div class="date-course"><span class="icomoon icon-abc"></span>';
                                            echo $enrolment_ages;
                                            echo '</div>';
                                        }
                                        
                                        if(get_post_meta(get_the_ID(),'maximum_students', true)):
                                        echo '<div class="course-students"><span class="icomoon icon-group"></span>'.get_post_meta(get_the_ID(),'maximum_students', true).' class size</div>';
                                        endif;
                                        ?>   
                                        <div class="course-apply clear">
                                            <a href="<?php echo esc_url( get_permalink() ); ?>" ><span><?php esc_html_e('Enjoy class', 'udetor');?></span></a> 
                                        </div> 
                                    </div>
                                    <span class="bg-style"><span class="bg-child"></span></span>
                                </div>
                            </div>
                            </div>
                        </article>
                        <?php
                        endwhile;
                    }else{
                        while ($popular->have_posts()) : $popular->the_post(); 
                        get_template_part( 'learndash/course_list_template');  
                        endwhile;      
                    }
                
                
                wp_reset_query();

        // Generate HTML code.
        $loadmore = '<div class="load-more"><a href="'.esc_url( home_url( '/courses/' )) .'" class="btn-more">LOAD MORE CLASSES </a></div>';
        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit list-courses row">' . ob_get_clean() . ''.$loadmore.'</div><!-- .netbase-toolkit -->';
        wp_reset_postdata();

        return apply_filters('netbase_shortcode_popular_courses', force_balance_tags($html));
    }

}
