<?php
/**
 * Created by PhpStorm.
 * Date: 7/25/2017
 * Time: 4:52 PM
 *
 *C:\xampp\htdocs\test\wp-content\themes\udetor-theme\udetor\includes\megamenu\walker.php
 */

include_once get_template_directory() . '/udetor/includes/megamenu/walker.php';

class custom_walker_nav_menu extends Udetor_MegaMenu_Walker
{

    function start_lvl(&$output, $depth = 0, $args = array())
    {
        parent::start_lvl($output, $depth, $args); // TODO: Change the autogenerated stub
    }

    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {

        $indent = ( $depth > 0 ? str_repeat( "\t", $depth ) : '' ); // code indent

        // depth dependent classes
        $depth_classes = array(
            ( $depth == 0 ? 'edu-menu-item' : 'edu-sub-menu-item' ),
            ( $depth >=2 ? 'sub-sub-menu-item' : '' ),
            ( $depth % 2 ? 'menu-item-odd' : 'menu-item-even' ),
            'menu-item-depth-' . $depth
        );
        $depth_class_names = esc_attr( implode( ' ', $depth_classes ) );

        // passed classes
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $class_names = esc_attr( implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) ) );

        // build html
        $output .= $indent . '<li id="nav-menu-item-'. $item->ID . '" class="' . $depth_class_names . ' ' . $class_names . '">';

        // link attributes
        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
        $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
        $attributes .= ' class="menu-link ' . ( $depth > 0 ? 'edu-sub-menu-item-link' : 'edu-menu-item-link' ) . '"';


        $custom_link = '';
        $title = apply_filters('the_title', $item->title, $item->ID);

        if ($args->walker->has_children) {
            $custom_link .= '<span class="edu-menu-title">';
            $custom_link .= $title;
            $custom_link .= '</span>';
            $custom_link .= '<i class="icon-has-children fa fa-angle-down"></i>';
        }else{
            $custom_link .= '<span class="edu-menu-title">';
            $custom_link .= $title;
            $custom_link .= '</span>';
        }


        $item_output = sprintf( '%1$s<a%2$s>%3$s%4$s%5$s</a>%6$s',
            $args->before,
            $attributes,
            $args->link_before,
            // custom output
            $custom_link,
//            apply_filters( 'the_title', $item->title, $item->ID ),
            $args->link_after,
            $args->after
        );

        // build html
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );



    }
}