<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_List_Posts
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('netbase_list_post', array(__CLASS__, 'shortcode_list_post'));
    }

    public static function map()
    {

        include NETBASE_TOOLKIT_PATH . 'elements/options/list-posts.php';
        
        $affvc = element_options('vc',$options);
        

        vc_map( array(
            'name'        => esc_html__( 'Udetor: List Posts', 'udetor' ),
            'base'        => 'netbase_list_post',
            'category'    => esc_html__( 'Udetor Elements', 'udetor' ),
            'description' => esc_html__( 'Display list posts.', 'udetor' ),
            'icon' => 'udetor-widget-icon udetor-widget-icon-list-post',
            'params'      => $affvc ,

            
        ) );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_list_post($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'            => '',
                    'cat_slug'           => '',
                    /*'image_size'       => 'none',*/
                    /*'show_description' => false,*/
                    'number_posts'     => '4',
                    /*'colunms_posts'    =>'3',*/
                    /*'layout'           => 'base',*/
                    'display_feature'  => '',
                    'item_vertical'    => '0',
                    'orderby'          => 'recent',
                    'order'            => 'asc',
                    'link'             => '',
                    'text_link'        => esc_html__( 'Browse more', 'udetor' ),
                    'style'            => '',
                    'columns' => '3',  
                    'slider'                => true,
                    'columnstablet' =>'',    
                    'columnstablets' => '',           
                    'nav_position' => 'bottom',
                    'pagination'   => '',
                    'navigation'   => '',
                    'autoplay'     => '',
                    'loop'         => '', 
                    'margin'       => 30,
                    'dots_size' => 'small',
                ),
                $atts
            )
        );        

        // Filter post type.
        $args = array(
            'category_name' => $cat_slug,
            'post_type'           => 'post',
            'orderby'             => $orderby,
            'order'               => $order,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'posts_per_page'      => $number_posts,
            'no_found_rows' => true,
        );

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        // Get query object.
        $the_query = new WP_Query( $args );

        ob_start();
        // Generate HTML code.
        //set_query_var( 'colunms_post', $colunms_posts );
        $classes = $attr = array();
        $data_owlcarousel = '';

        if($style){
                $classes[] =' post-style-'.$style.' ';   
            }

            if ( ! empty( $slider ) ) {
                if($margin){
                    
                    $attr[] = '"margin": "' . ( int ) $margin . '"';
                }
                
                if ( $navigation ) {
                    $attr[] = '"nav": "true"';
                }
                if ( $pagination ) {
                    $attr[] = '"dots": "true"';
                }
                
                if ( ! empty( $columnstablets ) ) {
                    $attr[] = '"tablet": "' . ( int ) $columnstablets . '"';
                }
                if ( ! empty( $columnstablet ) ) {
                    $attr[] = '"ades": "' . ( int ) $columnstablet . '"';
                }
                if ( ! empty( $columns ) ) {
                    $attr[] = '"items": "' . ( int ) $columns . '"';
                }
                if($autoplay){
                    $attr[] = '"autoplay": "true"';
                }
                if($loop){
                    $attr[] = '"loop": "true"';
                }

                if ( ! empty( $attr ) ) {
                    $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
                }            

                if($dots_size && $pagination){
                    $classes[] =' dots-'.$dots_size.' ';
                }                

                if ( $nav_position && $navigation) {
                    $classes[] =' nav-'.$nav_position.' ';
                }                

                $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
        }

        if($style && $style=='list'){
            if($title){
                echo '<h3 class="font-h1 udetor-detail-title">'. esc_html($title) .'</h3>';    
            }            
            echo '<ul class="plst">';
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();  
                    echo '<li>';
                        echo '<div class="featured-date">';
                            the_time('F j, Y');
                        echo '</div>'; ?>
                        <p class="plst-title" ><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>" ><?php the_title(); ?></a></p>
                    <?php                              
                    echo '</li>';
                }
            echo '</ul>';
            if($cat_slug && $cat_slug !=''){
                // Get the URL of this category
                $cat = get_category_by_slug($cat_slug); 
                $catID = $cat->term_id;
                $category_link = get_category_link( $catID );
                echo '<a href="'.esc_url( $category_link ).' " title="Category Name" class="secondary_btn">'. esc_html__( 'See all', 'udetor' ) .'</a>';
            }

        }
        elseif($style == 'grid'){            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();   
                ?>
                <div class="blog-item">
                    <?php
                    if( has_post_thumbnail( ) ) {
                        echo '<div class="post-thumbnail">';
                            echo '<a href="' . esc_url( get_permalink() ) . '">';
                            the_post_thumbnail('udetor-blog-thumb');
                            echo '</a>'; 
                        echo '</div>'; 
                    }
                    ?>
                    <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                        <?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        echo '<div class="featured-date">';
                            the_time('j F, Y');
                        echo '</div>';
                        if ( has_excerpt() ){
                            echo '<div class="entry-excerpt heading3">';                                   
                                echo wp_trim_words( get_the_excerpt(), 14, '...' );
                            echo '</div>';
                        }
                        ?>
                        <div class="blog-meta-info">
                            <div class="blog-author">
                                <?php
                                $byline = sprintf(
                                    esc_html_x( '%s', 'post author', 'udetor' ),
                                    '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
                                );  
                                echo '<div class="author-wap">';     
                                echo get_avatar( get_the_author_meta('email'), '30' ); 
                                echo $byline; 
                                echo '</div>';
                                ?>
                            </div>
                            <div class="blog-meta">
                                <?php
                                if(function_exists('the_views')) { 
                                    echo '<div class="meta-views">';
                                            echo '<i class="fa fa-eye"></i>';
                                            the_views();                        
                                    echo '</div>';
                                }
                                echo '<div class="comments-link">';
                                if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
                                        echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                                        comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );                        
                                        }
                                echo '</div>';
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
            }
        }
        elseif($style == 'wave'){            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();
                $byline = sprintf(
                    esc_html_x( '%s', 'post author', 'udetor' ),'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span> . '
                );    
                ?>
                <div class="blog-item">
                    <?php
                    if( has_post_thumbnail( ) ) {
                        echo '<div class="post-thumbnail">';
                            echo '<a href="' . esc_url( get_permalink() ) . '">';
                            the_post_thumbnail('udetor-blog-thumb');
                            echo '</a>'; 
                        echo '</div>'; 
                    }
                    ?>
                    <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                        <?php 
                        echo '<div class="featured-date">';
                            echo $byline; 
                            the_time('j F, Y');
                        echo '</div>';
                        echo '<div class="wrap-text">';
                        the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        if ( has_excerpt() ){
                            echo '<div class="entry-excerpt heading3">';                                   
                                echo wp_trim_words( get_the_excerpt(), 14, '...' );
                            echo '</div>';
                        }
                        echo '</div>';
                        ?>
                    </div>
                </div>

                <?php
            }
        }elseif($style == 'multi-color'){
            while ( $the_query->have_posts() ) {
                $the_query->the_post();
                $byline = sprintf(
                    esc_html_x( '%s', 'post author', 'udetor' ),'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span> . '
                );  
            ?>
            <div class="blog-item">
                <?php
                if( has_post_thumbnail( ) ) {
                    echo '<div class="thumbnail">';
                        echo '<a href="' . esc_url( get_permalink() ) . '">';
                        the_post_thumbnail('udetor-blog-thumb');
                        echo '</a>'; 
                    echo '</div>'; 
                }
                ?>
                <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                    <?php 
                    echo '<div class="featured-date">';
                        echo $byline; 
                        the_time('j F, Y');
                    echo '</div>';
                    echo '<div class="wrap-text">';
                    the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                    echo '<a href="'.esc_url( get_permalink()).'" class="multi-btn"><span>'.esc_html__( 'Enjoy class','udetor' ).'</span></a>';
                    echo '</div>';
                    ?>
                </div>
            </div>
            <?php
            }
        }else{            
            while ( $the_query->have_posts() ) {
                $the_query->the_post();                           
            ?>  
            <div class="blog-item">
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>       
                    <div class="entry-content">
                            <?php
                            if( has_post_thumbnail( ) ) {
                                echo '<div class="post-thumbnail">';
                                    echo '<a href="' . esc_url( get_permalink() ) . '">';
                                    the_post_thumbnail('udetor-blog-thumb');
                                    echo '</a>';                                
                                ?>
                                <ul class="post-meta">
                                    <li class="meta-reading-time">
                                    <?php
                                        if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
                                        echo  wp_kses(__(' <i class="fa fa-comment"></i> ', 'udetor'), array('i' => array('class' => array())));
                                        comments_popup_link( esc_html__( '0', 'udetor' ), esc_html__( '1', 'udetor' ), esc_html__( '%', 'udetor' ) );                        
                                        }
                                    ?>
                                    </li>
                                    <?php if(function_exists('the_views')) { 
                                    echo '<li class="meta-views">';
                                        echo '<i class="fa fa-eye"></i>';
                                        the_views();                        
                                    echo '</li>';
                                    }
                                    ?>
                                    
                                <?php
                                echo '</div>';
                            }
                            ?>
                            <div class="udetor-blog-info <?php if( has_post_thumbnail( ) ) { echo 'lst-with-thumb'; } ?>">
                                <?php
                                if ( 'post' === get_post_type() ) : ?>
                                    <div class="entry-meta post-meta heading3">
                                        <?php Udetor_Template_Tags::udetor_posted_meta(); ?>
                                    </div>
                                <?php
                                endif;                                
                                the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );                                
                                if ( has_excerpt() ){
                                    echo '<div class="entry-excerpt heading3">';                                   
                                        echo wp_trim_words( get_the_excerpt(), 30, '...' );
                                    echo '</div>';
                                }
                                ?>
                                <a href="<?php the_permalink(); ?>" class="read-more secondary_btn"><span><?php echo esc_html__( 'Read more','udetor' ); ?></span></a>
                            </div>                           
                        </div>
                    </article>
                </div>
                <?php
            }
            
        }

        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit list-post '. esc_attr( implode( ' ', $classes ) ) .'"  '.$data_owlcarousel.'>' . ob_get_clean() . '</div>';
        if($style == 'grid' || $style == 'wave'){
            if($cat_slug && $cat_slug !=''){
                // Get the URL of this category
                $cat = get_category_by_slug($cat_slug); 
                $catID = $cat->term_id;
                $category_link = get_category_link( $catID );
                $html .= '<div class="netbase-toolkit list-post-grid-btn">';
                $html .= '<a href="'.esc_url( $category_link ).' " title="Category Name" class="browse_btn">'. $text_link .'</a>';
                $html .= '</div>';
            }
        }

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_list_post', force_balance_tags($html));
    }
}
