<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_HText {
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize() {
        // Add map for vc
        if ( class_exists( 'Vc_Manager' ) ) {
            add_action( 'init', array( __CLASS__, 'map' ) );
        }

        // Add shortcode
        add_shortcode( 'netbase_htext', array( __CLASS__, 'shortcode_htext' ) );

    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map() {
        $order_by_values = array(
            '',
            __( 'Date', 'udetor' )          => 'date',
            __( 'ID', 'udetor' )            => 'ID',
            __( 'Author', 'udetor' )        => 'author',
            __( 'Title', 'udetor' )         => 'title',
            __( 'Modified', 'udetor' )      => 'modified',
            __( 'Random', 'udetor' )        => 'rand',
            __( 'Comment count', 'udetor' ) => 'comment_count',
            __( 'Menu order', 'udetor' )    => 'menu_order',
        );
        $order_way_values = array(
            '',
            __( 'Descending', 'udetor' ) => 'DESC',
            __( 'Ascending', 'udetor' )  => 'ASC',
        );

        // Get all terms of toolkit
        $htext_cat = array(
            __( 'All', 'udetor' ) => '',
        );
        $terms = get_terms( 'htext_cat' );
        if ( $terms && ! isset( $terms->errors ) ) {
            foreach ( $terms as $key => $value ) {
                $htext_cat[$value->name] = $value->term_id;
            }
        }

        // Map new Toolkit element.
        vc_map(
            array(
                'name'     => __( 'Text', 'udetor' ),
                'base'     => 'netbase_htext',
//				'icon'     => 'fa fa-picture-o',
                'category' => __( 'Udetor Elements', 'udetor' ),
                'params'   => array(
                    array(
                        'type' => 'textarea_html',
                        'holder' => 'div',
                        'heading' => __( 'Text', 'udetor' ),
                        'param_name' => 'content',
                        'value' => __( '<p>I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>', 'udetor' ),
                    ),
                    array(
                        'param_name' => 'enable_center',
                        'heading'    => __( 'Enable center element', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),
                    ),
                    array(
                        'heading'     => __( 'Position', 'udetor' ),
                        'param_name'  => 'icon_box_position',
                        'type'        => 'dropdown',
                        'std'         => 'left',
                        'value'       => array(
                            __( 'Left', 'udetor' )     => 'left',
                            __( 'Center', 'udetor' )     => 'center',
                            __( 'Right', 'udetor' )    => 'right',
                        ),
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Extra class name', 'udetor' ),
                        'param_name' => 'extra_class',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Custom id name', 'udetor' ),
                        'param_name' => 'custom_id',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'udetor' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'udetor' ),
                    )
                )
            )
        );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_htext( $atts, $content = null ) {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'logo_type'             => 'image',
                    'regular_logo'          => '',
                    'retina_logo'           => '',
                    'logo_width'            => '138',
                    'logo_content'          => 'Text',
                    'color'                 => '#000000',
                    'font_size'             => '20',
                    'font_weight'           => '400',
                    'font_style'            => 'normal',
                    'line_height'           => '20',
                    'letter_spacing'        => '0',
                    'enable_center'         => 'no',
                    'extra_class'           => '',
                    'custom_id'             => '',
                    'css'                   => '',
                    'icon_box_position'     => 'left',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid( 'netbase_custom_css_' );

        // Get toolkit style

        $classes = [];
        if ($enable_center == 'yes') {
            $classes[] = 'align-self-stretch';
            $classes[] = 'edu-element-center';
        }

        // position
        $pclasses['style-p'] = '';
        switch ($icon_box_position) {
            case 'left':
                $pclasses['style-p'] .= 'float:left;';
                break;
            case 'right':
                $pclasses['style-p'] .= 'float:right;';
                break;
            case 'center':
                $pclasses['style-p'] .= 'margin:auto;';
                break;
        }

        // add custom class
        if ($extra_class !== '') {
            $classes[] = $extra_class;
        }

        // add custom id
        if ($custom_id !== '') {
            $id = $custom_id;
        }

        // get class css
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, ''));
        }
        // Generate HTML code.
        $html .= '<div style="'.$pclasses['style-p'].'" id="' . esc_attr($id) .'" class="' . $css_class . ' edu-element edu-element-htext';

        foreach ($classes as $class) {
            $html .= ' ';
            $html .= $class;
        }
        $html .= '">';
            $html .= '<div class="content-htext">';
                $html .= '<p>'.$content.'</p>';
            $html .= '</div>';
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters( 'netbase_shortcode_htext', force_balance_tags( $html ) );
    }


    
}
