<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_HSocials {
	/**
	 * Initialize.
	 *
	 * @return  void
	 */
	public static function initialize() {
		// Add map for vc
		if ( class_exists( 'Vc_Manager' ) ) {
			add_action( 'init', array( __CLASS__, 'map' ) );
		}

		// Add shortcode
		add_shortcode( 'netbase_hsocials', array( __CLASS__, 'shortcode_hsocials' ) );

		// Enqueue script
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );
	}

	/**
	 * Map new parameters and elements.
	 *
	 * @since  1.0
	 * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
	 */
	public static function map() {
		$order_by_values = array(
			'',
			__( 'Date', 'udetor' )          => 'date',
			__( 'ID', 'udetor' )            => 'ID',
			__( 'Author', 'udetor' )        => 'author',
			__( 'Title', 'udetor' )         => 'title',
			__( 'Modified', 'udetor' )      => 'modified',
			__( 'Random', 'udetor' )        => 'rand',
			__( 'Comment count', 'udetor' ) => 'comment_count',
			__( 'Menu order', 'udetor' )    => 'menu_order',
		);
		$order_way_values = array(
			'',
			__( 'Descending', 'udetor' ) => 'DESC',
			__( 'Ascending', 'udetor' )  => 'ASC',
		);

		// Get all terms of toolkit
		$hsocials_cat = array(
			__( 'All', 'udetor' ) => '',
		);
		$terms = get_terms( 'hsocials_cat' );
		if ( $terms && ! isset( $terms->errors ) ) {
			foreach ( $terms as $key => $value ) {
				$hsocials_cat[$value->name] = $value->term_id;
			}
		}

		// Map new Toolkit element.
		vc_map(
			array(
				'name'     => __( 'Socials', 'udetor' ),
				'base'     => 'netbase_hsocials',
//				'icon'     => 'fa fa-picture-o',
				'category' => __( 'Udetor Elements', 'udetor' ),
				'params'   => array(
					array(
						'heading'     => __( 'Style icon', 'udetor' ),
						'param_name'  => 'style_icon',
						'type'        => 'dropdown',
                        'std'         => 'none',
						'value'       => array(
                            __( 'None', 'udetor' )     => 'none',
                            __( 'Custom', 'udetor' )    => 'custom',
                        ),
						'admin_label' => true,
					),
                    array(
                        'param_name' => 'icon_color',
                        'heading'    => __( 'Icon color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'background_color',
                        'heading'    => __( 'Background color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '',
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'custom'
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Border style', 'udetor' ),
                        'param_name'  => 'border_style',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'         => 'None',
                        'value'       => array(
                            __('None', 'udetor')      => 'none',
                            __('Solid', 'udetor')     => 'solid',
                            __('Dashed', 'udetor')    => 'dashed',
                            __('Dotted', 'udetor')    => 'dotted',
                            __('Double', 'udetor')    => 'double',
                            __('Groove', 'udetor')    => 'groove',
                            __('Inset', 'udetor')     => 'inset',
                            __('Outset', 'udetor')    => 'outset',
                            __('Ridge', 'udetor')     => 'ridge',
                        ),
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'custom'
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Border width', 'udetor' ),
                        'param_name'  => 'border_width',
                        'type'        => 'textfield',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'value'       => '1',
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'custom'
                        ),
                    ),
                    array(
                        'param_name' => 'border_color',
                        'heading'    => __( 'Border color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#000000',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'custom'
                        ),
                    ),
                    array(
                        'heading'     => __( 'Border radius', 'udetor' ),
                        'param_name'  => 'border_radius',
                        'type'        => 'textfield',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'value'       => '0',
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'custom'
                        ),
                    ),
                    array(
                        'heading'     => __( 'Icon spacing', 'udetor' ),
                        'param_name'  => 'icon_spacing',
                        'type'        => 'textfield',
                        'std'         => '5',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Icon size', 'udetor' ),
                        'param_name'  => 'icon_size',
                        'type'        => 'dropdown',
                        'std'         => 'small',
                        'value'       => array(
                            __( 'Tiny', 'udetor' )     => 'tiny',
                            __( 'Small', 'udetor' )     => 'small',
                            __( 'Normal', 'udetor' )    => 'normal',
                            __( 'Large', 'udetor' )    => 'large',
                        ),
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),                    

                    array(
                        'param_name' => 'enable_center',
                        'heading'    => __( 'Enable center element', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),

                    ),
                    array(
                        'heading'     => __( 'Position', 'udetor' ),
                        'param_name'  => 'icon_box_position',
                        'type'        => 'dropdown',
                        'std'         => 'left',
                        'value'       => array(
                            __( 'Left', 'udetor' )     => 'left',
                            __( 'Center', 'udetor' )     => 'center',
                            __( 'Right', 'udetor' )    => 'right',
                        ),
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
					array(
                        'heading'    => __( 'Extra class name', 'udetor' ),
						'param_name' => 'extra_class',
						'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
					),
                    array(
                        'heading'    => __( 'Custom id name', 'udetor' ),
                        'param_name' => 'custom_id',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'udetor' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'udetor' ),
                    )
				)
			)
		);
	}

	/**
	 * Add shortcode toolkit.
	 *
	 * @since  1.0
	 */
	public static function shortcode_hsocials( $atts, $content = null ) {
		$html = $attr_parent = '';

		// Extract shortcode parameters.
		extract(
			shortcode_atts(
				array(
					'style_icon'            => 'none',
					'icon_color'            => '',
					'icon_size'             => 'small',
					'icon_box_position'     => 'left',
					'background_color'      => '',
					'border_color'          => '#000000',
					'border_style'          => 'none',
					'border_width'          => '1',
					'border_radius'         => '0',
					'line_height'           => '20',
					'letter_spacing'        => '0',
					'enable_center'         => 'no',
					'icon_spacing'          => '2',
					'extra_class'           => '',
					'custom_id'             => '',
					'css'                   => '',
				),
				$atts
			)
		);

		// social
        $socials = [
            'facebook' => 'fa fa-facebook',
            'twitter'  => 'fa fa-twitter',
            'google-plus'   => 'fa fa-google-plus'
        ];


		// Generate custom ID
        $id = ($custom_id !== '') ? $custom_id : uniqid( 'netbase_custom_css_' );

        // Generate custom Class
        $classes['extra_class'] = ($extra_class !== '') ? $extra_class : '';

		// get color social
        $classes['style-icon'] = 'style="';
        if ($icon_color !== '') {
            $classes['style-icon'] .= 'color: ' . $icon_color . ';';
        }
        $classes['style-icon'] = '"';


        // position
        $classes['style-p'] = '';
        switch ($icon_box_position) {
            case 'left':
                $classes['style-p'] .= 'float:left;';
                break;
            case 'right':
                $classes['style-p'] .= 'float:right;';
                break;
            case 'center':
                $classes['style-p'] .= 'margin:auto;';
                break;
        }

        // icon size
        $classes['style-a'] = 'style="';

        switch ($icon_size) {
            case 'tiny':
                $classes['style-a'] .= 'font-size: 11px;';
                $classes['style-a'] .= 'width: 20px;';
                $classes['style-a'] .= 'height: 20px;';
                $classes['style-a'] .= 'line-height: 20px;';
                break;
            case 'small':
                $classes['style-a'] .= 'font-size: 14px;';
                $classes['style-a'] .= 'width: 30px;';
                $classes['style-a'] .= 'height: 30px;';
                $classes['style-a'] .= 'line-height: 30px;';
                break;
            case 'normal':
                $classes['style-a'] .= 'font-size: 20px;';
                $classes['style-a'] .= 'width: 37px;';
                $classes['style-a'] .= 'height: 37px;';
                $classes['style-a'] .= 'line-height: 37px;';
                break;
            case 'large':
                $classes['style-a'] .= 'font-size: 30px;';
                $classes['style-a'] .= 'width: 45px;';
                $classes['style-a'] .= 'height: 45px;';
                $classes['style-a'] .= 'line-height: 45px;';
                break;
        }

        if ($style_icon == 'custom') {
            $classes['style-a'] .= 'background-color: ' . $background_color . ';';
            $classes['style-a'] .= 'color: ' . $icon_color . ';';
            $classes['style-a'] .= 'border-color: ' . $border_color . ';';
            $classes['style-a'] .= 'border-style: ' . $border_style . ';';
            $classes['style-a'] .= 'border-width: ' . $border_width . 'px;';
            $classes['style-a'] .= 'border-radius: ' . $border_radius . 'px;';
            $classes['style-a'] .= 'margin-left:' . $icon_spacing . 'px;';
            $classes['style-a'] .= 'margin-right:' . $icon_spacing . 'px;';
            $classes['style-a'] .= 'display:inline-block;text-align:center';
        }

        $classes['style-a'] .= '"';

        // enablle center element
        $classes['enable-center'] = ($enable_center == 'yes') ? 'edu-element-center' : '';

        // css class
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, ''));
        }

		// Generate HTML code.

        $html .='<div class="udetor-1"></div>';
		$html .= '<div style="'.$classes['style-p'].'" id="' . esc_attr( $id ) . '" class="edu-element edu-element-hsocials '.$classes['extra_class'].' '.$classes['enable-center'].' '.$css_class . '">';
            $html .= '<a class="edu-link-socials" href="#" '.$classes['style-a'].'>';
                // custom social
                $html .= '<i class="'.$socials['facebook'].'"' . $classes['style-icon'].'>';
                $html .= '</i>';
            $html .= '</a>';
            $html .= '<a class="edu-link-socials" href="#" '.$classes['style-a'].'>';
                // custom social
                $html .= '<i class="'.$socials['twitter'].'"' . $classes['style-icon'].'>';
                $html .= '</i>';
            $html .= '</a>';
        $html .= '<a class="edu-link-socials" href="#" '.$classes['style-a'].'>';
            // custom social
            $html .= '<i class="'.$socials['google-plus'].'"' . $classes['style-icon'].'>';
            $html .= '</i>';
            $html .= '</a>';
		$html .= '</div>';


		wp_reset_postdata();

		return apply_filters( 'netbase_shortcode_hsocials', force_balance_tags( $html ) );
	}


	/**
	 * Enqueue scripts and styles.
	 *
	 * @return  void
	 */
	public static function enqueue_scripts() {        
        
        // font-awesome
        wp_enqueue_style('font-awesome');
	}
}
